package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.ArrayList;
import java.util.List;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminStatusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SAVE_ENABLED = "save.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRBdm9jON5AoISFBhGBRUKwDAgmUCPKBIhKZD2EhRbhhfbeJN1rvHbt7zoUC8RP4CdDTINFRIQpqChrEX0CIghYxu2f77OSILWJZZ2tm3ps3c2/e/kAZJdGFXRKGWAZCsxrFmytbWw8qu9TRd6hyJPO1J1H0SaVRuoyG3FZcaXSxXDTwQgNeWPNqvieoaEMvFtGg0vucqiqlWqNznQhHqUKplV4M/UA2WVuiklhf//qZfuW+fJNGKPRB3SCMMtcNFU/SV0Rp5mo0Bp3qpMCJ2AEZkokd0DtiYmucKHWf1Ogz9ALliijrEwlkGs33PrLlsPjQ12iEuDUmSproQD3e0Oi649XwbiCZqhHpVKnCdUlchgOGbSV2PKGBGK+043zfMmY16q95LttmFMY4bRRjMwVe9TxOiYjLsnXCmWvHGI2j4/mSVbshmGZQ8JzKBY0u2Q2CLp9xKnE0ED5U2aYhv1kkFcoBO2Y0hFjtwRJxFDVFAxq+THNapNu6CRt2JCWaRjOBmA7oaqC1Jyy21WckvwkqPM4fEkGh2ZkORJzqROUaGzwozlRacTPxlhwinCh4tpOkT5E6bY9LNNNhNLAwji0ceyxVRhkZQFijqfJh1z+CVOT3qQN+N4Q2+2dy/OuH7+/XmyYfgN4TiaVtNwrm86XnU6mZaX0ycnigGS/cI/5iGVgohwO3BzybIKzUSIM46BdZy8DxXaKqQJHJffv4afLplxMovY4GuUfcdWLqN+BFVyVsweNu6N9etoqG9/rhecpog1VqGpqXscQEZ4LOEQ0nVwk0vRXCGmYT1tDSUhn4/Hu89G65uYoUSJv+Z3m8jswTlI262YtvHHPihQ/5igauFx9t0hmnzO+E37iAy/aJE2dlxnxodMklmsxVmHDBejCnAVy1A5h/1yzfdFc+E14wjyv/ywAW52TfC7TJ30xmOd+TjhtHMMwfe5LeGI7SkO9hFzkqSIVT91g03UYxDH8BQQuRcGYHAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminStatusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminStatusUI adminStatusUI = this;
    protected javax.swing.JButton cancel;
    protected javax.swing.JPanel content;
    protected javax.swing.JButton createStatus;
    protected java.lang.Boolean modified;
    protected javax.swing.JButton save;
    protected java.lang.Boolean valide;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Status> statuses;
    protected List<Status> deleted;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        createStatuses(false);
    }
    
    public List<Status> getStatuses(){
        return statuses;
    }
    
    public List<Status> getDeleted(){
        return deleted;
    }
    
    public void createStatuses(boolean triggeredByCancelButton) {
        int confirm = JOptionPane.DEFAULT_OPTION;
        if(triggeredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog(this,
                        _("vradi.admin.cancel.message"),
                        _("vradi.admin.cancel.title"),
                        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        }
        if(!triggeredByCancelButton || confirm == JOptionPane.YES_OPTION) {
            content.removeAll();
            jaxx.runtime.JAXXUtil.assignment(statuses = getHandler().getAllStatuses(), "statuses", com.jurismarches.vradi.ui.admin.content.AdminStatusUI.this);
            for (Status status : statuses){
                createStatus(status);
            }
            jaxx.runtime.JAXXUtil.assignment(deleted = new ArrayList<Status>(), "deleted", com.jurismarches.vradi.ui.admin.content.AdminStatusUI.this);
            setModified(false);
        }
    }
    
    protected void createNewStatus() {
        Status status = new StatusImpl();
        status.setValue(content.getComponentCount());
        status.setModifiable(true);
        statuses.add(status);
        createStatus(status);
    }
    
    protected void createStatus(Status status) {
    
        StatusEditionUI editionUI = new StatusEditionUI(this);
    
        status.addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                setModified(true);
            }
        });
    
        editionUI.setBean(status);
    
        content.add(editionUI);
        validate();
    }
    
    public void up(StatusEditionUI editionUI) {
         move(editionUI, -1);
    }
    
    public void down(StatusEditionUI editionUI) {
         move(editionUI, 1);
    }
    
    public void delete(StatusEditionUI editionUI) {
        remove(editionUI);
        deleted.add(editionUI.getBean());
        setModified(true);
    }
    
    public void remove(StatusEditionUI editionUI) {
    
        Status status = editionUI.getBean();
    
        // Remove in list
        statuses.remove(status);
    
        // Remove in UI
        content.remove(editionUI);
    }
    
    protected void move(StatusEditionUI editionUI, int inc) {
        Status status = editionUI.getBean();
    
        // Get index
        int index = statuses.indexOf(status) + inc;
    
        if (index > 0 && statuses.size() > index) {
    
            if (log.isDebugEnabled()) {
                log.debug("Move " + status.getName() + " to " + index);
            }
    
            remove(editionUI);
    
            // Add in list
            statuses.add(index, status);
    
            // Add in UI
            content.add(editionUI, index);
    
            revalidate();
            
            setModified(true);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminStatusUI() {
        $initialize();
    }

    public AdminStatusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        createStatuses(true);
    }

    public void doActionPerformed__on__createStatus(java.awt.event.ActionEvent event) {
        createNewStatus(); setModified(true);
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        getHandler().saveStatuses(this);setModified(false);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JButton getCreateStatus() {
        return createStatus;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public java.lang.Boolean getValide() {
        return valide;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setValide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.valide;
        this.valide = newValue;
        firePropertyChange(PROPERTY_VALIDE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminStatusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(createStatus, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(save, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createCreateStatus() {
        $objectMap.put("createStatus", createStatus = new javax.swing.JButton());
        
        createStatus.setName("createStatus");
        createStatus.setText(_("vradi.adminStatus.createStatus"));
        createStatus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createStatus"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminStatusUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(content);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        createStatus.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        save.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminStatusUI", this);
        createModified();
        createValide();
        deleted = new ArrayList<Status>();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminStatus.title"));
        createCreateStatus();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createContent();
        createCancel();
        createSave();
        // inline creation of adminStatusUI
        setName("adminStatusUI");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                save.setEnabled(isModified());
            }
        });
    }

}