/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.loadors.ClientUsersNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.ClientsAndUsersNodeLoadors;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.Map;
import java.util.Set;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyServiceEvent;

public class ClientNavigationTreeHelper
extends AdminNavigationTreeHelper {
    private static final Log log = LogFactory.getLog(ClientNavigationTreeHelper.class);

    public ClientNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(String.class, AdminBeanConstant.CLIENT.getCategoryName(), null, new ClientsAndUsersNodeLoadors());
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put event : " + event));
        }
        Map idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            VradiTreeNode parentNode;
            VradiTreeNode existingNode;
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            if (wikittyExtensions.contains("Client")) {
                existingNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId});
                if (existingNode != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Client modification occured");
                    }
                    parentNode = (VradiTreeNode)existingNode.getParent();
                    UIHelper.refreshNodeLater(this, parentNode.getId());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Client creation occured");
                    }
                    parentNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{AdminBeanConstant.CLIENT.getCategoryName()});
                    VradiTreeNode clientNode = ((ClientsAndUsersNodeLoadors)ClientNavigationTreeHelper.getChildLoador(ClientsAndUsersNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)this.getDataProvider());
                    UIHelper.refreshNodeLater(this, parentNode.getId());
                }
            }
            if (!wikittyExtensions.contains("User")) continue;
            existingNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId});
            if (existingNode != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User modification occured");
                }
                parentNode = ClientNavigationTreeHelper.getParentCategoryNode(existingNode, AdminBeanConstant.CLIENT.getCategoryName());
                UIHelper.refreshNodeLater(this, parentNode.getId());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"User creation occured");
            }
            User data = (User)VradiService.getWikittyProxy().restore(User.class, wikittyId);
            String clientId = data.getClient();
            VradiTreeNode clientNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{clientId});
            VradiTreeNode parentNode2 = (VradiTreeNode)this.findNode((NavNode)clientNode, new String[]{AdminBeanConstant.USER.getCategoryName()});
            VradiTreeNode userNode = ((ClientUsersNodeLoadors)ClientNavigationTreeHelper.getChildLoador(ClientUsersNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)this.getDataProvider());
            parentNode2.add(userNode);
            UIHelper.refreshNodeLater(this, parentNode2.getId());
        }
    }
}

