/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableModel;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author sletellier
 */
public class ThesaurusTreeTableModel extends NavigationTreeTableModel.MyDefaultTreeTableModel {

    private static final Log log = LogFactory.getLog(ThesaurusTreeTableModel.class);

    protected int columnsToDisplay = 3;

    @Override
    public Object getValueAt(Object node, int column) {
        Object result = "not found";
        NavigationTreeTableNode navigationNode = (NavigationTreeTableNode)node;
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO) navigationNode.getBean();
        if (thesaurus == null){
            return result;
        }
        switch (column) {
        case 0:
            Integer order = thesaurus.getOrder();
            if (order != null && order != 0){
                result = order + " - " + thesaurus.getName();
            } else {
                result = thesaurus.getName();
            }
            break;
        case 1:
            result = thesaurus.getFormsForThesaurus();
            break;
        case 2:
            result = thesaurus.getTagsAsString();
            break;
        }
        return result;
    }
    
    @Override
    public int getColumnCount() {
        return columnsToDisplay;
    }

    @Override
    public String getColumnName(int column) {
        // Copied from DefaultTableModel.
        Object id = null;

        // This test is to cover the case when
        // getColumnCount has been subclassed by mistake ...
        if (column < columnIdentifiers.size() && (column >= 0)) {
            id = columnIdentifiers.get(column);
        }

        return (id == null) ? super.getColumnName(column) : id.toString();
    }
}
