/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.email.renderers;

import com.jurismarches.vradi.services.dto.VradiSendingDTO;

import javax.swing.*;
import java.awt.*;

/**
 * User: letellier
 */
public class SendingRenderer extends DefaultListCellRenderer{

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        VradiSendingDTO sending = (VradiSendingDTO)value;

        String text = "";
        if (sending.getClientDTO() != null){
            text = sending.getClientDTO().getName();
        } else if (sending.getUserDTO() != null){
            text = sending.getUserDTO().getClientName() + " - " + sending.getUserDTO().getName();
        } else if (sending.getGroupDTO() != null){
            text = sending.getGroupDTO().getName();
        }

        return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
    }
}
