package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import org.jdesktop.swingx.JXDatePicker;
import org.sharengo.wikitty.BusinessEntityWikitty;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminUserUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<User> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_IN_GROUP = "inGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_USER_ADDRESS_TEXT = "userAddress.text";
    public static final String BINDING_USER_EMAIL_TEXT = "userEmail.text";
    public static final String BINDING_USER_GROUPS_VISIBLE = "userGroups.visible";
    public static final String BINDING_USER_INSCRIPTION_DATE_DATE = "userInscriptionDate.date";
    public static final String BINDING_USER_NAME_TEXT = "userName.text";
    public static final String BINDING_USER_PHONE_TEXT = "userPhone.text";
    public static final String BINDING_USER_SERVICE_TEXT = "userService.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";
    private static final String BINDING_$JBUTTON2_VISIBLE = "$JButton2.visible";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL7_VISIBLE = "$JLabel7.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminUserForm;
    protected com.jurismarches.vradi.services.dto.VradiUserDTO bean;
    protected java.lang.Boolean inGroup;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected javax.swing.JTextField userAddress;
    protected javax.swing.JTextField userEmail;
    protected jaxx.runtime.swing.ListSelectorUI< Group > userGroups;
    protected org.jdesktop.swingx.JXDatePicker userInscriptionDate;
    protected javax.swing.JTextField userName;
    protected javax.swing.JTextField userPhone;
    protected javax.swing.JTextField userService;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiUserDTO > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminUserUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JButton $JButton3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        addPCSLogger();
        addBeanPCSLogger(bean);
        addBeanModifiedPCS(bean);
        userGroups.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from groups");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        requestListUI.init();
    
        java.util.List<Group> toCombo = getHandler().getAllGroups();
        java.util.List<Group> toList  = new java.util.ArrayList<Group>(toCombo);
    
        for (java.util.Iterator<Group> it = toList.iterator(); it.hasNext();) {
            Group group = it.next();
            if (group.getUser() == null || !group.getUser().contains(bean.getWikittyId())) {
                it.remove();
                log.debug("user does NOT use group " + group.getName());
            } else {
                toCombo.remove(group);
                log.debug("user use group " + group.getName());
            }
        }
        userGroups.init(toCombo, toList);
        NavigationTreeNode parentNode = getHelper().getParentGroupNode(getHelper().getSelectedNode(this));
        setInGroup(parentNode != null);
    
        lastModified.removeAll();
        if(bean != null && bean.getLastModified() != null && bean.getLastModifier() != null) {
            String labelText = String.format(_("vradi.entity.lastModified.date.user"), bean.getLastModified(), bean.getLastModifier());
            lastModified.add(new JLabel(labelText));
        }
        lastModified.validate();
    }
    
    @Override
    public void save() {
        // groups to save
        Map<String, Group> groups = new HashMap<String, Group>();
    
        this.bean.setLastModified(new java.util.Date());
        this.bean.setLastModifier(getContextValue(VradiUser.class).getName());
        
        User user = (User) getHelper().getSelectedBean(this);
        if(!user.getExtensionNames().contains(ModificationTag.EXT_MODIFICATION_TAG)) {
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty) user;
            entityWikitty.getWikitty().addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
        }
        
        this.bean.toWikitty(user);
        log.info("user to save " + user.getName());
    
        String wikittyId = user.getWikittyId();
        NavigationTreeNode parentNode = getHelper().getParentClientNode(getHelper().getSelectedNode(this));
        
        if (parentNode != null) {
            // user under a client
            Client client = (Client) parentNode.getBean(this);
            //client.addUser(wikittyId);
            user.setClient(client.getWikittyId());
    
            for (Group g : userGroups.getComboDatas()) {
                if (g.getUser() != null && g.getUser().contains(wikittyId)) {
                    // group was containing user, but no more
                    g.removeUser(wikittyId);
                    // mark it for save
                    groups.put(g.getWikittyId(), g);
                }
            }
            
            for (Group g : userGroups.getListDatas()) {
                if (g.getUser() == null || !g.getUser().contains(wikittyId)) {
                    // group was not containing client, but do now
                    g.addUser(wikittyId);
                    // mark it for save
                    groups.put(g.getWikittyId(), g);
                }
            }
            
            user = getHandler().saveUser(this, getHelper(), user, client, groups.values());
            
        } else {
            parentNode = getHelper().getParentGroupNode(getHelper().getSelectedNode(this));
    
            if (parentNode != null) {
                // user under a group
                Group g = (Group) parentNode.getBean(this);
                g.addUser(wikittyId);
                groups.put(g.getWikittyId(), g);
            }
            
            user = getHandler().saveUser(this, getHelper(), user, null, groups.values());
        }
        
        userGroups.setModified(false);
    }
    
    @Override
    protected void updateBeanFromEntity(User bean) {
        this.bean.fromWikitty(bean);
    }
    
    protected void deleteFromGroup() {
        getHandler().removeFromGroup(this, getHelper());
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminUser.title", getStringValue(name));
    }
    
    protected void openAddressInBrowser() {
        UIHelper.openAddressInBrowser(bean.getAddress());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminUserUI() {
        super();
        $initialize();
    }

    public AdminUserUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiUserDTO > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().createUser(this, getHelper());setModified(true);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        deleteFromGroup();
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        openAddressInBrowser();
    }

    public void doActionPerformed__on__userInscriptionDate(java.awt.event.ActionEvent event) {
        bean.setInscriptionDate(userInscriptionDate.getDate());
    }

    public void doKeyReleased__on__userAddress(java.awt.event.KeyEvent event) {
        bean.setAddress(userAddress.getText());
    }

    public void doKeyReleased__on__userEmail(java.awt.event.KeyEvent event) {
        bean.setEmail(userEmail.getText());
    }

    public void doKeyReleased__on__userName(java.awt.event.KeyEvent event) {
        bean.setName(userName.getText());
    }

    public void doKeyReleased__on__userPhone(java.awt.event.KeyEvent event) {
        bean.setPhone(userPhone.getText());
    }

    public void doKeyReleased__on__userService(java.awt.event.KeyEvent event) {
        bean.setService(userService.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminUserForm() {
        return adminUserForm;
    }

    public com.jurismarches.vradi.services.dto.VradiUserDTO getBean() {
        return bean;
    }

    public java.lang.Boolean getInGroup() {
        return inGroup;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    public javax.swing.JTextField getUserAddress() {
        return userAddress;
    }

    public javax.swing.JTextField getUserEmail() {
        return userEmail;
    }

    public jaxx.runtime.swing.ListSelectorUI< Group > getUserGroups() {
        return userGroups;
    }

    public org.jdesktop.swingx.JXDatePicker getUserInscriptionDate() {
        return userInscriptionDate;
    }

    public javax.swing.JTextField getUserName() {
        return userName;
    }

    public javax.swing.JTextField getUserPhone() {
        return userPhone;
    }

    public javax.swing.JTextField getUserService() {
        return userService;
    }

    public java.lang.Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setInGroup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.inGroup;
        this.inGroup = newValue;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminUserForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminUserForm.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(SwingUtil.boxComponentWithJxLayer(userName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userService, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userAddress, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JButton3, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userPhone, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(SwingUtil.boxComponentWithJxLayer(userEmail), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel6, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userInscriptionDate, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel7, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userGroups, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminUserForm, BorderLayout.NORTH);
        body.add(requestListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setFieldRepresentation("email", userEmail);
        validator.setFieldRepresentation("name", userName);
    }

    protected void createAdminUserForm() {
        $objectMap.put("adminUserForm", adminUserForm = new jaxx.runtime.swing.Table());
        adminUserForm.setName("adminUserForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiUserDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = null);
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        requestListUI.setName("requestListUI");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createUserAddress() {
        $objectMap.put("userAddress", userAddress = new javax.swing.JTextField());
        userAddress.setName("userAddress");
        userAddress.setColumns(15);
        userAddress.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userAddress"));
    }

    protected void createUserEmail() {
        $objectMap.put("userEmail", userEmail = new javax.swing.JTextField());
        userEmail.setName("userEmail");
        userEmail.setColumns(15);
        userEmail.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userEmail"));
    }

    protected void createUserGroups() {
        $objectMap.put("userGroups", userGroups = new jaxx.runtime.swing.ListSelectorUI< Group >());
        userGroups.setName("userGroups");
        userGroups.setShowHidor(true);
        ((javax.swing.JToolBar) userGroups.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) userGroups.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createUserInscriptionDate() {
        $objectMap.put("userInscriptionDate", userInscriptionDate = new org.jdesktop.swingx.JXDatePicker());
        userInscriptionDate.setName("userInscriptionDate");
        userInscriptionDate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__userInscriptionDate"));
    }

    protected void createUserName() {
        $objectMap.put("userName", userName = new javax.swing.JTextField());
        userName.setName("userName");
        userName.setColumns(15);
        userName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userName"));
    }

    protected void createUserPhone() {
        $objectMap.put("userPhone", userPhone = new javax.swing.JTextField());
        userPhone.setName("userPhone");
        userPhone.setColumns(15);
        userPhone.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userPhone"));
    }

    protected void createUserService() {
        $objectMap.put("userService", userService = new javax.swing.JTextField());
        userService.setName("userService");
        userService.setColumns(15);
        userService.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userService"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiUserDTO >(com.jurismarches.vradi.services.dto.VradiUserDTO.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        $JPanel0.add($JButton2);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminUserForm();
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 15 property setters
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        $JButton2.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        $HidorButton0.setHideTip(_("vradi.adminUser.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminUser.showForm"));
        $HidorButton0.setTarget(adminUserForm);
        $HidorButton0.setTargetVisible(true);
        adminUserForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton3.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        userGroups.setAddToComboTip(_("vradi.adminUser.removeGroup"));
        userGroups.setAddToListTip(_("vradi.adminUser.addGroup"));
        userGroups.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        $JLabel0.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        $JLabel0.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 17 data bindings
        $registerDefaultBindings();
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createInGroup();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont((float) 20));
        }
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont($JLabel0.getFont().getStyle() | Font.BOLD));
        }
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminUser.createUser"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminUser.deleteUser"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        $JButton2.setName("$JButton2");
        $JButton2.setToolTipText(_("vradi.adminUser.deleteUserFromGroup"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createAdminUserForm();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminUser.name"));
        createUserName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminUser.service"));
        createUserService();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminUser.adresse"));
        createUserAddress();
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        $JButton3.setName("$JButton3");
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminUser.tel"));
        createUserPhone();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.adminUser.mail"));
        createUserEmail();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("vradi.adminUser.inscriptionDate"));
        createUserInscriptionDate();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("vradi.adminClient.listGroup"));
        createUserGroups();
        createRequestListUI();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("wikittyId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("wikittyId", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    $JLabel0.setText(_(updateTitle(bean.getName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setVisible(isInGroup());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_USER_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(userName, bean.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_USER_SERVICE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("service", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(userService, bean.getService());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("service", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_USER_ADDRESS_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("address", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(userAddress, bean.getAddress());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("address", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_USER_PHONE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("phone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(userPhone, bean.getPhone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("phone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_USER_EMAIL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("email", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(userEmail, bean.getEmail());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("email", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_USER_INSCRIPTION_DATE_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("inscriptionDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    userInscriptionDate.setDate(bean.getInscriptionDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("inscriptionDate", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL7_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel7.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_GROUPS_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                userGroups.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}