package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.ModifThesaurusModel;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.TreeNodeImpl;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusEditUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_CLONE = "beanClone";
    public static final String PROPERTY_HELPER = "helper";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_MODIF_MODEL = "modifModel";
    public static final String PROPERTY_MOVED = "moved";
    public static final String PROPERTY_NODE_SELECTED_PARENT = "nodeSelectedParent";
    public static final String PROPERTY_SAVE = "save";
    public static final String PROPERTY_TITLE_THESAURUS = "titleThesaurus";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_PATH_FIELD_TEXT = "pathField.text";
    public static final String BINDING_TAGS_FIELD_TEXT = "tagsField.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWT28bRRSfmDiJndKUhEZBDVKgEQKpWjclIFAKbZpgtZWTRrWpKnxh7Hm1J9rdWWZmHeeC+Ah8BODMBYkbJ8SBMwcuiK+AEAeuiDez6904WTsrrQ/27vvze78378/4+79IWUnyxjEdDh0Z+pp74Dzeff78SecYunofVFfyQAtJos9MiZTaZJElcqXJzXbDuNdi99qe8ALhg3/Ge6dBqkqfuqD6AFqT18c9ukrVmol6ZxiEcoSakMpC/eafv0tfs6++LREyDJDdGqaycZlXmslsg5Q402QZIw1ozaV+D2lI7veQ78tGtudSpQ6pB1+QL8l8g8wFVCKYJm/mT9liWP9hoMmS7oOioQzVJ4zrTx9pUusKzzkOJVcelV3UOgNJGXdC7lDmcd9pjXsEgUWb02SuD24AUpP3JkNEJioFaUmAh1aYAlU9wfiLA8HA1WR7MphnLJRzYKwTQOuWYs12gPqTKSmQA97FV6aF88yIEqD91pMUpmJg9lw8VCN4NVUs+xivCS52J7CjuBy3xoquTrCEjk8HvEc1F75zmDweovMZrooOQJNXTKkdU37ngRAuBk5NrmquXUg4anItNY56JbVdsMfIgZn39VRe9sTggnB+s0U7LtzWZC2DvNUZy0qKvvm4QTvgosey4TCMTSOpMdrEY7N0G/BCn3fbMu/vWLMEclFIBtK0lcAueiuDB1idcxh6nZHhOETFx+moc3BxjlbHaLVgqK1i3GHE504Gn0pAdT/xOaesGmVUeE1WxkI9CLUWfnacd7PiaNpTSZw72Y7bGY5XsKs97Lg44esXEt6VQM/F2ozp3TaCDycot84qJbkxVgpcj066HtP9NdMmZRmiGHuofXGjPkVVtEvXzu1SA2i1/62u/P7Tnz/WRwv0Bsa+nml6Zv/jYgukMIuHm9BL0fYMNXdrBzTYaZOKslWyl8N6BrFmrEZyGC+aPuPuPKSqjxDl+T9+/mX1899eIqU6qbqCsjo19o+wcH2JpyBcNgzu3beMrpws4Pc1w81uRN7rY38s3+W+y33YoBqHtBNq+HiIB7GecRAJm07l139Xmj/cHx3GDJJ7baJ5eiDlz8hcFM3eJ/FVkXl/LAYKQibSKyHrkpgxv9UgXhUN+32Uma1LTwW2D7l6l1FNNzrcZ9iJmKlxadkUzNOz3Ii4qRi1u6RZAMTuIKNuFwA5wZu5X5DJrMaRnELk7UsxjFhMYXErB4sKDbU4EkEYTKHi5ABaiMfudAqhPDhLOEEnllC6OAvQqhi4p6Bg2lHnyi9UUMdxL4ozjzhN3iuWV1L5CQhbhXtnuzCH9/PMAO9OrfAHhfMojrBT+CQ+KszhXmEOu7kQvpuCsF84i3wI0zjU8wwY+Ob/KSsEc1kqBuF/JgRH7Z8OAAA=";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.ThesaurusEditUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.services.dto.VradiThesaurusDTO bean;
    protected com.jurismarches.vradi.services.dto.VradiThesaurusDTO beanClone;
    protected javax.swing.JTextArea commentField;
    protected com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper helper;
    protected com.jurismarches.vradi.ui.models.ModifThesaurusModel modifModel;
    protected java.lang.Boolean modified;
    protected java.lang.Boolean moved;
    protected javax.swing.JTextField nameField;
    protected jaxx.runtime.swing.navigation.NavigationNode nodeSelectedParent;
    protected jaxx.runtime.swing.editor.NumberEditor orderEditor;
    protected javax.swing.JLabel pathField;
    protected javax.swing.JButton pathSelect;
    protected java.lang.Boolean save;
    protected javax.swing.JTextField tagsField;
    protected ThesaurusEditUI thesaurusEditUI = this;
    protected java.lang.String titleThesaurus;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void init(ThesaurusTreeHelper helper, VradiThesaurusDTO newThesaurus, VradiThesaurusDTO cloned, ModifThesaurusModel modifThesaurusModel, String title, final boolean isCreating) {
        setHelper(helper);
        setContextValue(helper);
        setBean(newThesaurus);
        setBeanClone(cloned);
        getBeanClone().addPropertyChangeListener(new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                setModified(true);
                if (!isCreating && modifModel != null){
                    Object oldValue = evt.getOldValue();
                    if (oldValue instanceof String || oldValue instanceof Integer){
                        modifModel.prepareAttributeModif(beanClone, evt.getPropertyName(), String.valueOf(oldValue));
                    }
                }
            }
        });
        setModifModel(modifThesaurusModel);
        setTitleThesaurus(title);
        orderEditor.setBean(getBeanClone());
        orderEditor.init();
        orderEditor.setModel(getBeanClone().getOrder());
        setVisible(true);
    }
    
    protected ThesaurusHandler getHandler() {
        return UIHelper.getHandler(this, ThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    
    //    registerDataBinding(new SimpleJAXXObjectBinding(this, PROPERTY_BEAN, true ,"bean") {
    //        @Override
    //        public void processDataBinding() {
    //            setModified(true);
    //        }
    //    });
    }
    
    protected void valid(){
        String name = nameField.getText();
        // Search existing
        VradiThesaurusDTO existing = getHandler().isNameExisting(getHelper().getRootThesaurus(), name);
        if (!name.equals(bean.getName()) && existing != null){
            JOptionPane.showMessageDialog(this, _("vradi.thesaurus.nameIsExisting", name, existing.getNamePath("/")), _("vradi.thesaurus.nameIsExistingTitle"), JOptionPane.ERROR_MESSAGE);
            setSave(false);
            return;
        }
        if (isMoved()){
            getHandler().applyMoveThesaurus(this, getHelper(), getBeanClone(), (NavigationTreeTableNode) getNodeSelectedParent(), modifModel);
        }
        bean.setComment(beanClone.getComment());
        bean.setName(beanClone.getName());
        bean.setTagsAsString(beanClone.getTagsAsString());
    //    bean.setParentThesaurus(beanClone.getParentThesaurus());
        bean.setToCreate(beanClone.isToCreate());
        bean.setToDelete(beanClone.isToDelete());
        bean.setToSave(beanClone.isToSave());
        bean.setOrder(beanClone.getOrder());
    
        setSave(true);
        close();
    }
    
    protected void close(){
        setVisible(false);
        dispose();
    }
    
    protected void selectPath(){
        setNodeSelectedParent(getHandler().moveThesaurus(this, getHelper(), getBeanClone()));
        setMoved(getNodeSelectedParent() != null);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusEditUI() {
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        valid();
    }

    public void doActionPerformed__on__pathSelect(java.awt.event.ActionEvent event) {
        selectPath();
    }

    public void doKeyReleased__on__commentField(java.awt.event.KeyEvent event) {
        beanClone.setComment(commentField.getText());
    }

    public void doKeyReleased__on__nameField(java.awt.event.KeyEvent event) {
        beanClone.setName(nameField.getText());
    }

    public void doKeyReleased__on__tagsField(java.awt.event.KeyEvent event) {
        getBeanClone().setTagsAsString(tagsField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.services.dto.VradiThesaurusDTO getBean() {
        return bean;
    }

    public com.jurismarches.vradi.services.dto.VradiThesaurusDTO getBeanClone() {
        return beanClone;
    }

    public javax.swing.JTextArea getCommentField() {
        return commentField;
    }

    public com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper getHelper() {
        return helper;
    }

    public com.jurismarches.vradi.ui.models.ModifThesaurusModel getModifModel() {
        return modifModel;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public java.lang.Boolean getMoved() {
        return moved;
    }

    public javax.swing.JTextField getNameField() {
        return nameField;
    }

    public jaxx.runtime.swing.navigation.NavigationNode getNodeSelectedParent() {
        return nodeSelectedParent;
    }

    public jaxx.runtime.swing.editor.NumberEditor getOrderEditor() {
        return orderEditor;
    }

    public javax.swing.JLabel getPathField() {
        return pathField;
    }

    public javax.swing.JButton getPathSelect() {
        return pathSelect;
    }

    public java.lang.Boolean getSave() {
        return save;
    }

    public javax.swing.JTextField getTagsField() {
        return tagsField;
    }

    public java.lang.String getTitleThesaurus() {
        return titleThesaurus;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isMoved() {
        return moved !=null && moved;
    }

    public java.lang.Boolean isSave() {
        return save !=null && save;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.services.dto.VradiThesaurusDTO newValue) {
        com.jurismarches.vradi.services.dto.VradiThesaurusDTO oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setBeanClone(com.jurismarches.vradi.services.dto.VradiThesaurusDTO newValue) {
        com.jurismarches.vradi.services.dto.VradiThesaurusDTO oldValue = this.beanClone;
        this.beanClone = newValue;
        firePropertyChange(PROPERTY_BEAN_CLONE, oldValue, newValue);
    }

    public void setHelper(com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper newValue) {
        com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper oldValue = this.helper;
        this.helper = newValue;
        firePropertyChange(PROPERTY_HELPER, oldValue, newValue);
    }

    public void setModifModel(com.jurismarches.vradi.ui.models.ModifThesaurusModel newValue) {
        com.jurismarches.vradi.ui.models.ModifThesaurusModel oldValue = this.modifModel;
        this.modifModel = newValue;
        firePropertyChange(PROPERTY_MODIF_MODEL, oldValue, newValue);
    }

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setMoved(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.moved;
        this.moved = newValue;
        firePropertyChange(PROPERTY_MOVED, oldValue, newValue);
    }

    public void setNodeSelectedParent(jaxx.runtime.swing.navigation.NavigationNode newValue) {
        jaxx.runtime.swing.navigation.NavigationNode oldValue = this.nodeSelectedParent;
        this.nodeSelectedParent = newValue;
        firePropertyChange(PROPERTY_NODE_SELECTED_PARENT, oldValue, newValue);
    }

    public void setSave(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.save;
        this.save = newValue;
        firePropertyChange(PROPERTY_SAVE, oldValue, newValue);
    }

    public void setTitleThesaurus(java.lang.String newValue) {
        java.lang.String oldValue = this.titleThesaurus;
        this.titleThesaurus = newValue;
        firePropertyChange(PROPERTY_TITLE_THESAURUS, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusEditUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanClone() {
        $objectMap.put("beanClone", beanClone = null);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new javax.swing.JTextArea());
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createHelper() {
        $objectMap.put("helper", helper = null);
    }

    protected void createModifModel() {
        $objectMap.put("modifModel", modifModel = null);
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createMoved() {
        $objectMap.put("moved", moved = false);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new javax.swing.JTextField());
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createNodeSelectedParent() {
        $objectMap.put("nodeSelectedParent", nodeSelectedParent = null);
    }

    protected void createOrderEditor() {
        $objectMap.put("orderEditor", orderEditor = new jaxx.runtime.swing.editor.NumberEditor(this));
        orderEditor.setName("orderEditor");
        orderEditor.setProperty("order");
    }

    protected void createPathField() {
        $objectMap.put("pathField", pathField = new javax.swing.JLabel());
        pathField.setName("pathField");
    }

    protected void createPathSelect() {
        $objectMap.put("pathSelect", pathSelect = new javax.swing.JButton());
        pathSelect.setName("pathSelect");
        pathSelect.setText(_("vradi.adminThesaurus.move"));
        pathSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pathSelect"));
    }

    protected void createSave() {
        $objectMap.put("save", save = false);
    }

    protected void createTagsField() {
        $objectMap.put("tagsField", tagsField = new javax.swing.JTextField());
        tagsField.setName("tagsField");
        tagsField.setColumns(15);
        tagsField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__tagsField"));
    }

    protected void createTitleThesaurus() {
        $objectMap.put("titleThesaurus", titleThesaurus = "");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusEditUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.2, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(orderEditor, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(nameField, new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.2, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(pathField, new GridBagConstraints(1, 2, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(pathSelect, new GridBagConstraints(2, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.2, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(tagsField, new GridBagConstraints(1, 3, 2, 1, 0.8, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(commentField, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 6, 2, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(2, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        setTitle(_(titleThesaurus));
        orderEditor.setAutoPopup(false);
        orderEditor.setShowPopupButton(false);
        orderEditor.setShowReset(true);
        orderEditor.setUseFloat(false);
        orderEditor.setUseSign(false);
        pathSelect.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("move"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("accept"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 6 data bindings
        $registerDefaultBindings();
        $objectMap.put("thesaurusEditUI", this);
        createHelper();
        createModifModel();
        createBean();
        createBeanClone();
        createNodeSelectedParent();
        createSave();
        createTitleThesaurus();
        createModified();
        createMoved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminThesaurus.orderName"));
        createOrderEditor();
        createNameField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminThesaurus.path"));
        createPathField();
        createPathSelect();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminThesaurus.tags"));
        createTagsField();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminThesaurus.comment"));
        createCommentField();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.validate"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of thesaurusEditUI
        setName("thesaurusEditUI");
        SwingUtil.setComponentHeight(thesaurusEditUI,400);
        thesaurusEditUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        SwingUtil.setComponentWidth(thesaurusEditUI,600);
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"titleThesaurus") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(getTitleThesaurus()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("beanClone", this);
                if (getBeanClone() != null) {
                    getBeanClone().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBeanClone() != null) {
                    jaxx.runtime.SwingUtil.setText(nameField, getBeanClone().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("beanClone", this);
                if (getBeanClone() != null) {
                    getBeanClone().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PATH_FIELD_TEXT, true ,"beanClone" ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (getHelper() != null) {
                    pathField.setText(_(getBeanClone() == null ? "/" :                         getBeanClone().getParentPath(getHelper().getPathSeparator())));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TAGS_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("beanClone", this);
                if (getBeanClone() != null) {
                    getBeanClone().addPropertyChangeListener("tagsAsString", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBeanClone() != null) {
                    jaxx.runtime.SwingUtil.setText(tagsField, getBeanClone().getTagsAsString());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("beanClone", this);
                if (getBeanClone() != null) {
                    getBeanClone().removePropertyChangeListener("tagsAsString", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("beanClone", this);
                if (getBeanClone() != null) {
                    getBeanClone().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBeanClone() != null) {
                    jaxx.runtime.SwingUtil.setText(commentField, getBeanClone().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("beanClone", this);
                if (getBeanClone() != null) {
                    getBeanClone().removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isModified());
            }
        });
    }

}