/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package com.jurismarches.vradi.ui.admin;

import java.util.Collection;

import javax.swing.tree.TreeModel;

import jaxx.runtime.swing.navigation.NavigationNode;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.tree.TreeFilter;
import org.sharengo.wikitty.WikittyExtension;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;

/**
 * Implementation of admin navigation tree filter.
 * 
 * @author chatellier
 * @version $Revision: 707 $
 * 
 * Last update : $Date: 2010-04-15 10:46:34 +0200 (jeu., 15 avril 2010) $
 * By : $Author: chatellier $
 */
public class AdminNavTreeFilter implements TreeFilter {

    static private final Log log = LogFactory.getLog(AdminNavTreeFilter.class);

    protected String filterString;

    public AdminNavTreeFilter(String filterString) {
        this.filterString = filterString.toLowerCase();
    }

    /*
     * @see org.nuiton.widget.tree.TreeFilter#include(javax.swing.tree.TreeModel, java.lang.Object)
     */
    @Override
    public boolean include(TreeModel model, Object node) {

        // empty filter, no filtering
        if (StringUtils.isEmpty(filterString)) {
            return true;
        }

        // filter real user object
        if (log.isInfoEnabled()) {
            log.info("Todo filter string : " + filterString + " on " + node);
        }

        boolean result = true;
        NavigationNode<?> ntNode = (NavigationNode<?>)node;
        Object bean = ntNode.getBean();

        // les noeuds intermédiaires (filtres si un des sous neuds match)
        if (bean instanceof Collection<?>) {
            result = false;
            for (int i = 0 ; i < ntNode.getChildCount() && result == false; i++) {
                NavigationNode<?> child = ntNode.getChildAt(i);
                result = include(model, child);
            }
        }

        // un client (si son nom match ou ses clients)
        else if (bean instanceof Client) {
            Client client = (Client)bean;
            if (!client.getName().toLowerCase().contains(filterString)) {
                result = false;
                
                for (int i = 0 ; i < ntNode.getChildCount() && result == false; i++) {
                    NavigationNode<?> child = ntNode.getChildAt(i);
                    result = include(model, child);
                }
            }
        }

        // un utilisateur (filtre s'il match ou son client match)
        else if (bean instanceof User) {
            User user = (User)bean;
            if (!user.getName().toLowerCase().contains(filterString)) {
                result = false;
            }

            NavigationNode<?> clientNode = ntNode.getParent().getParent();
            
            // cas ou le parent est un client
            if (clientNode instanceof Client) {
                Client client = (Client)clientNode.getBean();
                if (client.getName().toLowerCase().contains(filterString)) {
                    result = true;
                }
            }
            // cas ou le parent est un group
            else if (clientNode instanceof Group) {
                Group group = (Group)clientNode.getBean();
                if (group.getName().toLowerCase().contains(filterString)) {
                    result = true;
                }
            }
        }

        // group
        else if (bean instanceof Group) {
            Group group = (Group)bean;
            
            if (!group.getName().toLowerCase().contains(filterString)) {
                result = false;
                
                for (int i = 0 ; i < ntNode.getChildCount() && result == false; i++) {
                    NavigationNode<?> child = ntNode.getChildAt(i);
                    result = include(model, child);
                }
            }
        }

        // un formulaire (filtre sur son nom seulement)
        else if (bean instanceof WikittyExtension) {
            WikittyExtension form = (WikittyExtension)bean;
            //log.info("form.getObjet()" + form.getObjet());
            if (!form.getName().toLowerCase().contains(filterString)) {
                result = false;
            }
        }
        
        // flux xml
        else if (bean instanceof XmlStream) {
            XmlStream xmlStream = (XmlStream)bean;
            
            if (!xmlStream.getName().toLowerCase().contains(filterString)) {
                result = false;
            }
        }
        
        
        return result;
    }

}
