package com.jurismarches.vradi.ui;

import java.util.Comparator;

import jaxx.runtime.swing.navigation.NavigationNode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.services.dto.VradiUserDTO;

/**
 * VradiComparators.
 *
 * @author schorlet
 * @version $Revision: 856 $ $Date: 2010-05-06 11:45:36 +0200 (jeu., 06 mai 2010) $
 * @since 12 mars 2010 16:56:44
 */
public class VradiComparators {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(VradiComparators.class);

    public static class BusinessEntityComparator<T extends BusinessEntity> implements Comparator<T> {
        final String extension;
        final String field;
        
        public BusinessEntityComparator(String extension, String field) {
            this.extension = extension;
            this.field = field;
        }
        
        @Override
        public int compare(T o1, T o2) {
            if (o1 != null && o2 != null) {

                Object name1 = o1.getField(extension, field);
                Object name2 = o2.getField(extension, field);
                
                if (name1 != null && name2 != null) {
                    String string1 = WikittyUtil.toString(name1);
                    String string2 = WikittyUtil.toString(name2);
                    
                    return string1.compareToIgnoreCase(string2);

                } else if (name1 != null) {
                    return 1;

                } else if (name2 != null) {
                    return -1;
                }

            } else if (o1 != null) {
                return 1;

            } else if (o2 != null) {
                return -1;
            }

            return 0;
        }
    };
    
    public static final Comparator<Client> CLIENT_COMPARATOR =
        new BusinessEntityComparator<Client>(Client.EXT_CLIENT, Client.FIELD_NAME);

    public static final Comparator<User> USER_COMPARATOR =
        new BusinessEntityComparator<User>(User.EXT_USER, User.FIELD_NAME);

    public static final Comparator<Group> GROUP_COMPARATOR =
        new BusinessEntityComparator<Group>(Group.EXT_GROUP, Group.FIELD_NAME);

    public static final Comparator<Status> STATUSES_COMPARATOR =
        new BusinessEntityComparator<Status>(Status.EXT_STATUS, Status.FIELD_VALUE);

    public static final Comparator<XmlStream> XML_STREAM_COMPARATOR =
        new BusinessEntityComparator<XmlStream>(XmlStream.EXT_XMLSTREAM, XmlStream.FIELD_NAME);

    public static final Comparator<WikittyExtension> EXTENSION_COMPARATOR = new Comparator<WikittyExtension>() {
        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            if (o1 != null && o2 != null) {

                String name1 = o1.getName();
                String name2 = o2.getName();
                
                if (name1 != null && name2 != null) {
                    return name1.compareToIgnoreCase(name2);

                } else if (name1 != null) {
                    return 1;

                } else if (name2 != null) {
                    return -1;
                }

            } else if (o1 != null) {
                return 1;

            } else if (o2 != null) {
                return -1;
            }

            return 0;
        }
    };

    /**
     * Compares VradiUserDTO by getClientName() + ":" + getName().
     */
    public static final Comparator<VradiUserDTO> USERDTO_COMPARATOR = new Comparator<VradiUserDTO>() {
        @Override
        public int compare(VradiUserDTO o1, VradiUserDTO o2) {
            if (o1 != null && o2 != null) {

                String name1 = o1.getClientName() + ":" + o1.getName();
                String name2 = o2.getClientName() + ":" + o2.getName();
                return name1.compareToIgnoreCase(name2);

            } else if (o1 != null) {
                return 1;

            } else if (o2 != null) {
                return -1;
            }

            return 0;
        }
    };


    public static final Comparator<NavigationNode> RENDERER_COMPARATOR = new Comparator<NavigationNode>() {

        @Override
        public int compare(NavigationNode o1, NavigationNode o2) {
            String label1 = o1.getRenderer().toString();
            String label2 = o2.getRenderer().toString();
            if (label1 == null || label2 == null){
                return 0;
            }
            return label1.compareToIgnoreCase(label2);
        }
    };

    /**
     * Compares VradiThesaurusDTO by namePath : parentPath/getOrder() + ":" + getName().
     */
    public static final Comparator<VradiThesaurusDTO> THESAURUS_NAME_PATH_COMPARATOR = new Comparator<VradiThesaurusDTO>() {
        @Override
        public int compare(VradiThesaurusDTO o1, VradiThesaurusDTO o2) {
            return o1.getNamePath("/").compareTo(o2.getNamePath("/"));
        }
    };

    /**
     * Compares VradiThesaurusDTO by getOrder() + ":" + getName().
     */
    public static final Comparator<VradiThesaurusDTO> THESAURUS_COMPARATOR = new Comparator<VradiThesaurusDTO>() {
        @Override
        public int compare(VradiThesaurusDTO o1, VradiThesaurusDTO o2) {
            int result = 0;

            if (o1 != null && o2 != null) {
                if ((o1.getOrder() == 0 && o2.getOrder() == 0) || o1.getOrder() == o2.getOrder()){
                    result = o1.getName().compareToIgnoreCase(o2.getName());
                } else if (o1.getOrder() != 0 && o2.getOrder() != 0) {
                    result = (new Integer(o1.getOrder()).compareTo(new Integer(o2.getOrder())));
                } else if (o1.getOrder() != 0 && o2.getOrder() == 0) {
                    result =  new Integer(o1.getOrder()).compareTo(Integer.MAX_VALUE);
                } else if (o1.getOrder() == 0 && o2.getOrder() != 0) {
                    result =  new Integer(o2.getOrder()).compareTo(Integer.MIN_VALUE);
                }
            }
            return result;
        }
    };
    
    public static final Comparator<TreeNodeImpl> THESAURUS_COMPARATOR_TREENODE = new Comparator<TreeNodeImpl>() {
        @Override
        public int compare(TreeNodeImpl o1, TreeNodeImpl o2) {
            int result = 0;

            if (o1 != null && o2 != null) {
                Wikitty w1 = o1.getWikitty();
                String o1_name = o1.getName();
                int o1_order = w1.getFieldAsInt(Thesaurus.EXT_THESAURUS, Thesaurus.ORDER_FIELD);
                
                Wikitty w2 = o2.getWikitty();
                String o2_name = o2.getName();
                int o2_order = w2.getFieldAsInt(Thesaurus.EXT_THESAURUS, Thesaurus.ORDER_FIELD);
                
                if (o1_order == o2_order) {
                    result = o1_name.compareToIgnoreCase(o2_name);
                    
                } else {
                    result = (o1_order < o2_order ? -1 : (o1_order == o2_order ? 0 : 1));
                }
            }
            
            return result;
        }
    };
    
}
 