/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModel;

public class BinderBuilder {
    protected BinderModel<?, ?> model;
    protected Map<String, PropertyDescriptor> sourceDescriptors;
    protected Map<String, PropertyDescriptor> targetDescriptors;

    public BinderBuilder() {
    }

    public BinderBuilder(Class<?> type, String ... properties) {
        this.createBinderModel(type);
        this.addSimpleProperties(properties);
    }

    public BinderBuilder(Class<?> sourceType, Class<?> targetType, String ... properties) {
        this.createBinderModel(sourceType, targetType);
        this.addSimpleProperties(properties);
    }

    public BinderBuilder createBinderModel(Class<?> type) throws IllegalStateException, NullPointerException {
        this.createBinderModel(type, type);
        return this;
    }

    public BinderBuilder createBinderModel(Class<?> sourceType, Class<?> targetType) throws IllegalStateException, NullPointerException {
        if (sourceType == null) {
            throw new NullPointerException("sourceType can not be null");
        }
        if (targetType == null) {
            throw new NullPointerException("targetType can not be null");
        }
        if (this.model != null) {
            throw new IllegalStateException("there is already a binderModel in construction, release it with the method createBinder before using this method.");
        }
        this.model = new BinderModel(sourceType, targetType);
        this.sourceDescriptors = new TreeMap<String, PropertyDescriptor>();
        BinderBuilder.loadDescriptors(this.model.getSourceType(), this.sourceDescriptors);
        this.targetDescriptors = new TreeMap<String, PropertyDescriptor>();
        BinderBuilder.loadDescriptors(this.model.getTargetType(), this.targetDescriptors);
        return this;
    }

    public Binder<?, ?> createBinder() throws NullPointerException, IllegalStateException {
        Binder binder = this.createBinder(Binder.class);
        return binder;
    }

    public <B extends Binder<?, ?>> B createBinder(Class<B> binderType) throws NullPointerException, IllegalStateException {
        this.checkModelExists();
        if (binderType == null) {
            throw new NullPointerException("binderType can not be null");
        }
        try {
            Binder binder = (Binder)binderType.newInstance();
            binder.setModel(this.model);
            Binder binder2 = binder;
            return (B)binder2;
        }
        catch (Exception e) {
            throw new IllegalStateException("could not instanciate binder " + binderType, e);
        }
        finally {
            this.model = null;
            this.sourceDescriptors.clear();
            this.sourceDescriptors = null;
            this.targetDescriptors.clear();
            this.targetDescriptors = null;
        }
    }

    public BinderBuilder addSimpleProperties(String ... properties) throws IllegalStateException, NullPointerException {
        this.checkModelExists();
        for (String property : properties) {
            if (property == null) {
                throw new NullPointerException("parameter 'properties' can not contains a null value");
            }
            this.addProperty0(property, property);
        }
        return this;
    }

    public BinderBuilder addProperty(String sourceProperty, String targetProperty) throws IllegalStateException, NullPointerException {
        if (sourceProperty == null) {
            throw new NullPointerException("parameter 'sourceProperty' can not be null");
        }
        if (targetProperty == null) {
            throw new NullPointerException("parameter 'targetProperty' can not be null");
        }
        this.checkModelExists();
        this.addProperty0(sourceProperty, targetProperty);
        return this;
    }

    public BinderBuilder addProperties(String ... sourceAndTargetProperties) throws IllegalStateException, IllegalArgumentException, NullPointerException {
        this.checkModelExists();
        if (sourceAndTargetProperties.length % 2 != 0) {
            throw new IllegalArgumentException("must have couple(s) of (sourceProperty,targetProperty) but had " + Arrays.toString(sourceAndTargetProperties));
        }
        int max = sourceAndTargetProperties.length / 2;
        for (int i = 0; i < max; ++i) {
            String sourceProperty = sourceAndTargetProperties[2 * i];
            String targetProperty = sourceAndTargetProperties[2 * i + 1];
            if (sourceProperty == null) {
                throw new NullPointerException("parameter 'sourceAndTargetProperties' can not contains a null value");
            }
            if (targetProperty == null) {
                throw new NullPointerException("parameter 'sourceAndTargetProperties' can not contains a null value");
            }
            this.addProperty0(sourceProperty, targetProperty);
        }
        return this;
    }

    protected void addProperty0(String sourceProperty, String targetProperty) {
        Class<?> targetType;
        if (this.model.containsSourceProperty(sourceProperty)) {
            throw new IllegalArgumentException("source property '" + sourceProperty + "' " + " was already registred.");
        }
        if (this.model.containsTargetProperty(targetProperty)) {
            throw new IllegalArgumentException("destination property '" + targetProperty + "' " + " was already registred.");
        }
        PropertyDescriptor sourceDescriptor = this.sourceDescriptors.get(sourceProperty);
        if (sourceDescriptor == null) {
            throw new IllegalArgumentException("no property '" + sourceProperty + "' " + "found on type " + this.model.getSourceType());
        }
        Method readMethod = sourceDescriptor.getReadMethod();
        if (readMethod == null) {
            throw new IllegalArgumentException("property '" + sourceProperty + "' " + "is not readable on type " + this.model.getSourceType());
        }
        PropertyDescriptor targetDescriptor = this.targetDescriptors.get(targetProperty);
        if (targetDescriptor == null) {
            throw new IllegalArgumentException("no property '" + targetProperty + "' " + "found on type " + this.model.getTargetType());
        }
        Method writeMethod = sourceDescriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new IllegalArgumentException("property '" + targetProperty + "' " + "is not writable on type " + this.model.getTargetType());
        }
        Class<?> sourceType = sourceDescriptor.getPropertyType();
        if (sourceType != (targetType = targetDescriptor.getPropertyType())) {
            throw new IllegalArgumentException("source property '" + sourceProperty + "' and target property '" + targetProperty + "' are not compatible ( sourceType : " + sourceType + " vs targetType :" + targetType + ')');
        }
        this.model.addBinding(sourceDescriptor, targetDescriptor);
    }

    protected void checkModelExists() throws IllegalStateException {
        if (this.model == null) {
            throw new IllegalStateException("there is not model, must create one with createBinderModel method");
        }
    }

    protected BinderModel<?, ?> getModel() {
        return this.model;
    }

    protected static void loadDescriptors(Class<?> type, Map<String, PropertyDescriptor> descriptors) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                if (descriptors.containsKey(descriptor.getName())) continue;
                descriptors.put(descriptor.getName(), descriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Could not obtain bean properties descriptors for source type " + type, e);
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (Class<?> i : interfaces) {
            BinderBuilder.loadDescriptors(i, descriptors);
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            BinderBuilder.loadDescriptors(superClass, descriptors);
        }
    }
}

