/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private static Log log = LogFactory.getLog(FileUtil.class);
    public static String ENCODING = "ISO-8859-1";
    protected static File currentDirectory = new File(".");

    public static void setCurrentDirectory(File dir) {
        currentDirectory = dir;
    }

    public static File getCurrentDirectory() {
        return currentDirectory;
    }

    public static File getFile(String ... patternOrDescriptionFilters) {
        File result = FileUtil.getFile(null, patternOrDescriptionFilters);
        return result;
    }

    public static File getFile(javax.swing.filechooser.FileFilter ... filters) {
        File result = FileUtil.getFile(null, filters);
        return result;
    }

    public static File getFile(Component parent, String ... patternOrDescriptionFilters) {
        File result = FileUtil.getFile("Ok", "Ok", parent, patternOrDescriptionFilters);
        return result;
    }

    public static File getFile(String title, String approvalText, Component parent, String ... patternOrDescriptionFilters) {
        if (patternOrDescriptionFilters.length % 2 != 0) {
            throw new IllegalArgumentException("Arguments must be (pattern, description) couple");
        }
        javax.swing.filechooser.FileFilter[] filters = new javax.swing.filechooser.FileFilter[patternOrDescriptionFilters.length / 2];
        for (int i = 0; i < filters.length; ++i) {
            String pattern = patternOrDescriptionFilters[i * 2];
            String description = patternOrDescriptionFilters[i * 2 + 1];
            filters[i] = new PatternChooserFilter(pattern, description);
        }
        File result = FileUtil.getFile(title, approvalText, parent, filters);
        return result;
    }

    public static File getFile(Component parent, javax.swing.filechooser.FileFilter ... filters) {
        File result = FileUtil.getFile("Ok", "Ok", parent, filters);
        return result;
    }

    public static File getFile(String title, String approvalText, Component parent, javax.swing.filechooser.FileFilter ... filters) {
        try {
            File theFile;
            JFileChooser chooser = new JFileChooser(currentDirectory);
            chooser.setDialogType(2);
            if (filters.length > 0) {
                if (filters.length == 1) {
                    chooser.setFileFilter(filters[0]);
                } else {
                    for (javax.swing.filechooser.FileFilter filter : filters) {
                        chooser.addChoosableFileFilter(filter);
                    }
                }
            }
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle(title);
            int returnVal = chooser.showDialog(parent, approvalText);
            if (returnVal == 0 && (theFile = chooser.getSelectedFile()) != null) {
                currentDirectory = theFile;
                return theFile.getAbsoluteFile();
            }
        }
        catch (Exception eee) {
            log.warn((Object)"Erreur:", (Throwable)eee);
        }
        return null;
    }

    public static String getDirectory() {
        return FileUtil.getDirectory(null, "Ok", "Ok");
    }

    public static String getDirectory(String title, String approvalText) {
        String result = FileUtil.getDirectory(null, title, approvalText);
        return result;
    }

    public static String getDirectory(Component parent, String title, String approvalText) {
        block5: {
            try {
                JFileChooser chooser = new JFileChooser(currentDirectory);
                chooser.setDialogType(2);
                chooser.setFileSelectionMode(1);
                chooser.setDialogTitle(title);
                int returnVal = chooser.showDialog(parent, approvalText);
                if (returnVal == 0) {
                    File theFile = chooser.getSelectedFile();
                    if (theFile != null) {
                        currentDirectory = theFile;
                        if (theFile.isDirectory()) {
                            return theFile.getAbsolutePath();
                        }
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception eee) {
                log.warn((Object)"Erreur:", (Throwable)eee);
            }
        }
        return null;
    }

    public static byte[] fileToByte(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        BufferedOutputStream tmp = new BufferedOutputStream(result);
        int b = ((InputStream)in).read();
        while (b != -1) {
            tmp.write(b);
            b = ((InputStream)in).read();
        }
        ((InputStream)in).close();
        tmp.close();
        return result.toByteArray();
    }

    public static File inputStreamToFile(InputStream src, File dst) throws IOException, NullPointerException {
        if (src == null) {
            throw new NullPointerException("parameter 'src' can not be null");
        }
        if (dst == null) {
            throw new NullPointerException("parameter 'dst' can not be null");
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        BufferedOutputStream tmp = new BufferedOutputStream(result);
        int b = src.read();
        while (b != -1) {
            tmp.write(b);
            b = src.read();
        }
        src.close();
        tmp.close();
        FileUtil.byteToFile(result.toByteArray(), dst);
        return dst;
    }

    public static File byteToFile(byte[] bytes) throws IOException {
        File file = File.createTempFile("FileUtil-byteToFile", ".tmp");
        FileUtil.byteToFile(bytes, file);
        return file;
    }

    public static File byteToFile(byte[] bytes, File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        ((OutputStream)out).write(bytes);
        ((OutputStream)out).close();
        return file;
    }

    public static BufferedReader getReader(File file) throws IOException {
        return FileUtil.getReader(file, ENCODING);
    }

    public static BufferedReader getReader(File file, String encoding) throws IOException {
        FileInputStream inf = new FileInputStream(file);
        InputStreamReader in = new InputStreamReader((InputStream)inf, encoding);
        BufferedReader result = new BufferedReader(in);
        return result;
    }

    public static BufferedWriter getWriter(File file) throws IOException {
        return FileUtil.getWriter(file, ENCODING);
    }

    public static BufferedWriter getWriter(File file, String encoding) throws IOException {
        FileOutputStream outf = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outf, encoding);
        BufferedWriter result = new BufferedWriter(out);
        return result;
    }

    public static File createTempDirectory(String prefix, String suffix, File tmpdir) throws IOException {
        if (tmpdir == null) {
            tmpdir = new File(System.getProperty("java.io.tmpdir"));
        }
        File result = new File(tmpdir, prefix + System.currentTimeMillis() + suffix);
        while (result.exists()) {
            result = new File(tmpdir, prefix + System.currentTimeMillis() + suffix);
        }
        if (!result.mkdirs()) {
            throw new IOException("Can't create temporary directory: " + result);
        }
        return result;
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileUtil.createTempDirectory(prefix, suffix, null);
    }

    public static boolean isNewer(File f1, File f2) {
        boolean result = f1.lastModified() > f2.lastModified();
        return result;
    }

    public static String readAsString(File file) throws IOException {
        StringBuffer result = new StringBuffer();
        char[] cbuf = new char[2000];
        BufferedReader in = FileUtil.getReader(file);
        int nb = in.read(cbuf);
        while (nb != -1) {
            result.append(cbuf, 0, nb);
            nb = in.read(cbuf);
        }
        in.close();
        return result.toString();
    }

    public static void writeString(File file, String content) throws IOException {
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        BufferedWriter out = FileUtil.getWriter(file);
        out.write(content);
        out.close();
    }

    public static void writeString(File file, String content, String encoding) throws IOException {
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        BufferedWriter out = FileUtil.getWriter(file, encoding);
        out.write(content);
        out.close();
    }

    public static File getTempFile(String content) throws IOException {
        return FileUtil.getTempFile(content, "");
    }

    public static File getTempFile(String content, String fileSuffix) throws IOException {
        File result = File.createTempFile("tmp-" + FileUtil.class.getName(), fileSuffix);
        result.deleteOnExit();
        FileUtil.writeString(result, content);
        return result;
    }

    public static String basename(File file, String ... suffixes) {
        String result = file.getName();
        for (String suffixe : suffixes) {
            if (!result.endsWith(suffixe)) continue;
            result = result.substring(0, result.length() - suffixe.length());
            break;
        }
        return result;
    }

    public static String extension(File file, String ... extchars) {
        String result = "";
        String name = file.getName();
        if (extchars.length == 0) {
            extchars = new String[]{"."};
        }
        for (String extchar : extchars) {
            int pos = name.lastIndexOf(extchar);
            if (pos == -1) continue;
            result = name.substring(pos + extchar.length());
            break;
        }
        return result;
    }

    public static List<File> getSubDirectories(File directory) {
        class DirectoryFilter
        implements FileFilter {
            DirectoryFilter() {
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        }
        return FileUtil.getFilteredElements(directory, new DirectoryFilter(), true);
    }

    public static List<File> getFiles(File directory) {
        class NormalFileFilter
        implements FileFilter {
            NormalFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        }
        return FileUtil.getFilteredElements(directory, new NormalFileFilter(), true);
    }

    public static List<File> find(File directory, final String pattern, boolean recursively) {
        String root = directory.getAbsolutePath();
        final int rootLength = root.length();
        return FileUtil.getFilteredElements(directory, new FileFilter(){

            @Override
            public boolean accept(File f) {
                String longFilename = f.getAbsolutePath();
                String filename = longFilename.substring(rootLength + 1);
                return filename.matches(pattern);
            }
        }, recursively);
    }

    public static List<File> getFilteredElements(File directory, FileFilter ff, boolean recursively) {
        ArrayList<File> result = new ArrayList<File>();
        LinkedList<File> todo = new LinkedList<File>();
        if (directory.isDirectory()) {
            todo.addAll(Arrays.asList(directory.listFiles()));
        }
        while (todo.size() > 0) {
            File[] childs;
            File file = (File)todo.removeFirst();
            if (recursively && file.isDirectory() && (childs = file.listFiles()) != null) {
                todo.addAll(Arrays.asList(childs));
            }
            if (ff != null && !ff.accept(file)) continue;
            result.add(file);
        }
        return result;
    }

    public static boolean deleteRecursively(String directory) {
        return FileUtil.deleteRecursively(new File(directory));
    }

    public static boolean deleteRecursively(File directory) {
        return FileUtil.walkBefore(directory, new FileAction(){

            @Override
            public boolean doAction(File f) {
                return f.delete();
            }
        });
    }

    public static boolean walkAfter(File f, FileAction fileAction) {
        boolean result = fileAction.doAction(f);
        if (f.isDirectory()) {
            File[] list;
            for (File aList : list = f.listFiles()) {
                result = result && FileUtil.walkAfter(aList, fileAction);
            }
        }
        return result;
    }

    public static boolean walkBefore(File f, FileAction fileAction) {
        boolean result = true;
        if (f.isDirectory()) {
            File[] list;
            for (File aList : list = f.listFiles()) {
                result = result && FileUtil.walkBefore(aList, fileAction);
            }
        }
        return result && fileAction.doAction(f);
    }

    public static void copy(File source, File target) throws IOException {
        target.getParentFile().mkdirs();
        FileChannel sourceChannel = new FileInputStream(source).getChannel();
        FileChannel targetChannel = new FileOutputStream(target).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        sourceChannel.close();
        targetChannel.close();
    }

    public static void copy(String source, String target) throws IOException {
        FileUtil.copy(new File(source), new File(target));
    }

    public static void copyRecursively(File srcDir, File destDir, String ... includePatterns) throws IOException {
        FileUtil.copyAndRenameRecursively(srcDir, destDir, null, null, includePatterns);
    }

    public static void copyAndRenameRecursively(File srcDir, File destDir, String renameFrom, String renameTo, String ... includePatterns) throws IOException {
        FileUtil.copyAndRenameRecursively(srcDir, destDir, true, renameFrom, renameTo, false, includePatterns);
    }

    public static void copyAndRenameRecursively(File srcDir, File destDir, boolean includeSrcDir, String renameFrom, String renameTo, boolean exclude, String ... includePatterns) throws IOException {
        String rootSrc = includeSrcDir ? srcDir.getParent() : srcDir.getPath();
        List<File> files = FileUtil.getFilteredElements(srcDir, null, true);
        log.debug((Object)("copyRecursively: " + files));
        for (File file : files) {
            boolean doCopy = FileUtil.copyRecursivelyAccept(file, includePatterns);
            if (!FileUtil.xor(exclude, doCopy)) continue;
            String path = file.getPath().substring(rootSrc.length());
            if (renameFrom != null && renameTo != null) {
                String tmp = path.replaceAll(renameFrom, renameTo);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("rename " + path + " -> " + tmp));
                }
                path = tmp;
            }
            File destFile = new File(destDir, path);
            if (file.isDirectory()) {
                log.debug((Object)("create directory: " + destFile));
                destFile.mkdirs();
                continue;
            }
            log.debug((Object)("copy " + path + " to " + destFile));
            FileUtil.copy(file, destFile);
        }
    }

    public static ByteArrayOutputStream readBytesFrom(InputStream inputStream, int defaultBufferSize) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(defaultBufferSize);
        byte[] buffer = new byte[defaultBufferSize];
        int readBytes = inputStream.read(buffer);
        while (readBytes > 0) {
            outputStream.write(buffer, 0, readBytes);
            readBytes = inputStream.read(buffer);
        }
        return outputStream;
    }

    private static boolean xor(boolean b, boolean c) {
        if (b) {
            return !c;
        }
        return c;
    }

    private static boolean copyRecursivelyAccept(File file, String[] includePatterns) {
        String pattern;
        boolean result = includePatterns.length == 0;
        String filename = file.getAbsolutePath();
        String[] arr$ = includePatterns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(result = filename.matches(pattern = arr$[i$])); ++i$) {
        }
        return result;
    }

    protected static List<CharSequence> grep(String regex, CharBuffer cb) {
        ArrayList<String> linesList = null;
        Pattern pattern = Pattern.compile(regex);
        Pattern linePattern = Pattern.compile(".*\r?\n");
        Matcher lm = linePattern.matcher(cb);
        Matcher pm = null;
        while (lm.find()) {
            String cs = lm.group();
            if (pm == null) {
                pm = pattern.matcher(cs);
            } else {
                pm.reset(cs);
            }
            if (pm.find()) {
                if (linesList == null) {
                    linesList = new ArrayList<String>();
                }
                linesList.add(cs);
            }
            if (lm.end() != cb.limit()) continue;
            break;
        }
        return linesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CharSequence> grep(String searchRegex, File f, String encoding) throws IOException {
        List<CharSequence> lines = null;
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fis = new FileInputStream(f);
            fc = fis.getChannel();
            int sz = (int)((FileChannel)fc).size();
            MappedByteBuffer bb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cb = decoder.decode(bb);
            lines = FileUtil.grep(searchRegex, cb);
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return lines;
    }

    public static Map<File, List<CharSequence>> grep(String searchRegex, File rootDirectory, String fileRegex, String encoding) throws IOException {
        HashMap<File, List<CharSequence>> results = new HashMap<File, List<CharSequence>>();
        List<File> files = FileUtil.find(rootDirectory, fileRegex, true);
        for (File file : files) {
            List<CharSequence> lines = FileUtil.grep(searchRegex, file, encoding);
            if (lines == null) continue;
            results.put(file, lines);
        }
        return results;
    }

    public static Map<File, List<CharSequence>> grep(String searchRegex, String fileRegex, String encoding) throws IOException {
        Map<File, List<CharSequence>> results = FileUtil.grep(searchRegex, new File("."), fileRegex, encoding);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sed(String searchRegex, String replace, File file, String encoding) throws IOException {
        Pattern pattern = Pattern.compile(searchRegex);
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel fc = null;
        String outString = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            fc = raf.getChannel();
            int sz = (int)((FileChannel)fc).size();
            MappedByteBuffer bb = ((FileChannel)fc).map(FileChannel.MapMode.READ_WRITE, 0L, sz);
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cb = decoder.decode(bb);
            Matcher matcher = pattern.matcher(cb);
            outString = matcher.replaceAll(replace);
            ((FileChannel)fc).position(0L);
            ((FileChannel)fc).write(ByteBuffer.wrap(outString.getBytes()));
            ((FileChannel)fc).truncate(outString.getBytes().length);
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (raf != null) {
                raf.close();
            }
        }
    }

    public static void sed(String searchRegex, String replace, File rootDirectory, String fileRegex, String encoding) throws IOException {
        List<File> files = FileUtil.find(rootDirectory, fileRegex, true);
        for (File file : files) {
            FileUtil.sed(searchRegex, replace, file, encoding);
        }
    }

    public static void sed(String searchRegex, String replace, String fileRegex, String encoding) throws IOException {
        FileUtil.sed(searchRegex, replace, new File("."), fileRegex, encoding);
    }

    public static interface FileAction {
        public boolean doAction(File var1);
    }

    public static class PatternChooserFilter
    extends javax.swing.filechooser.FileFilter {
        protected String pattern = null;
        protected String description = null;

        public PatternChooserFilter(String pattern, String description) {
            this.pattern = pattern;
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getAbsolutePath().matches(this.pattern);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

