/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.services.Configuration;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.ooo.SingletonOOo;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XRefreshable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateManager {
    private static final Log log = LogFactory.getLog(TemplateManager.class);
    protected XComponentContext context = null;
    protected XComponentLoader loader = null;
    protected XComponent document = null;

    public TemplateManager(String templateDoc) throws VradiException {
        this.document = this.createDoc(templateDoc);
    }

    public void generateDoc(String targetFileName, Map<String, Object> myValues, File ... images) throws VradiException {
        this.fillFields(myValues);
        if (images != null) {
            for (File image : images) {
                this.insertImageInEndOfDocument(image);
            }
        }
        this.storeDocComponent(this.document, targetFileName);
    }

    public XComponent createDoc(String templateFile) throws VradiException {
        try {
            if (this.context == null) {
                String oOoExecFolder = Configuration.getInstance().getOpenOfficeExecDir();
                this.context = SingletonOOo.GetInstance(oOoExecFolder).getXContext();
                this.loader = SingletonOOo.GetInstance(oOoExecFolder).getLoader();
            }
            ArrayList<PropertyValue> props = new ArrayList<PropertyValue>();
            PropertyValue p1 = new PropertyValue();
            p1.Name = "AsTemplate";
            p1.Value = new Boolean(true);
            props.add(p1);
            PropertyValue p2 = new PropertyValue();
            p2.Name = "Hidden";
            p2.Value = new Boolean(true);
            props.add(p2);
            PropertyValue[] properties = new PropertyValue[props.size()];
            props.toArray(properties);
            String templateFileURL = this.filePathToURL(templateFile);
            this.document = this.loader.loadComponentFromURL(templateFileURL, "_blank", 0, properties);
            return this.document;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create document", (Throwable)e);
            }
            throw new VradiException("Can't create document", e);
        }
    }

    public synchronized void storeDocComponent(XComponent xDoc, String storeUrl) throws VradiException {
        try {
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xDoc);
            storeUrl = this.filePathToURL(storeUrl);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Storing pdf file to " + storeUrl));
            }
            PropertyValue[] storeProps = new PropertyValue[2];
            storeProps[0] = new PropertyValue();
            storeProps[0].Name = "FilterName";
            storeProps[0].Value = "writer_pdf_Export";
            storeProps[1] = new PropertyValue();
            storeProps[1].Name = "Overwrite";
            storeProps[1].Value = new Boolean(true);
            xStorable.storeToURL(storeUrl, storeProps);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't export template as PDF", (Throwable)eee);
            }
            throw new VradiException("Can't export template as PDF", eee);
        }
    }

    protected String filePathToURL(String file) {
        StringBuffer sb;
        block2: {
            File f = new File(file);
            sb = new StringBuffer("file:///");
            try {
                sb.append(f.getCanonicalPath().replace('\\', '/'));
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get fi canonical path", (Throwable)e);
            }
        }
        return sb.toString();
    }

    protected void fillFields(Map<String, Object> myValues) throws VradiException {
        try {
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.document);
            XNameAccess xNamedFieldMasters = xTextFieldsSupplier.getTextFieldMasters();
            XEnumerationAccess xEnumeratedFields = xTextFieldsSupplier.getTextFields();
            String[] names = xNamedFieldMasters.getElementNames();
            String[] fieldNames = new String[names.length];
            Object[] fieldMasters = new Object[names.length];
            XPropertySet[] xPropertySets = new XPropertySet[names.length];
            int fieldCount = 0;
            for (int i = 0; i < names.length; ++i) {
                String wordUser;
                String user = names[i].length() > 34 ? names[i].substring(30, 34) : null;
                String string = wordUser = names[i].length() > 38 ? names[i].substring(30, 38) : null;
                if (user != null && user.equalsIgnoreCase("User")) {
                    fieldNames[fieldCount] = names[i].substring(35, names[i].length());
                    fieldMasters[fieldCount] = xNamedFieldMasters.getByName(names[i]);
                    xPropertySets[fieldCount] = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)fieldMasters[fieldCount]);
                    ++fieldCount;
                    continue;
                }
                if (wordUser == null || !wordUser.equalsIgnoreCase("database")) continue;
                fieldNames[fieldCount] = names[i].substring(38, names[i].length());
                fieldMasters[fieldCount] = xNamedFieldMasters.getByName(names[i]);
                xPropertySets[fieldCount] = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)fieldMasters[fieldCount]);
                ++fieldCount;
            }
            XRefreshable xRefreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xEnumeratedFields);
            for (int i = 0; i < fieldCount; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Replacing " + fieldNames[i] + " with " + myValues.get(fieldNames[i])));
                }
                xPropertySets[i].setPropertyValue("Content", myValues.get(fieldNames[i]));
                xRefreshable.refresh();
                if (!log.isDebugEnabled() || myValues.get(fieldNames[i]) != null) continue;
                log.debug((Object)("Field " + fieldNames[i] + " could not be found"));
            }
        }
        catch (Exception eee) {
            throw new VradiException("Can't replace template fields", eee);
        }
    }

    public void insertImageInEndOfDocument(File image) throws VradiException {
        try {
            XTextDocument xTextDoc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.document);
            XMultiServiceFactory xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDoc);
            Object oGraphic = null;
            oGraphic = xMSFDoc.createInstance("com.sun.star.text.TextGraphicObject");
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)oGraphic);
            XText xText = xTextDoc.getText();
            xText.insertControlCharacter(xText.getEnd(), (short)5, false);
            xText.insertTextContent(xText.getEnd(), xTextContent, false);
            XPropertySet xPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oGraphic);
            xPropSet.setPropertyValue("AnchorType", (Object)TextContentAnchorType.AT_PARAGRAPH);
            xPropSet.setPropertyValue("GraphicURL", (Object)"file:///home/morin/Images/cyclope-veja-fixed-gear.jpg");
            xPropSet.setPropertyValue("TopMargin", (Object)1500);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't insert image", (Throwable)eee);
            }
            throw new VradiException("Can't insert image", eee);
        }
    }

    public String[] getDocumentFields() {
        XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.document);
        XNameAccess xNamedFieldMasters = xTextFieldsSupplier.getTextFieldMasters();
        String[] names = xNamedFieldMasters.getElementNames();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            String wordUser;
            String user = names[i].length() > 34 ? names[i].substring(30, 34) : null;
            String string = wordUser = names[i].length() > 38 ? names[i].substring(30, 38) : null;
            if (user.equalsIgnoreCase("User")) {
                fieldNames.add(names[i].substring(35, names[i].length()));
                continue;
            }
            if (!wordUser.equalsIgnoreCase("database")) continue;
            fieldNames.add(names[i].substring(38, names[i].length()));
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }
}

