/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.services.Configuration;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.nuiton.util.FileUtil;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyService;
import org.sharengo.wikitty.WikittyUtil;

public class FormTypeManager {
    private static final Log log = LogFactory.getLog(FormTypeManager.class);
    private final WikittyProxy proxy;

    public FormTypeManager(WikittyProxy proxy) {
        this.proxy = proxy;
    }

    public FormTypeManager() {
        this.proxy = ServiceFactory.getWikittyProxy();
    }

    private WikittyExtension computeExtension(WikittyExtension extension) {
        String key;
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)"computeExtension(extension)");
        }
        Collection fieldNames = extension.getFieldNames();
        ArrayList<String> fieldOrder = new ArrayList<String>();
        ArrayList<String> orderlessFields = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            FieldType fieldType = extension.getFieldType(fieldName);
            try {
                Integer.valueOf(fieldType.getTagValue("rank"));
                fieldOrder.add(fieldName);
            }
            catch (Exception eee) {
                log.warn((Object)(fieldName + " does not have a valid rank"));
                orderlessFields.add(fieldName);
            }
        }
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        int size = fieldOrder.size();
        for (i = 0; i < size; ++i) {
            key = (String)fieldOrder.get(i);
            fields.put(key, extension.getFieldType(key));
        }
        size = orderlessFields.size();
        for (i = 0; i < size; ++i) {
            key = (String)orderlessFields.get(i);
            fields.put(key, extension.getFieldType(key));
        }
        WikittyExtension fieldOrderedExtension = new WikittyExtension(extension.getName(), extension.getVersion(), extension.getRequires(), fields);
        fieldOrderedExtension.setTagValues(extension.getTagValues());
        return fieldOrderedExtension;
    }

    public List<WikittyExtension> getAllFormTypes() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllFormTypes()");
        }
        ArrayList<WikittyExtension> extensions = new ArrayList<WikittyExtension>();
        WikittyService wikittyService = this.proxy.getWikittyService();
        List allExtensionIds = wikittyService.getAllExtensionsRequires("Form");
        HashMap<String, WikittyExtension> lastVersions = new HashMap<String, WikittyExtension>();
        for (String extensionId : allExtensionIds) {
            String extensionName = WikittyExtension.computeName((String)extensionId);
            if (lastVersions.get(extensionName) != null) continue;
            WikittyExtension extension = wikittyService.restoreExtensionLastVersion(extensionName);
            extension = this.computeExtension(extension);
            lastVersions.put(extensionName, extension);
        }
        extensions.addAll(lastVersions.values());
        return extensions;
    }

    public WikittyExtension getFormType(String name) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormType(" + name + ")"));
        }
        try {
            WikittyService wikittyService = this.proxy.getWikittyService();
            WikittyExtension wikittyExtension = wikittyService.restoreExtensionLastVersion(name);
            return wikittyExtension;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }

    public Map<String, FieldType> getFormTypeFields(String name) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormTypeFields(" + name + ")"));
        }
        try {
            WikittyExtension extension = this.getFormType(name);
            HashMap<String, FieldType> fields = new HashMap<String, FieldType>();
            for (String fieldName : extension.getFieldNames()) {
                fields.put(fieldName, extension.getFieldType(fieldName));
            }
            return fields;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }

    public WikittyExtension updateFormType(String name, Map<String, FieldType> fields, String requires, Map<String, String> tagValues) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateFormType(" + name + ", fields, requires, tagValues)"));
        }
        if (name != null) {
            try {
                WikittyExtension lastVersion = this.getFormType(name);
                String newVersion = null;
                newVersion = lastVersion != null ? WikittyUtil.incrementMajorRevision((String)lastVersion.getVersion()) : "0.0";
                WikittyExtension extension = new WikittyExtension(name, newVersion, requires, new LinkedHashMap<String, FieldType>(fields));
                if (tagValues != null) {
                    for (Map.Entry<String, String> entry : tagValues.entrySet()) {
                        extension.addTagValue(entry.getKey(), entry.getValue());
                    }
                }
                List<WikittyExtension> extensions = Arrays.asList(extension);
                this.proxy.getWikittyService().storeExtension(extensions);
                log.info((Object)String.format("FormType named %s saved with id: %s and version: %s", name, extension.getId(), newVersion));
                return extension;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new VradiException(e);
            }
        }
        return null;
    }

    public WikittyExtension updateFormType(WikittyExtension extension) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateFormType(" + extension.toDefinition() + ")"));
        }
        try {
            LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
            for (String fieldName : extension.getFieldNames()) {
                FieldType fieldType = extension.getFieldType(fieldName);
                fields.put(fieldName, fieldType);
            }
            WikittyExtension updated = this.updateFormType(extension.getName(), fields, extension.getRequires(), extension.getTagValues());
            return updated;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }

    public File addTemplate(WikittyExtension extension, File template) throws VradiException {
        if (extension == null || template == null) {
            return null;
        }
        try {
            File templatesDir = Configuration.getInstance().getTemplatesDir();
            File templateDir = new File(templatesDir, extension.getName());
            templateDir.mkdirs();
            File copyOfTemplate = new File(templateDir, template.getName());
            FileUtil.copy((File)template, (File)copyOfTemplate);
            return copyOfTemplate;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }

    public File getTemplate(String extensionName, String templateName) {
        if (extensionName == null || templateName == null) {
            return null;
        }
        File templatesDir = Configuration.getInstance().getTemplatesDir();
        File template = new File(new File(templatesDir, extensionName), templateName);
        return template.exists() ? template : null;
    }

    public File[] getTemplates(WikittyExtension extension) {
        if (extension == null) {
            return null;
        }
        File templatesDir = Configuration.getInstance().getTemplatesDir();
        File templateDir = new File(templatesDir, extension.getName());
        File[] result = templateDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && !file.getName().endsWith(".xml");
            }
        });
        return result;
    }

    public Map<String, String> getAssociatedFields(String extensionName, String templateName) throws VradiException {
        if (extensionName == null || templateName == null) {
            return null;
        }
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder();
            File templatesDir = Configuration.getInstance().getTemplatesDir();
            File targetFile = new File(new File(templatesDir, extensionName), templateName + ".xml");
            document = sxb.build(targetFile);
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
        Element root = document.getRootElement();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (Object child : root.getChildren(VradiConstants.FormTypeTemplateEnum.FIELD_ELEMENT.toString())) {
            Element field = (Element)child;
            String templateField = field.getAttributeValue(VradiConstants.FormTypeTemplateEnum.FIELD_TEMPLATE_ATTRIBUTE.toString());
            String extensionField = field.getAttributeValue(VradiConstants.FormTypeTemplateEnum.FIELD_EXTENSION_ATTRIBUTE.toString());
            fieldMap.put(templateField, extensionField);
        }
        return fieldMap;
    }

    public void setAssociatedFields(String extensionName, String templateName, Map<String, String> fieldMap) throws VradiException {
        if (extensionName == null || fieldMap == null) {
            return;
        }
        File templatesDir = Configuration.getInstance().getTemplatesDir();
        File templateDir = new File(templatesDir, extensionName);
        templateDir.mkdirs();
        File targetFile = new File(templateDir, templateName + ".xml");
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(targetFile);
        }
        catch (IOException e) {
            document = new Document(new Element(VradiConstants.FormTypeTemplateEnum.FIELDS_ELEMENT.toString()));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
        try {
            Element root = document.getRootElement();
            root.removeChildren(VradiConstants.FormTypeTemplateEnum.FIELD_ELEMENT.toString());
            for (Map.Entry<String, String> field : fieldMap.entrySet()) {
                Element child = new Element(VradiConstants.FormTypeTemplateEnum.FIELD_ELEMENT.toString());
                child.setAttribute(VradiConstants.FormTypeTemplateEnum.FIELD_TEMPLATE_ATTRIBUTE.toString(), field.getKey());
                if (field.getValue() != null) {
                    child.setAttribute(VradiConstants.FormTypeTemplateEnum.FIELD_EXTENSION_ATTRIBUTE.toString(), field.getValue());
                }
                root.addContent((Content)child);
            }
            XMLOutputter xmlOuputter = new XMLOutputter();
            xmlOuputter.output(document, (Writer)new FileWriter(targetFile));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }
}

