/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.util;

import java.util.ArrayList;

public class Strings {
    private Strings() {
    }

    public static String removeFormattingCharacters(String toBeEscaped) {
        StringBuffer escapedBuffer = new StringBuffer();
        for (int i = 0; i < toBeEscaped.length(); ++i) {
            if (toBeEscaped.charAt(i) == '\n' || toBeEscaped.charAt(i) == '\r' || toBeEscaped.charAt(i) == '\t') continue;
            escapedBuffer.append(toBeEscaped.charAt(i));
        }
        String s = escapedBuffer.toString();
        return s;
    }

    public static String replaceSubString(String str, String oldToken, String newToken) {
        return Strings.replaceSubString(str, oldToken, newToken, -1);
    }

    public static String replaceSubString(String str, String oldToken, String newToken, int max) {
        if (str == null || oldToken == null || newToken == null || oldToken.length() == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        int start = 0;
        int end = 0;
        while ((end = str.indexOf(oldToken, start)) != -1) {
            buf.append(str.substring(start, end)).append(newToken);
            start = end + oldToken.length();
            if (--max != 0) continue;
        }
        buf.append(str.substring(start));
        return buf.toString();
    }

    public static final String[] splitString(String stringToSplit, String delimiter) {
        int iFound;
        if (stringToSplit.equals("")) {
            return new String[0];
        }
        int iFrom = 0;
        int iRecords = 0;
        while ((iFound = stringToSplit.indexOf(delimiter, iFrom)) != -1) {
            ++iRecords;
            iFrom = iFound + delimiter.length();
        }
        String[] aRet = new String[++iRecords];
        if (iRecords == 1) {
            aRet[0] = stringToSplit;
        } else {
            int iLast = 0;
            iFrom = 0;
            iFound = 0;
            for (int i = 0; i < iRecords; ++i) {
                iFound = stringToSplit.indexOf(delimiter, iFrom);
                aRet[i] = iFound == -1 ? stringToSplit.substring(iLast + delimiter.length(), stringToSplit.length()) : (iFound == 0 ? "" : stringToSplit.substring(iFrom, iFound));
                iLast = iFound;
                iFrom = iFound + delimiter.length();
            }
        }
        return aRet;
    }

    public static String[] extractMethodSignature(String methodCallSignature) {
        ArrayList<String> extracted = new ArrayList<String>();
        String methodName = methodCallSignature;
        String methodCallDesc = null;
        if (methodCallSignature.indexOf("(") > 0) {
            methodName = methodName.substring(0, methodCallSignature.indexOf("("));
            methodCallDesc = methodCallSignature.substring(methodCallSignature.indexOf("(") + 1, methodCallSignature.lastIndexOf(")"));
        }
        extracted.add(methodName);
        if (methodCallDesc != null) {
            String[] parameters = Strings.splitString(methodCallDesc, ",");
            for (int i = 0; i < parameters.length; ++i) {
                String[] parameterInfo = Strings.splitString(Strings.replaceSubString(parameters[i].trim(), "  ", " "), " ");
                extracted.add(parameterInfo[0]);
                extracted.add(parameterInfo.length > 1 ? parameterInfo[1] : "");
            }
        }
        return extracted.toArray(new String[0]);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null ? true : s.length() <= 0;
    }
}

