/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression.regexp;

import java.io.ObjectInputStream;
import org.codehaus.aspectwerkz.expression.ExpressionException;
import org.codehaus.aspectwerkz.expression.SubtypePatternType;
import org.codehaus.aspectwerkz.expression.regexp.Pattern;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.util.Strings;

public class TypePattern
extends Pattern {
    protected transient com.karneim.util.collection.regex.Pattern m_typeNamePattern;
    protected String m_pattern;
    private SubtypePatternType m_subtypePatternType;

    TypePattern(String pattern, SubtypePatternType subtypePatternType) {
        this.m_pattern = pattern;
        this.m_subtypePatternType = subtypePatternType;
        this.escape(this.m_pattern);
    }

    public boolean matches(String typeName) {
        int awProxySuffixStart = typeName.indexOf("$$ProxiedByAW$$");
        if (awProxySuffixStart > 0) {
            typeName = typeName.substring(0, awProxySuffixStart);
        } else {
            int cglibFastClassSuffixStarg = typeName.indexOf("$$FastClassByCGLIB$$");
            if (cglibFastClassSuffixStarg > 0) {
                return false;
            }
            int cglibEnhancerSuffixStart = typeName.indexOf("$$EnhancerByCGLIB$$");
            if (cglibEnhancerSuffixStart > 0) {
                typeName = typeName.substring(0, cglibEnhancerSuffixStart);
            }
        }
        if (typeName == null) {
            return false;
        }
        if (typeName.equals("")) {
            return false;
        }
        return this.m_typeNamePattern.contains(typeName);
    }

    public boolean matchType(ClassInfo classInfo) {
        SubtypePatternType type = this.getSubtypePatternType();
        if (type.equals(SubtypePatternType.MATCH_ON_ALL_METHODS)) {
            return this.matchSuperClasses(classInfo);
        }
        if (type.equals(SubtypePatternType.MATCH_ON_BASE_TYPE_METHODS_ONLY)) {
            return this.matchSuperClasses(classInfo);
        }
        return this.matches(classInfo.getName());
    }

    public boolean matchSuperClasses(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        if (this.matches(classInfo.getName())) {
            return true;
        }
        if (this.matchInterfaces(classInfo.getInterfaces(), classInfo)) {
            return true;
        }
        return this.matchSuperClasses(classInfo.getSuperclass());
    }

    public boolean matchInterfaces(ClassInfo[] interfaces, ClassInfo classInfo) {
        if (interfaces.length == 0 || classInfo == null) {
            return false;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            ClassInfo anInterface = interfaces[i];
            if (this.matches(anInterface.getName())) {
                return true;
            }
            if (!this.matchInterfaces(anInterface.getInterfaces(), classInfo)) continue;
            return true;
        }
        return false;
    }

    public SubtypePatternType getSubtypePatternType() {
        return this.m_subtypePatternType;
    }

    public boolean isEagerWildCard() {
        return this.m_pattern.equals("..");
    }

    public String getPattern() {
        return this.m_pattern;
    }

    protected void escape(String pattern) {
        String typeName = pattern;
        if (ABBREVIATIONS.containsKey(pattern)) {
            typeName = (String)ABBREVIATIONS.get(pattern);
        }
        try {
            if (typeName.equals("*") || typeName.equals("..")) {
                typeName = "[a-zA-Z0-9_$.\\[\\]]+";
            } else {
                typeName = Strings.replaceSubString(typeName, "[", "\\[");
                typeName = Strings.replaceSubString(typeName, "]", "\\]");
                typeName = Strings.replaceSubString(typeName, "..", "[a-zA-Z0-9_$.]+");
                typeName = Strings.replaceSubString(typeName, ".", "\\.");
                typeName = Strings.replaceSubString(typeName, "*", "[a-zA-Z0-9_$\\[\\]]*");
            }
            this.m_typeNamePattern = new com.karneim.util.collection.regex.Pattern(typeName);
        }
        catch (Throwable e) {
            throw new ExpressionException("type pattern is not well formed: " + pattern, e);
        }
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_pattern = (String)fields.get("m_pattern", null);
        this.escape(this.m_pattern);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + TypePattern.hashCodeOrZeroIfNull(this.m_pattern);
        result = 37 * result + TypePattern.hashCodeOrZeroIfNull(this.m_typeNamePattern);
        return result;
    }

    protected static int hashCodeOrZeroIfNull(Object o) {
        if (null == o) {
            return 19;
        }
        return o.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypePattern)) {
            return false;
        }
        TypePattern obj = (TypePattern)o;
        return TypePattern.areEqualsOrBothNull(obj.m_pattern, this.m_pattern) && TypePattern.areEqualsOrBothNull(obj.m_typeNamePattern, this.m_typeNamePattern);
    }

    protected static boolean areEqualsOrBothNull(Object o1, Object o2) {
        if (null == o1) {
            return null == o2;
        }
        return o1.equals(o2);
    }
}

