/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.connectivity;

import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.codehaus.aspectwerkz.connectivity.Invoker;
import org.codehaus.aspectwerkz.connectivity.RemoteProxy;
import org.codehaus.aspectwerkz.connectivity.RemoteProxyServer;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class RemoteProxyServerManager {
    private static final boolean START_REMOTE_PROXY_SERVER = "true".equals(System.getProperty("aspectwerkz.remote.server.run", "false"));
    private static final RemoteProxyServerManager INSTANCE = new RemoteProxyServerManager();
    private RemoteProxyServer m_remoteProxyServer = null;

    public static RemoteProxyServerManager getInstance() {
        return INSTANCE;
    }

    public void start() {
        if (START_REMOTE_PROXY_SERVER) {
            this.m_remoteProxyServer = new RemoteProxyServer(ContextClassLoader.getLoader(), this.getInvoker());
            this.m_remoteProxyServer.start();
        }
    }

    private Invoker getInvoker() {
        Invoker invoker;
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(System.getProperty("aspectwerkz.resource.bundle")));
            String className = properties.getProperty("remote.server.invoker.classname");
            invoker = (Invoker)ContextClassLoader.forName(className).newInstance();
        }
        catch (Exception e) {
            invoker = this.getDefaultInvoker();
        }
        return invoker;
    }

    private Invoker getDefaultInvoker() {
        return new Invoker(){

            public Object invoke(String handle, String methodName, Class[] paramTypes, Object[] args, Object context) {
                Object result;
                try {
                    Object instance = RemoteProxy.getWrappedInstance(handle);
                    Method method = instance.getClass().getMethod(methodName, paramTypes);
                    result = method.invoke(instance, args);
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
                return result;
            }
        };
    }

    private RemoteProxyServerManager() {
    }
}

