/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation.instrumentation.asm;

import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.annotation.instrumentation.AttributeEnhancer;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.CustomAttributeHelper;
import org.codehaus.aspectwerkz.definition.DescriptorUtil;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.expression.QDoxParser;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.attrs.Attributes;
import org.codehaus.aspectwerkz.org.objectweb.asm.attrs.RuntimeInvisibleAnnotations;
import org.codehaus.aspectwerkz.reflect.TypeConverter;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;

public class AsmAttributeEnhancer
implements AttributeEnhancer {
    private ClassReader m_reader = null;
    private String m_classFileName = null;
    private String m_className = null;
    private URLClassLoader m_loader = null;
    private List m_classAttributes = new ArrayList();
    private List m_constructorAttributes = new ArrayList();
    private List m_methodAttributes = new ArrayList();
    private List m_fieldAttributes = new ArrayList();

    public boolean initialize(String className, URL[] classPath) {
        try {
            this.m_className = className;
            this.m_loader = new URLClassLoader(classPath);
            this.m_classFileName = className.replace('.', '/') + ".class";
            InputStream classAsStream = this.m_loader.getResourceAsStream(this.m_classFileName);
            if (classAsStream == null) {
                return false;
            }
            try {
                this.m_reader = new ClassReader(classAsStream);
            }
            catch (Exception e) {
                throw new ClassNotFoundException(this.m_className, e);
            }
            finally {
                classAsStream.close();
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return true;
    }

    public void insertClassAttribute(Object attribute) {
        if (this.m_reader == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        byte[] serializedAttribute = AsmAttributeEnhancer.serialize(attribute);
        this.m_classAttributes.add(serializedAttribute);
    }

    public void insertFieldAttribute(JavaField field, Object attribute) {
        if (this.m_reader == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        byte[] serializedAttribute = AsmAttributeEnhancer.serialize(attribute);
        this.m_fieldAttributes.add(new FieldAttributeInfo(field, serializedAttribute));
    }

    public void insertMethodAttribute(JavaMethod method, Object attribute) {
        if (this.m_reader == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        String[] methodParamTypes = new String[method.getParameters().length];
        for (int i = 0; i < methodParamTypes.length; ++i) {
            methodParamTypes[i] = TypeConverter.convertTypeToJava(method.getParameters()[i].getType());
        }
        byte[] serializedAttribute = AsmAttributeEnhancer.serialize(attribute);
        this.m_methodAttributes.add(new MethodAttributeInfo(method, serializedAttribute));
    }

    public void insertConstructorAttribute(JavaMethod constructor, Object attribute) {
        if (this.m_reader == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        String[] methodParamTypes = new String[constructor.getParameters().length];
        for (int i = 0; i < methodParamTypes.length; ++i) {
            methodParamTypes[i] = TypeConverter.convertTypeToJava(constructor.getParameters()[i].getType());
        }
        byte[] serializedAttribute = AsmAttributeEnhancer.serialize(attribute);
        this.m_constructorAttributes.add(new MethodAttributeInfo(constructor, serializedAttribute));
    }

    public void write(String destDir) {
        if (this.m_reader == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        try {
            ClassWriter writer = AsmHelper.newClassWriter(true);
            this.m_reader.accept(new AttributeClassAdapter(writer), Attributes.getDefaultAttributes(), false);
            String path = destDir + File.separator + this.m_classFileName;
            File file = new File(path);
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new RuntimeException("could not create dir structure needed to write file " + path + " to disk");
            }
            FileOutputStream os = new FileOutputStream(destDir + File.separator + this.m_classFileName);
            os.write(writer.toByteArray());
            os.close();
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static byte[] serialize(Object attribute) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(attribute);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public String[] getNearestInterfacesInHierarchy(String innerClassName) {
        if (this.m_loader == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        try {
            Class<?> innerClass = Class.forName(innerClassName, false, this.m_loader);
            return this.getNearestInterfacesInHierarchy(innerClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not load mixin for mixin implicit interface: " + e.toString());
        }
        catch (NoClassDefFoundError er) {
            throw new RuntimeException("could not find dependency for mixin implicit interface: " + innerClassName + " due to: " + er.toString());
        }
    }

    private String[] getNearestInterfacesInHierarchy(Class root) {
        if (root == null) {
            return new String[0];
        }
        Class<?>[] implementedClasses = root.getInterfaces();
        String[] interfaces = null;
        if (implementedClasses.length == 0) {
            interfaces = this.getNearestInterfacesInHierarchy(root.getSuperclass());
        } else {
            interfaces = new String[implementedClasses.length];
            for (int i = 0; i < implementedClasses.length; ++i) {
                interfaces[i] = implementedClasses[i].getName();
            }
        }
        return interfaces;
    }

    private static class MethodAttributeInfo {
        public final byte[] attribute;
        public final JavaMethod method;

        public MethodAttributeInfo(JavaMethod method, byte[] attribute) {
            this.method = method;
            this.attribute = attribute;
        }
    }

    private static class FieldAttributeInfo {
        public final byte[] attribute;
        public final JavaField field;

        public FieldAttributeInfo(JavaField field, byte[] attribute) {
            this.field = field;
            this.attribute = attribute;
        }
    }

    private class AttributeClassAdapter
    extends ClassAdapter {
        private static final String INIT_METHOD_NAME = "<init>";
        private boolean classLevelAnnotationDone = false;

        public AttributeClassAdapter(ClassVisitor cv) {
            super(cv);
        }

        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
            RuntimeInvisibleAnnotations invisible = CustomAttributeHelper.linkRuntimeInvisibleAnnotations(attrs);
            Iterator it = AsmAttributeEnhancer.this.m_fieldAttributes.iterator();
            while (it.hasNext()) {
                FieldAttributeInfo struct = (FieldAttributeInfo)it.next();
                if (!name.equals(struct.field.getName())) continue;
                invisible.annotations.add(CustomAttributeHelper.createCustomAnnotation(struct.attribute));
            }
            if (invisible.annotations.size() == 0) {
                invisible = null;
            }
            super.visitField(access, name, desc, value, attrs != null ? attrs : invisible);
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            RuntimeInvisibleAnnotations invisible = CustomAttributeHelper.linkRuntimeInvisibleAnnotations(attrs);
            if (!name.equals(INIT_METHOD_NAME)) {
                Iterator it = AsmAttributeEnhancer.this.m_methodAttributes.iterator();
                while (it.hasNext()) {
                    MethodAttributeInfo struct = (MethodAttributeInfo)it.next();
                    JavaMethod method = struct.method;
                    Object[] parameters = QDoxParser.getJavaMethodParametersAsStringArray(method);
                    if (!name.equals(method.getName()) || !Arrays.equals(parameters, DescriptorUtil.getParameters(desc))) continue;
                    invisible.annotations.add(CustomAttributeHelper.createCustomAnnotation(struct.attribute));
                }
            } else {
                Iterator it = AsmAttributeEnhancer.this.m_constructorAttributes.iterator();
                while (it.hasNext()) {
                    MethodAttributeInfo struct = (MethodAttributeInfo)it.next();
                    JavaMethod method = struct.method;
                    Object[] parameters = QDoxParser.getJavaMethodParametersAsStringArray(method);
                    if (!name.equals(INIT_METHOD_NAME) || !Arrays.equals(parameters, DescriptorUtil.getParameters(desc))) continue;
                    invisible.annotations.add(CustomAttributeHelper.createCustomAnnotation(struct.attribute));
                }
            }
            if (invisible.annotations.size() == 0) {
                invisible = null;
            }
            return this.cv.visitMethod(access, name, desc, exceptions, attrs != null ? attrs : invisible);
        }

        public void visitAttribute(Attribute attrs) {
            this.classLevelAnnotationDone = true;
            RuntimeInvisibleAnnotations invisible = CustomAttributeHelper.linkRuntimeInvisibleAnnotations(attrs);
            Iterator it = AsmAttributeEnhancer.this.m_classAttributes.iterator();
            while (it.hasNext()) {
                byte[] bytes = (byte[])it.next();
                invisible.annotations.add(CustomAttributeHelper.createCustomAnnotation(bytes));
            }
            if (invisible.annotations.size() == 0) {
                invisible = null;
            }
            super.visitAttribute(attrs != null ? attrs : invisible);
        }

        public void visitEnd() {
            if (!this.classLevelAnnotationDone) {
                this.classLevelAnnotationDone = true;
                RuntimeInvisibleAnnotations invisible = CustomAttributeHelper.linkRuntimeInvisibleAnnotations(null);
                Iterator it = AsmAttributeEnhancer.this.m_classAttributes.iterator();
                while (it.hasNext()) {
                    byte[] bytes = (byte[])it.next();
                    invisible.annotations.add(CustomAttributeHelper.createCustomAnnotation(bytes));
                }
                if (invisible.annotations.size() > 0) {
                    super.visitAttribute(invisible);
                }
                super.visitEnd();
            }
        }
    }
}

