/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.ui.admin.content.AdminGroupUI;
import com.jurismarches.vradi.ui.helpers.AdminNavigationTreeHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class GroupNavigationTreeHelper
extends AdminNavigationTreeHelper {
    private static final Log log = LogFactory.getLog(GroupNavigationTreeHelper.class);
    protected NavigationModel<NavigationTreeNode> cachedModel;
    protected boolean datasChanged = false;

    public GroupNavigationTreeHelper(JAXXContext context) {
        super(VradiContext.getGroupsEntryDef().getName(), context);
        JAXXContextEntryDef<List<Group>> groupsEntryDef = VradiContext.getGroupsEntryDef();
        VradiContext.get().addPropertyChangeListener(groupsEntryDef, groupsEntryDef.getName(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GroupNavigationTreeHelper.this.datasChanged = true;
            }
        });
        JAXXContextEntryDef<List<Client>> clientsEntryDef = VradiContext.getClientsEntryDef();
        VradiContext.get().addPropertyChangeListener(clientsEntryDef, clientsEntryDef.getName(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GroupNavigationTreeHelper.this.datasChanged = true;
            }
        });
        JAXXContextEntryDef<List<Client>> usersEntryDef = VradiContext.getClientsEntryDef();
        VradiContext.get().addPropertyChangeListener(usersEntryDef, usersEntryDef.getName(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GroupNavigationTreeHelper.this.datasChanged = true;
            }
        });
    }

    public NavigationModel createTreeModel() {
        if (this.cachedModel != null && !this.datasChanged) {
            return this.cachedModel;
        }
        JAXXContext context = this.getContext();
        NavigationTreeNode rootNode = (NavigationTreeNode)this.builder.buildEmptyRoot(null, "$root");
        JAXXContextEntryDef<List<Group>> groupsEntryDef = VradiContext.getGroupsEntryDef();
        List<Group> groups = VradiContext.getGroupsInEntryDef();
        NavigationTreeNode groupsNode = (NavigationTreeNode)this.builder.build((NavigationNode)rootNode, I18n._((String)groupsEntryDef.getName()), groupsEntryDef, "groups", AdminGroupUI.class, null);
        for (Group g : groups) {
            this.builder.addGroup(context, groupsNode, g);
        }
        this.cachedModel = this.builder.getModel();
        this.setModel(context, this.cachedModel);
        this.setSelectedNode(context, (NavigationNode)groupsNode);
        this.datasChanged = false;
        return this.cachedModel;
    }

    @Override
    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        JAXXContext context = this.getContext();
        List<Group> groups = VradiContext.getGroupsInEntryDef();
        Group bean = (Group)node.getBean();
        groups.remove(bean);
        return super.removeChildNode(node);
    }
}

