/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListHandler;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.ThesaurusEditUI;
import com.jurismarches.vradi.ui.admin.ThesaurusPathChooserUI;
import com.jurismarches.vradi.ui.admin.ThesaurusQueryChangesHandler;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI;
import com.jurismarches.vradi.ui.admin.content.ThesaurusQueryChangesUI;
import com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.ModifThesaurusModel;
import com.jurismarches.vradi.ui.query.ThesaurusChangesTreeTableModel;
import com.jurismarches.vradi.ui.search.SearchHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableModel;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class ThesaurusHandler {
    private static Log log = LogFactory.getLog(ThesaurusHandler.class);
    public static String PREFIX_THESAURUS = "thesaurus";
    public static String PREFIX_EDIT = "edit";
    public static String PREFIX_MOVE = "move";
    private VradiStorageService vradiStorageService = null;

    protected VradiStorageService getVradiStorageService() {
        if (this.vradiStorageService == null) {
            this.vradiStorageService = VradiService.getVradiStorageService();
        }
        return this.vradiStorageService;
    }

    public ThesaurusUI initUI(JAXXContext context, OfferEditUI parentUI, VradiThesaurusDTO rootThesaurus, Form bean, boolean deletable) {
        ThesaurusUI ui = new ThesaurusUI(context, parentUI, rootThesaurus);
        ui.setDeletable(deletable);
        ui.setBean(bean);
        return ui;
    }

    public void initThesaurus(JAXXContext context, OfferEditUI ui) {
        JPanel thesaurusPanel = ui.getThesaurus();
        thesaurusPanel.removeAll();
        List<String> thesaurusId = VradiHelper.getVradiListThesaurus();
        VradiThesaurusDTO rootThesaurus = VradiContext.getThesaurusInEntryDef();
        ThesaurusUI rootThesaurusUI = this.initUI((JAXXContext)ui, ui, rootThesaurus, ui.getData(), false);
        thesaurusPanel.add((Component)((Object)rootThesaurusUI));
        ArrayList<VradiThesaurusDTO> thesaurusSaved = new ArrayList<VradiThesaurusDTO>();
        if (thesaurusId != null) {
            for (String id : thesaurusId) {
                VradiThesaurusDTO savedThesaurus = rootThesaurus.findThesaurus(id);
                if (savedThesaurus == null) continue;
                thesaurusSaved.add(savedThesaurus);
            }
        }
        JList propositionList = ui.propositionList;
        for (VradiThesaurusDTO saved : thesaurusSaved) {
            ThesaurusUI thesaurusUI = this.initUI(context, ui, saved, ui.getData(), true);
            thesaurusPanel.add((Component)((Object)thesaurusUI));
            ThesaurusListener thesaurusListener = new ThesaurusListener(ui);
            thesaurusUI.getThesaurus().addTreeSelectionListener(thesaurusListener);
        }
        JTree thesaurus = rootThesaurusUI.getThesaurus();
        RootThesaurusListener rootThesaurusListener = new RootThesaurusListener(ui);
        thesaurus.addTreeSelectionListener(rootThesaurusListener);
        propositionList.getSelectionModel().addListSelectionListener(new ThesaurusListener(ui));
        ui.updateThesaurusSize();
    }

    public ThesaurusUI getUI(JAXXContext context) {
        if (context instanceof ThesaurusUI) {
            return (ThesaurusUI)context;
        }
        return null;
    }

    public VradiThesaurusDTO findThesaurusInRef(String wikityId) {
        VradiThesaurusDTO root = VradiContext.getThesaurusInEntryDef();
        return root.findThesaurus(wikityId);
    }

    public VradiThesaurusDTO isNameExisting(VradiThesaurusDTO root, String name) {
        return root.isNameExisting(name);
    }

    protected JPanel getThesaurusContainer(JAXXContext context) {
        return this.getUI(context).getParentContainer(OfferEditUI.class).getThesaurus();
    }

    protected OfferEditUI getEditUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferEditHandler.class).getUI(context);
    }

    protected OfferListUI getListUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferListHandler.class).getUI(context);
    }

    protected NavigationNode<?> getParentNode(ThesaurusTreeHelper helper, TreePath path) {
        if (path == null) {
            return helper.getRootNode();
        }
        return (NavigationTreeNode)path.getLastPathComponent();
    }

    public void addCriteria(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        OfferListUI ui = this.getListUI(context);
        NavigationNode<?> parentNode = this.getParentNode(helper, path);
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)parentNode.getBean(context);
        UIHelper.getHandler(context, SearchHandler.class).addAndPersistCriteria(context, thesaurus);
        ui.validate();
    }

    public void refreshAllThesaurus(JAXXContext context) {
        List editUIs = (List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh ui : " + (editUIs == null ? "is null" : Integer.valueOf(editUIs.size()))));
        }
        if (editUIs != null) {
            for (OfferEditUI editUI : editUIs) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Refresh ui : " + editUI.getData().getObjet()));
                }
                this.initThesaurus(context, editUI);
            }
        }
    }

    public void refreshOtherThesaurus(JAXXContext context, OfferEditUI ui) {
        List editUIs = (List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh ui : " + (editUIs == null ? "is null" : Integer.valueOf(editUIs.size()))));
        }
        if (editUIs != null) {
            for (OfferEditUI editUI : editUIs) {
                if (editUI.equals(ui)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Refresh ui : " + editUI.getData().getObjet()));
                }
                this.initThesaurus(context, editUI);
            }
        }
    }

    public void addThesaurusUI(JAXXContext context, TreePath path) {
        if (path != null) {
            NavigationTreeNode parentNode = (NavigationTreeNode)path.getLastPathComponent();
            VradiThesaurusDTO thesaurusParent = (VradiThesaurusDTO)parentNode.getBean(context);
            this.addThesaurusUI(context, thesaurusParent, true, true);
        }
    }

    public void addThesaurusUI(JAXXContext context, VradiThesaurusDTO root, boolean deletable, boolean save) {
        if (root == null) {
            return;
        }
        OfferEditUI ui = this.getUI(context).getParentContainer(OfferEditUI.class);
        ThesaurusUI thesaurusChildUI = new ThesaurusUI(context, ui, root);
        thesaurusChildUI.setDeletable(deletable);
        this.getThesaurusContainer(context).add((Component)((Object)thesaurusChildUI));
        if (save) {
            TreeNodeImpl treeNode = VradiContext.findTreeNodeInEntryDef(root.getWikittyId());
            VradiHelper.addVradiListThesaurus(treeNode);
        }
        ui.updateThesaurusSize();
        ThesaurusListener listener = new ThesaurusListener(ui);
        ThesaurusTreeHelper helper = thesaurusChildUI.getHelper();
        helper.getTree(helper.context).addTreeSelectionListener(listener);
        helper.registerListener(listener);
        ThesaurusTreeHelper rootHelper = ui.getRootThesaurusHelper();
        List selectedBeans = rootHelper.getSelectedBeans(rootHelper.context);
        helper.tryToSelect(selectedBeans);
        this.refreshOtherThesaurus(context, ui);
    }

    public void addColumn(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        NavigationNode<?> node = this.getParentNode(helper, path);
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)node.getBean(context);
        TreeNodeImpl treeNode = VradiContext.findTreeNodeInEntryDef(thesaurus.getWikittyId());
        VradiHelper.addVradiListThesaurus(treeNode);
    }

    public void closeThesaurus(JAXXContext context) {
        ThesaurusUI thesaurusUI = this.getUI(context);
        OfferEditUI ui = thesaurusUI.getParentContainer(OfferEditUI.class);
        this.getThesaurusContainer(context).remove((Component)((Object)thesaurusUI));
        VradiThesaurusDTO selected = (VradiThesaurusDTO)thesaurusUI.helper.getRootNode().getBean();
        TreeNodeImpl treeNode = VradiContext.findTreeNodeInEntryDef(selected.getWikittyId());
        VradiHelper.removeVradiListThesaurus(treeNode);
        ui.updateThesaurusSize();
        this.refreshOtherThesaurus((JAXXContext)thesaurusUI, ui);
    }

    public boolean answerToSaveBeforeQuit(AdminThesaurusUI content) {
        if (content != null) {
            log.info((Object)("current content  to close " + ((Object)((Object)content)).getClass().getSimpleName() + " : " + content.isModified()));
            String msgs = content.getModifModel().getAllMsgs();
            if (content.isModified().booleanValue()) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)content), I18n._((String)"vradi.admin.saveAnswer", (Object[])new Object[]{msgs}), I18n._((String)"vradi.admin.saveTitle"), 1);
                switch (n) {
                    case 1: {
                        this.cancelThesaurus((JAXXContext)content, content.getHelper(), false);
                        break;
                    }
                    case 0: {
                        this.saveThesaurus(content, content.getHelper(), false);
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected NavigationNode getSelectedNode(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationNode selectedNode = helper.getSelectedNode(context);
        if (selectedNode == null) {
            selectedNode = helper.getRootNode();
        }
        return selectedNode;
    }

    public boolean addChildThesaurusToSelected(JAXXContext context, ThesaurusTreeHelper helper, ModifThesaurusModel modifThesaurusModel) {
        NavigationTreeTableNode parentNode = (NavigationTreeTableNode)this.getSelectedNode(context, helper);
        VradiThesaurusDTO created = this.addChildThesaurus(context, helper, parentNode, modifThesaurusModel);
        if (created == null) {
            return false;
        }
        modifThesaurusModel.addCreateModif(created);
        return true;
    }

    private VradiThesaurusDTO addChildThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeTableNode parentNode, ModifThesaurusModel modifThesaurusModel) {
        String name;
        VradiThesaurusDTO thesaurusParent = (VradiThesaurusDTO)parentNode.getBean(context);
        TreeNodeImpl newTreeNode = new TreeNodeImpl();
        VradiThesaurusDTO newThesaurus = new VradiThesaurusDTO();
        newThesaurus.fromWikitty(newTreeNode);
        newThesaurus.setParentThesaurus(thesaurusParent);
        VradiThesaurusDTO cloned = newThesaurus.clone();
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.init(helper, newThesaurus, cloned, modifThesaurusModel, I18n._((String)"vradi.adminThesaurus.creationTitle"), true);
        if (edit.isSave().booleanValue() && (name = newThesaurus.getName()) != null && !name.isEmpty()) {
            newThesaurus.setParentThesaurus(thesaurusParent);
            thesaurusParent.addChild(newThesaurus);
            newThesaurus.setToCreate(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding thesaurus " + newThesaurus.getName() + " to parent " + parentNode));
            }
            NavigationTreeTableNode newNode = helper.getTreeTableBuilder().addThesaurus(context, parentNode, newThesaurus);
            helper.selectNode(context, (NavigationNode)newNode);
            return newThesaurus;
        }
        return null;
    }

    public boolean editThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper, ModifThesaurusModel modifThesaurusModel) {
        NavigationNode selectedNode = this.getSelectedNode(context, helper);
        VradiThesaurusDTO selected = (VradiThesaurusDTO)selectedNode.getBean(context);
        VradiThesaurusDTO cloned = selected.clone();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Editing thesaurus " + (selected == null ? " null " : selected.getName())));
        }
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.init(helper, selected, cloned, modifThesaurusModel, I18n._((String)"vradi.adminThesaurus.editTitle", (Object[])new Object[]{selected.getName()}), false);
        if (edit.isSave().booleanValue()) {
            selected.setToSave(true);
            selectedNode = this.getSelectedNode((JAXXContext)edit, helper);
            helper.repaintNode(context, selectedNode);
            helper.sort(context, selectedNode);
            helper.expendNode(selectedNode);
            modifThesaurusModel.confirmAttributeModif();
            return true;
        }
        modifThesaurusModel.cancelAttributeModif();
        return false;
    }

    public boolean deleteThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper, ModifThesaurusModel modifThesaurusModel) {
        NavigationNode selectedNode = this.getSelectedNode(context, helper);
        VradiThesaurusDTO toDelete = (VradiThesaurusDTO)selectedNode.getBean(context);
        modifThesaurusModel.addDeleteModif(toDelete);
        return this.deleteThesaurus(context, helper, selectedNode, false);
    }

    public boolean deleteThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationNode<?> nodeToDelete, boolean ask) {
        VradiThesaurusDTO selected = (VradiThesaurusDTO)nodeToDelete.getBean(context);
        int result = ask ? JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.thesaurus.askdeleteThesaurus") + selected.getRecursifName()) : 0;
        if (result == 0) {
            selected.setToDelete(true);
            NavigationModel navigationModel = helper.getModel(context);
            navigationModel.removeNodeFromParent(nodeToDelete);
            NavigationNode rootNode = helper.getRootNode();
            helper.setSelectedNode(context, rootNode);
            return true;
        }
        return false;
    }

    private void deleteTreeNode(VradiThesaurusDTO toDelete) {
        try {
            TreeNodeImpl treeNode = VradiContext.findTreeNodeInEntryDef(toDelete.getWikittyId());
            VradiService.getVradiStorageService().deleteEntity((BusinessEntity)treeNode);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void cancelThesaurus(JAXXContext context, ThesaurusTreeHelper helper, boolean trigerredByCancelButton) {
        int confirm = -1;
        if (trigerredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog((JComponent)context, I18n._((String)"vradi.admin.cancel.message"), I18n._((String)"vradi.admin.cancel.title"), 0, 2);
        }
        if (!trigerredByCancelButton || confirm == 0) {
            helper = new ThesaurusTreeHelper(context, PREFIX_EDIT, 0);
            AdminThesaurusUI ui = (AdminThesaurusUI)context;
            ui.reinit(helper);
        }
    }

    public List<TreeNodeImpl> getAllThesaurus(VradiThesaurusDTO node) {
        ArrayList<TreeNodeImpl> result = new ArrayList<TreeNodeImpl>();
        for (VradiThesaurusDTO child : node.getChildren()) {
            TreeNodeImpl treeNode = VradiContext.findTreeNodeInEntryDef(child.getWikittyId());
            result.add(treeNode);
            result.addAll(this.getAllThesaurus(child));
        }
        return result;
    }

    public void saveThesaurus(AdminThesaurusUI adminThesaurusUI, ThesaurusTreeHelper helper, boolean answer) {
        Object before;
        ModifThesaurusModel modifModel = adminThesaurusUI.getModifModel();
        if (answer) {
            String msgs = modifModel.getAllMsgs();
            JLabel labelModifications = new JLabel(I18n._((String)"vradi.admin.saveThesaurusAnswer"));
            JTextArea areaModifications = new JTextArea(msgs);
            areaModifications.setEditable(false);
            areaModifications.setAutoscrolls(true);
            JScrollPane sp = new JScrollPane(areaModifications);
            sp.setPreferredSize(new Dimension(600, 100));
            int n = JOptionPane.showConfirmDialog((Component)((Object)adminThesaurusUI), new Object[]{labelModifications, sp}, I18n._((String)"vradi.admin.saveTitle"), 0);
            if (n == 1) {
                return;
            }
        }
        HashMap<String, String> modifications = new HashMap<String, String>();
        List modifThesaurusList = modifModel.getValues();
        for (ModifThesaurusModel.ModifThesaurus modifThesaurus : modifThesaurusList) {
            VradiThesaurusDTO after;
            if (!modifThesaurus.canImpactRequest() || (before = this.findThesaurusInRef((after = modifThesaurus.getConcernedThesaurus()).getWikittyId())) == null) continue;
            if (modifThesaurus instanceof ModifThesaurusModel.DeleteModif) {
                while (after.getDepth() > 1 && after.isToDelete()) {
                    after = after.getParentThesaurus();
                }
                if (after.isRoot() || after.isToDelete()) {
                    after = modifThesaurus.getConcernedThesaurus();
                }
            }
            modifications.put(before.getName(), after.getName());
        }
        try {
            VradiThesaurusDTO rootThesaurus = helper.getRootThesaurus();
            this.saveThesaurus(rootThesaurus);
            VradiContext.initThesaurusDef();
            adminThesaurusUI.getModifModel().clear();
            adminThesaurusUI.setModified(false);
            UIHelper.getHandler((JAXXContext)adminThesaurusUI, SearchHandler.class).initCriteria((JAXXContext)adminThesaurusUI);
            this.clearThesaurusModel();
            this.refreshAllThesaurus((JAXXContext)adminThesaurusUI);
            for (Map.Entry entry : modifications.entrySet()) {
                before = (String)entry.getKey();
                String after = (String)entry.getValue();
                this.modifyQueries((JAXXContext)adminThesaurusUI, (String)before, after);
            }
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void clearThesaurusModel() {
        Map models = (Map)VradiContext.THESAURUS_NAVIGATION_MODEL.getContextValue((JAXXContext)VradiContext.get());
        if (models != null) {
            models.clear();
            VradiContext.THESAURUS_NAVIGATION_MODEL.setContextValue((JAXXContext)VradiContext.get(), (Object)models);
        }
    }

    protected void modifyQueries(JAXXContext context, String before, String after) {
        Map queryMakers = VradiService.getVradiStorageService().getQueriesToModifyAfterThesaurusModification(before);
        if (queryMakers.isEmpty()) {
            return;
        }
        ThesaurusQueryChangesHandler handler = new ThesaurusQueryChangesHandler();
        ThesaurusQueryChangesUI thesaurusChangesUI = handler.initUI(context, queryMakers, before, after);
        thesaurusChangesUI.setModifiedQueries(Boolean.FALSE);
        thesaurusChangesUI.setVisible(true);
        if (!thesaurusChangesUI.isModifiedQueries().booleanValue()) {
            return;
        }
        try {
            BusinessEntity[] updateEntities;
            ThesaurusChangesTreeTableModel model = thesaurusChangesUI.getContextValue(ThesaurusChangesTreeTableModel.class);
            List<QueryMaker> updatedQueryMakers = model.getUpdatedQueryMakers();
            BusinessEntity[] queryMakers2 = new QueryMaker[updatedQueryMakers.size()];
            updatedQueryMakers.toArray(queryMakers2);
            for (BusinessEntity businessEntity : updateEntities = VradiService.getVradiStorageService().updateEntities(queryMakers2)) {
                VradiContext.replace(businessEntity);
            }
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void saveThesaurus(VradiThesaurusDTO toSave) {
        List children;
        TreeNodeImpl bean = VradiContext.findTreeNodeInEntryDef(toSave.getWikittyId());
        if (bean == null) {
            bean = new TreeNodeImpl();
            toSave.toWikitty(bean);
        }
        if (toSave.isToDelete()) {
            this.deleteTreeNode(toSave);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting thesaurus : " + bean.getName()));
            }
        }
        if (toSave.isToSave() || toSave.isToCreate()) {
            try {
                VradiThesaurusDTO parentThesaurus = toSave.getParentThesaurus();
                if (parentThesaurus != null) {
                    bean.setParent(parentThesaurus.getWikittyId());
                }
                toSave.toWikitty(bean);
                VradiService.getVradiStorageService().updateEntity((BusinessEntity)bean);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saving thesaurus : " + bean.getName()));
                }
            }
            catch (VradiException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            toSave.setToSave(false);
            toSave.setToCreate(false);
        }
        if ((children = toSave.getChildren()) != null) {
            for (VradiThesaurusDTO child : children) {
                if (child == null) continue;
                this.saveThesaurus(child);
            }
        }
    }

    public void changeThesaurusColor(JAXXContext context, ThesaurusTreeHelper helper) {
        VradiThesaurusDTO selected = (VradiThesaurusDTO)this.getSelectedNode(context, helper).getBean();
        int depth = selected.getDepth();
        Color initialColor = VradiHelper.getColorsThesaurusFromProperties().get(depth);
        Color colorChoosed = JColorChooser.showDialog((Component)((Object)((AdminThesaurusUI)context)), I18n._((String)"vradi.thesaurus.colorTitle"), initialColor);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Store color " + colorChoosed + " for depth " + depth));
        }
        VradiHelper.storeThesaurusColorToProperties(depth, colorChoosed);
        helper.reinitColors();
        this.reinitColors();
    }

    public void reinitColors() {
        List editUIs = (List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (editUIs != null) {
            for (OfferEditUI ui : editUIs) {
                List<ThesaurusTreeHelper> treeHelperList = ui.getListThesaurusHelpers();
                if (treeHelperList == null) continue;
                for (ThesaurusTreeHelper helper : treeHelperList) {
                    helper.reinitColors();
                }
            }
        }
    }

    public boolean moveThesaurus(JAXXContext context, ThesaurusTreeHelper helperFrom, ModifThesaurusModel modifThesaurusModel) {
        VradiThesaurusDTO toMove = (VradiThesaurusDTO)helperFrom.getSelectedBean(context);
        NavigationTreeTableNode navigationTreeNode = this.moveThesaurus(context, helperFrom, toMove);
        if (navigationTreeNode == null) {
            return false;
        }
        this.applyMoveThesaurus(context, helperFrom, toMove, navigationTreeNode, modifThesaurusModel);
        return true;
    }

    public NavigationTreeTableNode moveThesaurus(JAXXContext context, ThesaurusTreeHelper helperFrom, VradiThesaurusDTO beanToMove) {
        VradiThesaurusDTO rootThesaurus = helperFrom.getRootThesaurus().clone();
        boolean isDeleted = rootThesaurus.removeThesaurusRecursivly(beanToMove);
        if (log.isDebugEnabled()) {
            if (isDeleted) {
                log.debug((Object)("Thesaurus " + beanToMove.getName() + " is deleted"));
            } else {
                log.debug((Object)("Thesaurus " + beanToMove.getName() + " is not deleted (not found)"));
            }
        }
        ThesaurusTreeHelper selectHelper = new ThesaurusTreeHelper(context, rootThesaurus, PREFIX_MOVE, 0);
        ThesaurusPathChooserUI selectUI = new ThesaurusPathChooserUI(context, selectHelper);
        selectUI.setVisible(true);
        if (selectUI.isSaved().booleanValue()) {
            NavigationTreeTableNode selectedNode = (NavigationTreeTableNode)this.getSelectedNode((JAXXContext)selectUI, selectHelper);
            return selectedNode;
        }
        return null;
    }

    public void applyMoveThesaurus(JAXXContext context, ThesaurusTreeHelper helperFrom, VradiThesaurusDTO beanToMove, NavigationTreeTableNode nodeParentSelected, ModifThesaurusModel modifThesaurusModel) {
        NavigationNode nodeToMove = this.getSelectedNode(context, helperFrom);
        VradiThesaurusDTO beanParentSelected = (VradiThesaurusDTO)nodeParentSelected.getBean();
        String parentSelectedPath = beanParentSelected.getPath(PREFIX_EDIT, helperFrom.getPathSeparator());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching node whith path : " + parentSelectedPath));
        }
        String parentPath = beanToMove.getParentThesaurus().getPath(PREFIX_EDIT, helperFrom.getPathSeparator());
        String parentNamePath = beanToMove.getParentThesaurus().getNamePath(helperFrom.getPathSeparator());
        modifThesaurusModel.addMoveModif(beanToMove, parentNamePath, parentPath, parentSelectedPath);
        NavigationTreeTableNode nodeParentSelectedFrom = (NavigationTreeTableNode)helperFrom.findNode(context, parentSelectedPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected node : " + nodeParentSelected.getFullPath() + " finded node : " + nodeParentSelectedFrom.getFullPath()));
        }
        this.deleteThesaurus(context, helperFrom, nodeToMove, false);
        beanToMove.setToDelete(false);
        VradiThesaurusDTO oldParent = beanToMove.getParentThesaurus();
        oldParent.removeChild(beanToMove);
        VradiThesaurusDTO thesaurusParentFrom = (VradiThesaurusDTO)nodeParentSelectedFrom.getBean(context);
        thesaurusParentFrom.addChild(beanToMove);
        beanToMove.setParentThesaurus(thesaurusParentFrom);
        beanToMove.setToSave(true);
        NavigationTreeTableNode newNode = helperFrom.getTreeTableBuilder().addThesaurusAndChildrenRecursivly(nodeParentSelectedFrom, beanToMove);
        helperFrom.selectNode(context, (NavigationNode)nodeParentSelectedFrom);
        if (context instanceof ThesaurusEditUI) {
            ((ThesaurusEditUI)context).getPathField().setText(beanToMove.getParentPath(helperFrom.getPathSeparator()));
        }
    }

    public void viewApply(JAXXContext context, List<VradiThesaurusDTO> concerned) {
        UIHelper.getHandler(context, AdminHandler.class).openRequest(context, concerned);
    }

    public void exportThesaurusCSV(AdminThesaurusUI adminThesaurusUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminThesaurus.exportThesaurusTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminThesaurus.exportButtonText"));
                int returnVal = chooser.showOpenDialog((Component)((Object)adminThesaurusUI));
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporting thesaurus to : " + selectedFile.getAbsolutePath()));
                    }
                    Search search = Search.query().eq(Element.ELT_EXTENSION, "TreeNode");
                    Criteria criteria = search.criteria();
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String vscContent = vradiStorageService.exportAsCSV(criteria);
                    FileUtils.writeStringToFile((File)selectedFile, (String)vscContent);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't export thesaurus", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't export thesaurus", (Throwable)eee);
            }
        }
    }

    public void importCSV(AdminThesaurusUI adminThesaurusUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminThesaurus.importTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminThesaurus.importButtonText"));
                int returnVal = chooser.showOpenDialog((Component)((Object)adminThesaurusUI));
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Importing file : " + selectedFile.getAbsolutePath()));
                    }
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String uri = selectedFile.toURI().toURL().toExternalForm();
                    vradiStorageService.importAsCSV(uri);
                    VradiContext.initEntryDef();
                    ThesaurusTreeHelper helper = adminThesaurusUI.getHelper();
                    adminThesaurusUI.getThesaurus().setTreeTableModel((TreeTableModel)((NavigationTreeTableModel)helper.getModel((JAXXContext)adminThesaurusUI)));
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import file", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't import file", (Throwable)eee);
            }
        }
    }

    public static class CopyToClipboard
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final AdminThesaurusUI thesaurusUI;

        public CopyToClipboard(AdminThesaurusUI thesaurusUI) {
            super(I18n._((String)"vradi.common.copy"));
            this.thesaurusUI = thesaurusUI;
            JXTreeTable treeTable = thesaurusUI.getThesaurus();
            InputMap inputMap = treeTable.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(67, 2), "ThesaurusHandler.CopyToClipboard");
            ActionMap actionMap = treeTable.getActionMap();
            actionMap.put("ThesaurusHandler.CopyToClipboard", this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThesaurusTreeHelper helper = this.thesaurusUI.getHelper();
            NavigationNode selectedNode = helper.getSelectedNode((JAXXContext)this.thesaurusUI);
            if (selectedNode == null || selectedNode.isRoot()) {
                return;
            }
            VradiThesaurusDTO bean = (VradiThesaurusDTO)selectedNode.getBean();
            if (bean == null) {
                return;
            }
            String name = "\"" + bean.getName() + "\"";
            StringSelection selection = new StringSelection("thesaurus:" + name);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
        }
    }

    public class ThesaurusListener
    implements TreeSelectionListener,
    ListSelectionListener {
        protected JList propositionList;
        protected List<Object> oldsPropositionsSelected;
        protected OfferEditUI ui;

        public ThesaurusListener(OfferEditUI ui) {
            this.propositionList = ui.propositionList;
            this.ui = ui;
            this.propositionList.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            ArrayList<Object> toAdd = new ArrayList<Object>();
            ArrayList<Object> toRemove = new ArrayList<Object>();
            for (TreePath path : paths) {
                NavigationTreeNode node = (NavigationTreeNode)path.getLastPathComponent();
                if (e.isAddedPath(path)) {
                    toAdd.add(node.getBean());
                    continue;
                }
                toRemove.add(node.getBean());
            }
            ThesaurusTreeHelper rootHelper = this.ui.getRootThesaurusHelper();
            rootHelper.desactiveListener();
            rootHelper.tryToSelect((List<Object>)toAdd);
            rootHelper.tryToUnselect((List<Object>)toRemove);
            rootHelper.activeListener();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            VradiThesaurusDTO proposition;
            List<Object> newPropositionsSelected = Arrays.asList(this.propositionList.getSelectedValues());
            ArrayList<String> idsToAdd = new ArrayList<String>();
            ArrayList<String> idsToRemove = new ArrayList<String>();
            for (Object o : newPropositionsSelected) {
                if (this.oldsPropositionsSelected != null && this.oldsPropositionsSelected.contains(o)) continue;
                proposition = (VradiThesaurusDTO)o;
                idsToAdd.add(proposition.getWikittyId());
            }
            if (this.oldsPropositionsSelected != null) {
                for (Object o : this.oldsPropositionsSelected) {
                    if (newPropositionsSelected.contains(o)) continue;
                    proposition = (VradiThesaurusDTO)o;
                    idsToRemove.add(proposition.getWikittyId());
                }
            }
            ThesaurusTreeHelper rootHelper = this.ui.getRootThesaurusHelper();
            rootHelper.desactiveListener();
            rootHelper.tryToSelect((Collection<String>)idsToAdd);
            rootHelper.tryToUnselect((Collection<String>)idsToRemove);
            rootHelper.activeListener();
            this.oldsPropositionsSelected = newPropositionsSelected;
        }
    }

    public class RootThesaurusListener
    implements TreeSelectionListener {
        protected JList propositionList;
        protected OfferEditUI ui;

        public RootThesaurusListener(OfferEditUI ui) {
            this.propositionList = ui.propositionList;
            this.ui = ui;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            ArrayList<Object> toAdd = new ArrayList<Object>();
            ArrayList<Object> toRemove = new ArrayList<Object>();
            for (TreePath path : paths) {
                NavigationTreeNode node = (NavigationTreeNode)path.getLastPathComponent();
                if (e.isAddedPath(path)) {
                    toAdd.add(node.getBean());
                    continue;
                }
                toRemove.add(node.getBean());
            }
            List<ThesaurusTreeHelper> helpers = this.ui.getListThesaurusHelpers();
            for (ThesaurusTreeHelper helper : helpers) {
                helper.desactiveListener();
                helper.tryToSelect((List<Object>)toAdd);
                helper.tryToUnselect((List<Object>)toRemove);
                helper.activeListener();
            }
            ThesaurusTreeHelper rootHelper = this.ui.getRootThesaurusHelper();
            List beans = rootHelper.getSelectedBeans(rootHelper.context);
            DefaultListModel propositionModel = (DefaultListModel)this.propositionList.getModel();
            if (beans != null) {
                for (Object bean : new ArrayList(beans)) {
                    int i = propositionModel.indexOf(bean);
                    if (i == -1) continue;
                    int[] indices = this.propositionList.getSelectedIndices();
                    indices = Arrays.copyOf(indices, indices.length + 1);
                    indices[indices.length - 1] = i;
                    this.propositionList.setSelectedIndices(indices);
                }
            }
        }
    }
}

