/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.VradiUserImpl;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.LoginUI;
import com.jurismarches.vradi.ui.RegisterUI;
import java.awt.Color;
import java.security.NoSuchAlgorithmException;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class LoginHandler {
    private static final Log log = LogFactory.getLog(LoginHandler.class);
    private static final String emptyPassword = "null";

    public VradiStorageService getVradiStorageService() {
        return VradiService.getVradiStorageService();
    }

    public void logUser(LoginUI ui) {
        try {
            String userName = ui.getUserName().getText().trim();
            String password = String.valueOf(ui.getPassword().getPassword()).trim();
            VradiUser user = null;
            try {
                user = this.getVradiStorageService().logVradiUser(userName, password.isEmpty() ? emptyPassword : StringUtil.encodeMD5((String)password));
            }
            catch (NoSuchAlgorithmException eee) {
                log.error((Object)"Cant convert password to MD5");
                ErrorDialogUI.showError((Exception)eee);
            }
            if (user != null) {
                ui.setBean(user);
            } else {
                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.login.error"), I18n._((String)"vradi.login.error.message"), 0);
                ui.getUserName().grabFocus();
            }
        }
        catch (VradiException eee) {
            JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.login.error"), I18n._((String)"vradi.login.error.message"), 0);
        }
    }

    public void register(LoginUI ui) {
        RegisterUI regUI = new RegisterUI((JAXXContext)ui);
        regUI.setLocationRelativeTo(ui);
        regUI.setVisible(true);
    }

    public void register(RegisterUI ui) {
        block9: {
            try {
                String beanPassword = ui.getBean().getPassword();
                String repeatPassword = String.valueOf(ui.getRepeatPassword().getPassword());
                if (beanPassword != null && beanPassword.equals(repeatPassword)) {
                    if (beanPassword.isEmpty()) {
                        ui.getBean().setPassword(emptyPassword);
                    } else {
                        try {
                            ui.getBean().setPassword(StringUtil.encodeMD5((String)beanPassword.trim()));
                        }
                        catch (NoSuchAlgorithmException eee) {
                            log.error((Object)"Cant convert password to MD5");
                            ErrorDialogUI.showError((Exception)eee);
                        }
                    }
                    VradiUser result = new VradiUserImpl();
                    ui.getBean().toWikitty(result);
                    result = this.getVradiStorageService().updateVradiUser(result);
                    if (result == null) {
                        JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.user.error"), I18n._((String)"vradi.register.user.error.message"), 0);
                        ui.getUserName().grabFocus();
                        ui.getUserName().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
                    } else {
                        JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.ok"), I18n._((String)"vradi.register.ok.message"), 1);
                        ui.dispose();
                    }
                    break block9;
                }
                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.password.error"), I18n._((String)"vradi.register.password.error.message"), 0);
                ui.getPassword().grabFocus();
                ui.getPassword().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
                ui.getRepeatPassword().setBorder(BorderFactory.createLineBorder(Color.RED));
            }
            catch (VradiException eee) {
                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.password.error"), I18n._((String)"vradi.register.password.error.message"), 0);
            }
        }
    }
}

