/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiSessionDTO;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.VradiComparators;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

public class VradiContext
extends DefaultApplicationContext {
    private static Log log = LogFactory.getLog(VradiContext.class);
    public static final JAXXContextEntryDef<VradiMainUI> MAIN_UI_ENTRY_DEF = SwingUtil.newContextEntryDef((String)"mainui", VradiMainUI.class);
    public static final JAXXContextEntryDef<OfferListUI> OFFERT_LIST_UI_ENTRY_DEF = SwingUtil.newContextEntryDef((String)"offerList", OfferListUI.class);
    public static final JAXXContextEntryDef<List<OfferEditUI>> OFFERT_EDIT_UI_ENTRY_DEF = SwingUtil.newListContextEntryDef((String)"offerEdit");
    public static final JAXXContextEntryDef<SearchUI> SEARCH_UI_ENTRY_DEF = SwingUtil.newContextEntryDef((String)"searchUI", SearchUI.class);
    public static final JAXXContextEntryDef<AdminPopupUI> ADMIN_UI_ENTRY_DEF = SwingUtil.newContextEntryDef((String)"adminPopupUI", AdminPopupUI.class);
    public static final JAXXContextEntryDef<EmailPopupUI> EMAIL_UI_ENTRY_DEF = SwingUtil.newContextEntryDef((String)"emailViewUI", EmailPopupUI.class);
    public static final JAXXContextEntryDef<Map<String, NavigationModel>> THESAURUS_NAVIGATION_MODEL = SwingUtil.newMapContextEntryDef((String)I18n.n_((String)"vradi.thesaurus.models"));
    public static final JAXXContextEntryDef<TreeNodeImpl> ROOT_TREE_NODE_ENTRY_DEF = SwingUtil.newContextEntryDef((String)I18n.n_((String)"vradi.thesaurus.root"), TreeNodeImpl.class);
    protected static final JAXXContextEntryDef<VradiThesaurusDTO> THESAURUS_ENTRY_DEF = SwingUtil.newContextEntryDef((String)ThesaurusHandler.PREFIX_THESAURUS, VradiThesaurusDTO.class);
    protected static final JAXXContextEntryDef<Map<String, TreeNodeImpl>> TREE_NODE_ENTRY_DEF = SwingUtil.newMapContextEntryDef((String)I18n.n_((String)"vradi.cache.categoryTreeNode"));
    protected static final JAXXContextEntryDef<List<Client>> CLIENTS_ENTRY_DEF = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminClient.categoryClient"));
    protected static final JAXXContextEntryDef<List<User>> USERS_ENTRY_DEF = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminUser.categoryUser"));
    protected static final JAXXContextEntryDef<List<Group>> GROUPS_ENTRY_DEF = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminGroup.categoryGroup"));
    protected static final JAXXContextEntryDef<List<Status>> STATUSES_ENTRY_DEF = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminStatus.categoryStatus"));
    protected static final JAXXContextEntryDef<List<WikittyExtension>> FORMS_TYPE_ENTRY_DEF = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminForm.categoryFormType"));
    protected static final JAXXContextEntryDef<Map<String, Form>> FORMS_ENTRY_DEF = SwingUtil.newMapContextEntryDef((String)I18n.n_((String)"vradi.adminForm.categoryForm"));
    protected static final JAXXContextEntryDef<Map<String, VradiFormDTO>> FORMS_DTO_ENTRY_DEF = SwingUtil.newMapContextEntryDef((String)I18n.n_((String)"vradi.adminForm.categoryFormDTO"));
    protected static final JAXXContextEntryDef<List<XmlStream>> XMLSTREAMS_ENTRY_DEF = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminXmlStream.categoryXmlStream"));
    protected static final JAXXContextEntryDef<List<VradiSessionDTO>> SESSIONS_DTO_ENTRY_DEF = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.email.categorySessionDTO"));
    protected static final JAXXContextEntryDef<Map<String, Session>> SESSIONS_ENTRY_DEF = SwingUtil.newMapContextEntryDef((String)I18n.n_((String)"vradi.email.categorySession"));
    protected static final JAXXContextEntryDef<Map<String, Sending>> SENDING_ENTRY_DEF = SwingUtil.newMapContextEntryDef((String)I18n.n_((String)"vradi.email.categorySending"));
    protected static VradiContext instance;
    protected final Object lock = new Object();

    public static boolean isInit() {
        return instance != null;
    }

    public static synchronized VradiContext init() throws IllegalStateException {
        if (VradiContext.isInit()) {
            throw new IllegalStateException("there is an already application context registred.");
        }
        instance = new VradiContext();
        return instance;
    }

    public static VradiContext get() throws IllegalStateException {
        if (!VradiContext.isInit()) {
            throw new IllegalStateException("no application context registred.");
        }
        return instance;
    }

    protected VradiContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void close() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing context " + (Object)((Object)this)));
        }
        this.clear();
    }

    public static JAXXContextEntryDef<VradiThesaurusDTO> getThesaurusEntryDef() {
        return (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, THESAURUS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<Map<String, TreeNodeImpl>> getTreeNodeEntryDef() {
        JAXXContextEntryDef contextEntryDef = (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, TREE_NODE_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<List<Client>> getClientsEntryDef() {
        return (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, CLIENTS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<List<User>> getUsersEntryDef() {
        return (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, USERS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<List<Group>> getGroupsEntryDef() {
        return (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, GROUPS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<List<Status>> getStatusEntryDef() {
        return (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, STATUSES_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<List<WikittyExtension>> getFormsTypeEntryDef() {
        return (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, FORMS_TYPE_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<Map<String, Form>> getFormsEntryDef() {
        JAXXContextEntryDef contextEntryDef = (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, FORMS_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<Map<String, VradiFormDTO>> getFormsDTOEntryDef() {
        JAXXContextEntryDef contextEntryDef = (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, FORMS_DTO_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<List<XmlStream>> getXmlStreamEntryDef() {
        return (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, XMLSTREAMS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<Map<String, Session>> getSessionEntryDef() {
        JAXXContextEntryDef contextEntryDef = (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, SESSIONS_ENTRY_DEF.getName());
        if (contextEntryDef == null) {
            VradiContext.setSessionEntryDef(new ArrayList<Session>());
        }
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<List<VradiSessionDTO>> getSessionDTOEntryDef() {
        JAXXContextEntryDef contextEntryDef = (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, SESSIONS_DTO_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<Map<String, Sending>> getSendingEntryDef() {
        JAXXContextEntryDef contextEntryDef = (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, SENDING_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<TreeNodeImpl> getRootTreeNodeEntryDef() {
        JAXXContextEntryDef contextEntryDef = (JAXXContextEntryDef)VradiContext.get().getContextValue(JAXXContextEntryDef.class, ROOT_TREE_NODE_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static VradiThesaurusDTO getThesaurusInEntryDef() {
        return (VradiThesaurusDTO)VradiContext.getThesaurusEntryDef().getContextValue((JAXXContext)VradiContext.get());
    }

    public static List<TreeNodeImpl> getTreeNodeInEntryDef() {
        Map map = (Map)VradiContext.getTreeNodeEntryDef().getContextValue((JAXXContext)VradiContext.get());
        return new ArrayList<TreeNodeImpl>(map.values());
    }

    public static List<Client> getClientsInEntryDef() {
        return (List)VradiContext.getClientsEntryDef().getContextValue((JAXXContext)VradiContext.get());
    }

    public static List<User> getUsersInEntryDef() {
        return (List)VradiContext.getUsersEntryDef().getContextValue((JAXXContext)VradiContext.get());
    }

    public static List<Group> getGroupsInEntryDef() {
        return (List)VradiContext.getGroupsEntryDef().getContextValue((JAXXContext)VradiContext.get());
    }

    public static List<Status> getStatusInEntryDef() {
        return (List)VradiContext.getStatusEntryDef().getContextValue((JAXXContext)VradiContext.get());
    }

    public static List<WikittyExtension> getFormsTypeInEntryDef() {
        return (List)VradiContext.getFormsTypeEntryDef().getContextValue((JAXXContext)VradiContext.get());
    }

    public static List<Form> getFormsInEntryDef() {
        JAXXContextEntryDef<Map<String, Form>> contextEntryDef = VradiContext.getFormsEntryDef();
        if (contextEntryDef == null) {
            ArrayList<Form> forms = new ArrayList<Form>();
            VradiContext.setFormsEntryDef(forms);
            return forms;
        }
        Map map = (Map)contextEntryDef.getContextValue((JAXXContext)VradiContext.get());
        return new ArrayList<Form>(map.values());
    }

    public static List<VradiFormDTO> getFormsDTOInEntryDef() {
        JAXXContextEntryDef<Map<String, VradiFormDTO>> contextEntryDef = VradiContext.getFormsDTOEntryDef();
        if (contextEntryDef == null) {
            ArrayList<VradiFormDTO> forms = new ArrayList<VradiFormDTO>();
            VradiContext.setFormsDTOEntryDef(forms);
            return forms;
        }
        Map map = (Map)contextEntryDef.getContextValue((JAXXContext)VradiContext.get());
        return new ArrayList<VradiFormDTO>(map.values());
    }

    public static List<XmlStream> getXmlStreamInEntryDef() {
        return (List)VradiContext.getXmlStreamEntryDef().getContextValue((JAXXContext)VradiContext.get());
    }

    public static List<VradiSessionDTO> getSessionsDTOInEntryDef() {
        JAXXContextEntryDef<List<VradiSessionDTO>> contextEntryDef = VradiContext.getSessionDTOEntryDef();
        if (contextEntryDef == null) {
            ArrayList<VradiSessionDTO> sessions = new ArrayList<VradiSessionDTO>();
            VradiContext.setSessionDTOEntryDef(sessions);
            return sessions;
        }
        return (List)contextEntryDef.getContextValue((JAXXContext)VradiContext.get());
    }

    public static List<Session> getSessionsInEntryDef() {
        JAXXContextEntryDef<Map<String, Session>> contextEntryDef = VradiContext.getSessionEntryDef();
        if (contextEntryDef == null) {
            ArrayList<Session> sessions = new ArrayList<Session>();
            VradiContext.setSessionEntryDef(sessions);
            return sessions;
        }
        Map map = (Map)contextEntryDef.getContextValue((JAXXContext)VradiContext.get());
        return new ArrayList<Session>(map.values());
    }

    public static List<Sending> getSendingInEntryDef() {
        JAXXContextEntryDef<Map<String, Sending>> contextEntryDef = VradiContext.getSendingEntryDef();
        if (contextEntryDef == null) {
            ArrayList<Sending> sendings = new ArrayList<Sending>();
            VradiContext.setSendingEntryDef(sendings);
            return sendings;
        }
        Map map = (Map)contextEntryDef.getContextValue((JAXXContext)VradiContext.get());
        return new ArrayList<Sending>(map.values());
    }

    public static TreeNodeImpl getRootTreeNodeInEntryDef() {
        JAXXContextEntryDef<TreeNodeImpl> contextEntryDef = VradiContext.getRootTreeNodeEntryDef();
        return (TreeNodeImpl)contextEntryDef.getContextValue((JAXXContext)VradiContext.get());
    }

    public static void setThesaurusEntryDef(VradiThesaurusDTO value) {
        THESAURUS_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), (Object)value);
        VradiContext.get().setContextValue(THESAURUS_ENTRY_DEF, THESAURUS_ENTRY_DEF.getName());
    }

    public static void setTreeNodeEntryDef(List<TreeNodeImpl> value) {
        Map<String, TreeNodeImpl> map = VradiContext.fillMap(value);
        TREE_NODE_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), map);
        VradiContext.get().setContextValue(TREE_NODE_ENTRY_DEF, TREE_NODE_ENTRY_DEF.getName());
    }

    public static void setClientsEntryDef(List<Client> values) {
        CLIENTS_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), new ArrayList<Client>(values));
        VradiContext.get().setContextValue(CLIENTS_ENTRY_DEF, CLIENTS_ENTRY_DEF.getName());
    }

    public static void setUsersEntryDef(List<User> values) {
        USERS_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), new ArrayList<User>(values));
        VradiContext.get().setContextValue(USERS_ENTRY_DEF, USERS_ENTRY_DEF.getName());
    }

    public static void setGroupsEntryDef(List<Group> values) {
        GROUPS_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), new ArrayList<Group>(values));
        VradiContext.get().setContextValue(GROUPS_ENTRY_DEF, GROUPS_ENTRY_DEF.getName());
    }

    public static void setStatusEntryDef(List<Status> values) {
        STATUSES_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), new ArrayList<Status>(values));
        VradiContext.get().setContextValue(STATUSES_ENTRY_DEF, STATUSES_ENTRY_DEF.getName());
    }

    public static void setFormsTypeEntryDef(List<WikittyExtension> values) {
        FORMS_TYPE_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), new ArrayList<WikittyExtension>(values));
        VradiContext.get().setContextValue(FORMS_TYPE_ENTRY_DEF, FORMS_TYPE_ENTRY_DEF.getName());
    }

    public static void setFormsEntryDef(List<Form> values) {
        Map<String, Form> map = VradiContext.fillMap(values);
        FORMS_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), map);
        VradiContext.get().setContextValue(FORMS_ENTRY_DEF, FORMS_ENTRY_DEF.getName());
    }

    public static void setFormsDTOEntryDef(List<VradiFormDTO> values) {
        Map<String, VradiFormDTO> map = VradiContext.fillMap(values);
        FORMS_DTO_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), map);
        VradiContext.get().setContextValue(FORMS_DTO_ENTRY_DEF, FORMS_DTO_ENTRY_DEF.getName());
    }

    public static void setXmlStreamEntryDef(List<XmlStream> values) {
        XMLSTREAMS_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), new ArrayList<XmlStream>(values));
        VradiContext.get().setContextValue(XMLSTREAMS_ENTRY_DEF, XMLSTREAMS_ENTRY_DEF.getName());
    }

    public static void setSessionDTOEntryDef(List<VradiSessionDTO> values) {
        SESSIONS_DTO_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), new ArrayList<VradiSessionDTO>(values));
        VradiContext.get().setContextValue(SESSIONS_DTO_ENTRY_DEF, SESSIONS_DTO_ENTRY_DEF.getName());
    }

    public static void setSessionEntryDef(List<Session> values) {
        Map<String, Session> map = VradiContext.fillMap(values);
        SESSIONS_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), map);
        VradiContext.get().setContextValue(SESSIONS_ENTRY_DEF, SESSIONS_ENTRY_DEF.getName());
    }

    public static void setSendingEntryDef(List<Sending> values) {
        Map<String, Sending> map = VradiContext.fillMap(values);
        SENDING_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), map);
        VradiContext.get().setContextValue(SENDING_ENTRY_DEF, SENDING_ENTRY_DEF.getName());
    }

    public static void setRootTreeNodeEntryDef(TreeNodeImpl rootThesaurus) {
        ROOT_TREE_NODE_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), (Object)rootThesaurus);
        VradiContext.get().setContextValue(ROOT_TREE_NODE_ENTRY_DEF, ROOT_TREE_NODE_ENTRY_DEF.getName());
    }

    public static TreeNodeImpl findTreeNodeInEntryDef(String id) {
        TreeNodeImpl result = null;
        TreeNodeImpl root = VradiContext.getRootTreeNodeInEntryDef();
        result = root.getWikittyId().equals(id) ? root : VradiContext.findInMapRef(VradiContext.getTreeNodeEntryDef(), id);
        return result;
    }

    public static List<TreeNodeImpl> findAllTreeNodeInEntryDef(List<String> ids) {
        ArrayList<TreeNodeImpl> result = new ArrayList<TreeNodeImpl>();
        for (String id : ids) {
            result.add(VradiContext.findTreeNodeInEntryDef(id));
        }
        return result;
    }

    public static Form findFormsInEntryDef(String id) {
        return VradiContext.findInMapRef(VradiContext.getFormsEntryDef(), id);
    }

    public static List<Form> findAllFormsInEntryDef(List<VradiFormDTO> formDTOs) {
        List<String> ids = VradiHelper.extractDTOIds(formDTOs);
        return VradiContext.findAllInMapRef(VradiContext.getFormsEntryDef(), ids);
    }

    public static VradiFormDTO findFormsDTOInEntryDef(String id) {
        return VradiContext.findInMapRef(VradiContext.getFormsDTOEntryDef(), id);
    }

    public static Session findSessionInEntryDef(String id) {
        return VradiContext.findInMapRef(VradiContext.getSessionEntryDef(), id);
    }

    public static Sending findSendingInEntryDef(String id) {
        return VradiContext.findInMapRef(VradiContext.getSendingEntryDef(), id);
    }

    public static void addFormInEntryDef(Form form) {
        List<Form> forms = VradiContext.getFormsInEntryDef();
        forms.add(form);
        VradiContext.setFormsEntryDef(forms);
    }

    public static void addAllFormsInEntryDef(List<Form> formList) {
        List<Form> forms = VradiContext.getFormsInEntryDef();
        forms.addAll(formList);
        VradiContext.setFormsEntryDef(forms);
    }

    public static void addFormDTOInEntryDef(VradiFormDTO form) {
        List<VradiFormDTO> forms = VradiContext.getFormsDTOInEntryDef();
        forms.add(form);
        VradiContext.setFormsDTOEntryDef(forms);
    }

    public static void addAllFormsDTOInEntryDef(List<VradiFormDTO> formList) {
        List<VradiFormDTO> forms = VradiContext.getFormsDTOInEntryDef();
        forms.addAll(formList);
        VradiContext.setFormsDTOEntryDef(forms);
    }

    public static void addAllSendingInEntryDef(List<Sending> sendingList) {
        List<Sending> sendings = VradiContext.getSendingInEntryDef();
        sendings.addAll(sendingList);
        VradiContext.setSendingEntryDef(sendings);
    }

    public static void addAllSessionEntryDef(List<Session> sessions) {
        List<Session> cached = VradiContext.getSessionsInEntryDef();
        cached.addAll(sessions);
        VradiContext.setSessionEntryDef(cached);
    }

    public static void addAllSessionDTOEntryDef(List<VradiSessionDTO> sessions) {
        List<VradiSessionDTO> cached = VradiContext.getSessionsDTOInEntryDef();
        cached.addAll(sessions);
        VradiContext.setSessionDTOEntryDef(cached);
    }

    protected static <E extends BusinessEntity> E findInMapRef(JAXXContextEntryDef<Map<String, E>> ref, String id) {
        if (ref == null) {
            return null;
        }
        Map map = (Map)ref.getContextValue((JAXXContext)VradiContext.get());
        return (E)((BusinessEntity)map.get(id));
    }

    private static <E extends BusinessEntity> List<E> findAllInMapRef(JAXXContextEntryDef<Map<String, E>> ref, List<String> ids) {
        ArrayList<E> result = new ArrayList<E>();
        for (String id : ids) {
            result.add(VradiContext.findInMapRef(ref, id));
        }
        return result;
    }

    protected static <E extends BusinessEntity> Map<String, E> fillMap(List<E> value) {
        HashMap<String, BusinessEntity> result = new HashMap<String, BusinessEntity>();
        for (BusinessEntity v : value) {
            result.put(v.getWikittyId(), v);
        }
        return result;
    }

    public VradiConfig getVradiConfig() {
        return (VradiConfig)((Object)this.getContextValue(VradiConfig.class));
    }

    public DecoratorProvider getDecoratorProvider() {
        return (DecoratorProvider)this.getContextValue(DecoratorProvider.class);
    }

    public DecoratorProviderListCellRenderer getDecoratorProviderListCellRenderer() {
        return (DecoratorProviderListCellRenderer)this.getContextValue(DecoratorProviderListCellRenderer.class);
    }

    public static <T> void addIfNecessary(JAXXContextEntryDef<List<T>> entryDef, T o) {
        List values = (List)entryDef.getContextValue((JAXXContext)VradiContext.get());
        if (!values.contains(o)) {
            values.add(o);
            entryDef.setContextValue((JAXXContext)VradiContext.get(), new ArrayList(values));
        }
    }

    public static void initThesaurusDef() throws VradiException {
        TreeNodeImpl rootThesaurus;
        VradiStorageService service = VradiService.getVradiStorageService();
        try {
            ArrayList<TreeNodeImpl> thesaurusList = new ArrayList<TreeNodeImpl>(service.getAllThesaurus());
            rootThesaurus = service.getRootThesaurus();
            VradiContext.setRootTreeNodeEntryDef(rootThesaurus);
            VradiContext.setTreeNodeEntryDef(thesaurusList);
        }
        catch (VradiException eee) {
            log.error((Object)eee.getMessage(), (Throwable)eee);
            throw eee;
        }
        VradiThesaurusDTO vradiThesaurusDTO = new VradiThesaurusDTO();
        vradiThesaurusDTO.fromWikitty(rootThesaurus);
        VradiContext.loadAllChildrenThesaurus(vradiThesaurusDTO);
        VradiContext.setThesaurusEntryDef(vradiThesaurusDTO);
    }

    protected static void loadAllChildrenThesaurus(VradiThesaurusDTO thesaurusDTO) {
        VradiStorageService service = VradiService.getVradiStorageService();
        try {
            int nbForms = service.getNbFormsForThesaurus(thesaurusDTO.getWikittyId());
            thesaurusDTO.setFormsForThesaurus(nbForms);
            List childrenTreeNode = service.getChildrenThesaurus(thesaurusDTO.getWikittyId());
            if (childrenTreeNode != null) {
                for (TreeNodeImpl child : childrenTreeNode) {
                    VradiThesaurusDTO childThesaurus = new VradiThesaurusDTO();
                    childThesaurus.fromWikitty(child);
                    childThesaurus.setParentThesaurus(thesaurusDTO);
                    thesaurusDTO.addChild(childThesaurus);
                    VradiContext.loadAllChildrenThesaurus(childThesaurus);
                }
            }
        }
        catch (VradiException eee) {
            log.error((Object)"Cant find thesaurus ", (Throwable)eee);
        }
    }

    public static void initEntryDef() {
        VradiStorageService service = VradiService.getVradiStorageService();
        try {
            List allFormTypes = service.getAllFormTypes();
            Collections.sort(allFormTypes, VradiComparators.EXTENSION_COMPARATOR);
            List allStatuses = service.getAllStatuses();
            Collections.sort(allStatuses, VradiComparators.STATUSES_COMPARATOR);
            List allGroups = service.getAllGroups();
            Collections.sort(allGroups, VradiComparators.GROUP_COMPARATOR);
            List clients = service.getAllClients();
            Collections.sort(clients, VradiComparators.CLIENT_COMPARATOR);
            List xmlStreams = service.getAllXmlStreams();
            Collections.sort(xmlStreams, VradiComparators.XML_STREAM_COMPARATOR);
            List users = service.getAllUsers();
            Collections.sort(users, VradiComparators.USER_COMPARATOR);
            VradiContext.setFormsTypeEntryDef(allFormTypes);
            VradiContext.setStatusEntryDef(allStatuses);
            VradiContext.setGroupsEntryDef(allGroups);
            VradiContext.setClientsEntryDef(clients);
            VradiContext.setXmlStreamEntryDef(xmlStreams);
            VradiContext.setUsersEntryDef(users);
            VradiContext.initThesaurusDef();
        }
        catch (VradiException ex) {
            log.error((Object)ex);
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
    }

    public static void replace(BusinessEntity entity) {
        if (entity instanceof Client) {
            VradiContext.updateClient((Client)entity, true);
        } else if (entity instanceof User) {
            VradiContext.updateUser((User)entity, true);
        } else if (entity instanceof Group) {
            VradiContext.updateGroup((Group)entity, true);
        } else if (entity instanceof XmlStream) {
            VradiContext.updateXmlStream((XmlStream)entity, true);
        }
    }

    public static void remove(BusinessEntity entity) {
        if (entity instanceof Client) {
            VradiContext.updateClient((Client)entity, false);
        } else if (entity instanceof User) {
            VradiContext.updateUser((User)entity, false);
        } else if (entity instanceof Group) {
            VradiContext.updateGroup((Group)entity, false);
        } else if (entity instanceof XmlStream) {
            VradiContext.updateXmlStream((XmlStream)entity, false);
        }
    }

    static void updateClient(Client client, boolean replace) {
        List<Client> clients = VradiContext.getClientsInEntryDef();
        ListIterator<Client> listIterator = clients.listIterator();
        while (listIterator.hasNext()) {
            Client item = listIterator.next();
            if (!item.getWikittyId().equals(client.getWikittyId())) continue;
            listIterator.remove();
            break;
        }
        if (replace) {
            clients.add(client);
        }
        VradiContext.setClientsEntryDef(clients);
    }

    static void updateUser(User user, boolean replace) {
        List<User> users = VradiContext.getUsersInEntryDef();
        ListIterator<User> listIterator = users.listIterator();
        while (listIterator.hasNext()) {
            User item = listIterator.next();
            if (!item.getWikittyId().equals(user.getWikittyId())) continue;
            listIterator.remove();
            break;
        }
        if (replace) {
            users.add(user);
        }
        VradiContext.setUsersEntryDef(users);
    }

    static void updateGroup(Group group, boolean replace) {
        List<Group> groups = VradiContext.getGroupsInEntryDef();
        ListIterator<Group> listIterator = groups.listIterator();
        while (listIterator.hasNext()) {
            Group item = listIterator.next();
            if (!item.getWikittyId().equals(group.getWikittyId())) continue;
            listIterator.remove();
            break;
        }
        if (replace) {
            groups.add(group);
        }
        VradiContext.setGroupsEntryDef(groups);
    }

    static void updateXmlStream(XmlStream xmlStream, boolean replace) {
        List<XmlStream> streams = VradiContext.getXmlStreamInEntryDef();
        ListIterator<XmlStream> listIterator = streams.listIterator();
        while (listIterator.hasNext()) {
            XmlStream item = listIterator.next();
            if (!item.getWikittyId().equals(xmlStream.getWikittyId())) continue;
            listIterator.remove();
            break;
        }
        if (replace) {
            streams.add(xmlStream);
        }
        VradiContext.setXmlStreamEntryDef(streams);
    }
}

