/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.InfogeneImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.WikittyExtension;

public class OfferListColumnFactory
extends ColumnFactory {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(OfferListColumnFactory.class);
    private static final String I18N_COLUMN_PREFIX = "vradi.offer.";
    private final List<TableColumnExt> columnExts = new ArrayList<TableColumnExt>();

    public OfferListColumnFactory() {
        this.initAvailableColumns();
    }

    public TableColumnExt createTableColumn(int modelIndex) {
        TableColumnExt columnExt = new TableColumnExt(this.columnExts.get(modelIndex));
        return columnExt;
    }

    public void packColumn(JXTable table, TableColumnExt columnExt, int margin, int max) {
        int preferredWidth = columnExt.getPreferredWidth();
        if (preferredWidth < 400) {
            super.packColumn(table, columnExt, margin, 400);
        }
    }

    protected void initAvailableColumns() {
        WikittyExtension extension = InfogeneImpl.extensionInfogene;
        List<String> vradiListColumns = VradiHelper.getVradiListColumns();
        boolean empty = vradiListColumns.isEmpty();
        List fieldNames = extension.getFieldNames();
        for (String fieldName : fieldNames) {
            String fqField = extension.getName() + "." + fieldName;
            boolean visible = vradiListColumns.contains(fqField);
            visible = visible || empty;
            TableColumnExt columnExt = this.initAvailableColumn(fqField, this.columnExts.size(), visible);
            this.columnExts.add(columnExt);
            if (!empty) continue;
            if (fieldName.equals("id") || fieldName.equals("description")) {
                columnExt.setVisible(false);
                continue;
            }
            VradiHelper.addVradiListColumns(fqField);
        }
    }

    private TableColumnExt initAvailableColumn(String fqField, int modelIndex, boolean visible) {
        TableColumnExt tableColumnExt = new TableColumnExt(modelIndex);
        tableColumnExt.setIdentifier((Object)fqField);
        tableColumnExt.putClientProperty((Object)"fqFieldName", (Object)fqField);
        tableColumnExt.setEditable(false);
        tableColumnExt.setSortable(true);
        tableColumnExt.setVisible(visible);
        tableColumnExt.setToolTipText(I18n._((String)(I18N_COLUMN_PREFIX + fqField)));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("adding column: %s; position: %s; visible: %s", fqField, modelIndex, visible));
        }
        return tableColumnExt;
    }
}

