/* *##%
 * Copyright (c) 2009 Sharengo, Guillaume Dufrene, Benjamin POUSSIN.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public interface WikittyService {

    /**
     * Use {@link Criteria.ALL_ELEMENTS}
     */
    @Deprecated
	public static final int ALL_ELEMENTS = -1;

	/*
	 * Storage
	 */

	/**
	 * Manage Update and creation.
	 *
	 * @param wikitty contains an id all the time.
	 */
	UpdateResponse store(Wikitty wikitty);

	/**
	 * Manage Update and creation.
	 *
	 * @param wikitties list of wikitty to be persisted
	 */
	UpdateResponse store(Collection<Wikitty> wikitties);

	/**
	 * Manage Update and creation.
	 *
	 * @param wikitties list of wikitty to be persisted
	 * @param disableAutoVersionIncrement boolean to disable version increment
	 * 		on saved wikitty 
	 */
	UpdateResponse store(Collection<Wikitty> wikitties,
			boolean disableAutoVersionIncrement);

    /**
     * Return all extension id (ex: "extName[version])")
     * @return
     */
    List<String> getAllExtensionIds();

    /**
     * Return all extensions (ex: "extName[version])")
     * @param lastVersion if true, returns only the last version of each extension
     * @return
     */
    List<WikittyExtension> getAllExtensions(boolean lastVersion);

	/**
	 * Manage Update and creation.
	 *
	 * @param exts list of wikitty extension to be persisted
	 */
	UpdateResponse storeExtension(Collection<WikittyExtension> exts);

	/**
	 *
	 * @param id
	 * @return the corresponding object, exception if no such object found.
	 */
    public WikittyExtension restoreExtension(String id);

    /**
	 *
	 * @param id object id to restore
	 * @return the corresponding object, or null if object doesn't exist or is
     * deleted
	 */
	Wikitty restore( String id );

	/**
	 *
	 * @param id list of wikitty ids to restore
	 * @return list of corresponding wikitty, if one id is not valid (no object
     * or deleted) this id is skip and result list have less elements than
     * collection argument
	 */
	List<Wikitty> restore( List<String> id );

    /**
     * delete object if id exists
     * @param id object's id to remove
     */
    void delete(String id);

    /**
     * delete all object if id exists
     * @param ids object's ids to remove
     */
    void delete(Collection<String> ids);

	/**
	 *
	 * @param criteria
	 * @return
	 */
	public PagedResult<Wikitty> findAllByCriteria(Criteria criteria);

	/**
	 * Fist lonely (or first one) wikitty object that match criteria, if no wikitty found return null
	 * @param criteria
	 * @return
	 */
	public Wikitty findByCriteria(Criteria criteria);

	/*
	 * Labelisation
	 */

	/**
	 * add new lable to the wikitty object
     * @param wikittyId id of wikitty object to add label
     * @param label label to add
	 */
	void addLabel(String wikittyId, String label);

	/**
	 *
	 * @param label
	 * @return
	 */
	PagedResult<Wikitty> findAllByLabel(String label, int firstIndex, int endIndex);

	/**
	 *
	 * @param label
	 * @return
	 */
	Wikitty findByLabel(String label);

	/**
	 * retrieve all labels applied on a wikitty object
	 * @param wikittyId
	 * @return
	 */
	Set<String> findAllAppliedLabels(String wikittyId);


	/*
	 * Classification
	 * Most of classification purpose is handle by extension mechanisms
	 */

	/**
	 * Retrieve all wikitties children (recursively) of an other one
	 * Wikitty reference by wikittyId MUST include the 'Node' extension
	 *
	 * @param wikittyId
	 * @return
	 */
	Tree restoreTree(String wikittyId);

    /**
     * Retrieve wikitty node with count. Wikitty reference by wikittyId MUST
     * include the 'Node' extension
     * @param wikittyId
     * @return
     */
    Map.Entry<TreeNode, Integer> restoreNode(String wikittyId);

    /**
     * Retrieve all wikitties children with count (no recursively) of an other one
     * Wikitty reference by wikittyId MUST include the 'Node' extension
     *
     * @param wikittyId
     * @return
     */
    Map<TreeNode, Integer> restoreChildren(String wikittyId);


	/*
	 * history
	 */

	/**
	 *
	 */
	Wikitty restoreVersion(String wikittyId, String version);

    /*
     * admin
     */

    /**
     * Synchronise search engine with wikitty strorage engine, i.e. clear and
     * reindex all wikitties.
     * @return
     */
    UpdateResponse syncEngin();

	/*
	 * Import / Export
	 */


	/**
	 * synchonous or not ?
	 *
	 * @param xml data to import
	 */
    void syncImportFromXml(String xml);

	/**
	 *
	 * @param uri
	 */
    void syncImportFromUri(String uri);

	/**
	 *
	 * @param uri
	 * @return a jobID
	 */
	String asyncImportFromUri(String uri);

	/**
	 *
	 * @param criteria
	 * @return
	 */
	String asyncExportAllByCriteria(Criteria criteria);

	/**
	 *
	 * @param criteria
	 * @return
	 */
	String syncExportAllByCriteria(Criteria criteria);

	/*
	 * Job Management
	 */

	/**
	 *
	 * @param jobId
	 * @return
	 */
	JobState infoJob(String jobId);

	/**
	 *
	 * @param jobId
	 */
	void cancelJob(String jobId);

	/**
	 * delete job info and all resources associated to that job (files or other ...)
	 */
	void freeJobResource(String jobId);

    /**
     * Changes the data directory
     * @param newDataDir the new data directory path
     * @param oldDataDir the old data directory path.
     *          If null, the data in the old directory will not be copied.
     */
    public void changeDataDir(String newDataDir, String oldDataDir);

}
