/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * WikittySearchEngine is used to abstract search engin used in WikittyService.
 *
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public interface WikittySearchEngine {

    /**
     * Remove all data in index, no call to commit needed. This method commit
     * automaticaly.
     */
    public void clear();

    /**
     * Changes the data directory
     * @param newDataDir the new data directory path
     * @param oldDataDir the old data directory path.
     *          If null, the data in the old directory will not be copied.
     */
    public void changeDataDir(String newDataDir, String oldDataDir);

    /**
     * Prepare list of command needed to update indexation data. If command
     * creation is impossible this method must throw an Exception
     * @param wikitties
     * @return
     */
    public List<Command> prepare(WikittyTransaction transaction,
            Collection<Wikitty> wikitties);

    /**
     * Commit all modification command passed in argument
     * @param wikittyIndexationCommandList
     * @return information usefull for client side update data
     */
    public UpdateResponse commit(WikittyTransaction transaction,
            List<Command> wikittyIndexationCommandList);

    /**
     * Delete all object with id argument. If id is not valid or don't exist
     * throw an exception
     * @param idList
     * @return
     */
    public List<Command> delete(WikittyTransaction transaction,
            List<String> idList) throws WikittyException;

    /**
     * Delete all object with idList argument.
     * 
     * throw an exception
     * @param idList
     */
    public void delete(List<String> idList) throws WikittyException;

    public PagedResult<String> findAllByCriteria(Criteria criteria);

     /**
     * Find count of child for a node
     * @param w
     * @return
     */
    public Integer findNodeCount(Wikitty w);
    
    /**
     * Find all children ids with count for a node wikitty.
     * @param w
     * @return
     */
    public Map<String, Integer> findAllChildrenCount(Wikitty w);

    /**
     * Command update
     */
    static public interface Command {}
}
