/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.search;

import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.FilterListQueryHandler;
import com.jurismarches.vradi.services.search.LuceneQueryParser;
import com.jurismarches.vradi.services.search.QueryHandler;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.sharengo.wikitty.search.Search;

public class VradiQueryParser {
    private static final Log log = LogFactory.getLog(VradiQueryParser.class);
    public static final String DEFAULT_FIELD = "text";

    public static FilterList parse(String expression) throws UnsupportedQueryException {
        return VradiQueryParser.parse(expression, DEFAULT_FIELD);
    }

    public static FilterList parse(String expression, String defaultField) throws UnsupportedQueryException {
        FilterListQueryHandler queryHandler = new FilterListQueryHandler();
        VradiQueryParser.parse(queryHandler, expression, defaultField);
        FilterList filterList = queryHandler.getFilterList();
        return filterList;
    }

    static void parse(QueryHandler queryHandler, String expression, String defaultField) throws UnsupportedQueryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("expression: " + expression));
        }
        WhitespaceAnalyzer analyzer = new WhitespaceAnalyzer();
        QueryParser parser = new QueryParser(defaultField, (Analyzer)analyzer);
        parser.setAllowLeadingWildcard(true);
        parser.setDefaultOperator(QueryParser.Operator.AND);
        if (expression == null || expression.isEmpty()) {
            expression = defaultField + ":*";
        }
        try {
            Query query = parser.parse(expression);
            LuceneQueryParser luceneQueryParser = new LuceneQueryParser(queryHandler);
            luceneQueryParser.parse(query);
        }
        catch (ParseException e) {
            throw new UnsupportedQueryException(expression, e);
        }
    }

    public static Search search(String expression) throws UnsupportedQueryException {
        FilterList filterList = VradiQueryParser.parse(expression);
        Search search = Search.query();
        VradiQueryParser.buildSearch(filterList, search);
        return search;
    }

    public static void buildSearch(FilterList list, Search search) {
        Search subSearch = null;
        FilterList.Operator operator = list.getOperator();
        if (operator == FilterList.Operator.MUST_PASS_ONE) {
            subSearch = search.or();
        } else if (operator == FilterList.Operator.MUST_PASS_ALL) {
            subSearch = search.and();
        } else if (operator == FilterList.Operator.MUST_NOT_PASS) {
            subSearch = search.not();
        }
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                VradiQueryParser.buildSearch((FilterList)filter, subSearch);
                continue;
            }
            if (!(filter instanceof CompareFilter)) continue;
            CompareFilter compareFilter = (CompareFilter)filter;
            String name = compareFilter.getName();
            String value = compareFilter.getValue();
            subSearch.eq(name, value);
        }
    }
}

