/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import com.jurismarches.vradi.services.search.VradiQueryParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class SearchManager {
    private static final Log log = LogFactory.getLog(SearchManager.class);
    private final WikittyProxy proxy;
    private final ClientManager clientManager;
    private static final DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.FRANCE);
    private static final Pattern dateFormatPattern = Pattern.compile("^(3[01]|[12][0-9]|0[1-9])/(1[0-2]|0[1-9])/[0-9]{4}$");

    public SearchManager(WikittyProxy proxy, ClientManager clientManager) {
        this.proxy = proxy;
        this.clientManager = clientManager;
    }

    public SearchManager(ClientManager clientManager) {
        this.proxy = ServiceHelper.getWikittyProxy();
        this.clientManager = clientManager;
    }

    public void findForms(String query, VradiFormPageDTO formPageDTO) throws UnsupportedQueryException {
        this.findForms(query, null, null, null, null, null, formPageDTO);
    }

    public void findForms(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus, VradiFormPageDTO formPageDTO) throws UnsupportedQueryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("findForms(query:%s, extension:%s, dateType:%s, beginDate:%tc, endDate:%tc)", query, extension, dateType, beginDate, endDate));
        }
        FilterList filter = VradiQueryParser.parse(query);
        Search search = Search.query();
        SearchManager.buildSearch(filter, search);
        if (extension != null) {
            search.eq(Element.ELT_EXTENSION, extension.getName());
        }
        if (dateType != null && beginDate != null && endDate != null) {
            String beginString = WikittyUtil.solrDateFormat.format(beginDate);
            String endString = WikittyUtil.solrDateFormat.format(endDate);
            search.bw(dateType, beginString, endString);
        }
        if (thesaurus != null) {
            for (int i = 0; i < thesaurus.length; ++i) {
                if (thesaurus[i] == null) continue;
                Search subSearch = search.or();
                for (String th : thesaurus[i]) {
                    subSearch.eq("Form.thesaurus", th);
                }
            }
        }
        Criteria criteria = search.criteria();
        int firstIndex = (formPageDTO.getPageToShow() - 1) * formPageDTO.getNbFormsToShow();
        int lastIndex = formPageDTO.getPageToShow() * formPageDTO.getNbFormsToShow() - 1;
        if (firstIndex >= 0 && lastIndex > 0 && lastIndex > firstIndex) {
            criteria.setFirstIndex(firstIndex).setEndIndex(lastIndex);
        }
        if (formPageDTO.getFieldToSort() != null) {
            if (!formPageDTO.isAscending()) {
                criteria.addSortDescending(formPageDTO.getFieldToSort());
            } else {
                criteria.addSortAscending(formPageDTO.getFieldToSort());
            }
        }
        criteria.addSortAscending("Infogene.id");
        PagedResult queryResult = this.proxy.findAllByCriteria(Form.class, criteria);
        ArrayList<Form> result = new ArrayList<Form>(queryResult.getAll());
        if (log.isTraceEnabled()) {
            for (Form form : result) {
                log.trace((Object)("found: " + form.toString()));
            }
        }
        formPageDTO.setFormsToShow(result);
        formPageDTO.setTotalFoundFormNb(queryResult.getNumFound());
    }

    public List<String> getQueriesReturningForm(Form form) throws TechnicalException {
        ArrayList<String> queries = new ArrayList<String>();
        ArrayList<String> allQueries = new ArrayList<String>();
        ArrayList<Object> queryMakers = new ArrayList<Object>();
        queryMakers.addAll(this.clientManager.getAllClients());
        queryMakers.addAll(this.clientManager.getAllGroups());
        queryMakers.addAll(this.clientManager.getAllUsers());
        for (QueryMaker queryMaker : queryMakers) {
            if (queryMaker.getQueries() == null) continue;
            for (String query : queryMaker.getQueries()) {
                if (allQueries.contains(query)) continue;
                allQueries.add(query);
            }
        }
        for (String string : allQueries) {
            try {
                FilterList filter = VradiQueryParser.parse(string);
                Search search = Search.query();
                search.eq("Infogene.id", form.getWikittyId());
                SearchManager.buildSearch(filter, search);
                Criteria criteria = search.criteria();
                PagedResult forms = this.proxy.findAllByCriteria(Form.class, criteria);
                if (forms.getNumFound() <= 0) continue;
                queries.add(string);
            }
            catch (UnsupportedQueryException e) {
                log.warn((Object)"it seems that a persisted query is not supported anymore", (Throwable)e);
            }
        }
        return queries;
    }

    static void buildSearch(FilterList list, Search search) {
        Search subSearch = null;
        FilterList.Operator operator = list.getOperator();
        if (operator == FilterList.Operator.MUST_PASS_ONE) {
            subSearch = search.or();
        } else if (operator == FilterList.Operator.MUST_PASS_ALL) {
            subSearch = search.and();
        } else if (operator == FilterList.Operator.MUST_NOT_PASS) {
            subSearch = search.not();
        }
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                SearchManager.buildSearch((FilterList)filter, subSearch);
                continue;
            }
            if (!(filter instanceof CompareFilter)) continue;
            SearchManager.buildSearch(operator, (CompareFilter)filter, subSearch);
        }
    }

    static void buildSearch(FilterList.Operator operator, CompareFilter compareFilter, Search search) {
        String name = compareFilter.getName();
        String value = compareFilter.getValue();
        if ("text".equals(name)) {
            search.keyword(value);
            return;
        }
        Search subSearch = search.or();
        if (operator == FilterList.Operator.MUST_NOT_PASS) {
            Matcher matcher = dateFormatPattern.matcher(value);
            if (matcher.matches()) {
                try {
                    Date time = dateFormat.parse(value);
                    String timeString = WikittyUtil.solrDateFormat.format(time.getTime());
                    subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.DATE, timeString);
                }
                catch (ParseException e) {
                    log.warn((Object)(value + " cannot be a date."));
                }
            }
        } else {
            Matcher matcher = dateFormatPattern.matcher(value);
            if (matcher.matches()) {
                try {
                    Date time = dateFormat.parse(value);
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(time);
                    GregorianCalendar beginCal = new GregorianCalendar();
                    beginCal.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                    GregorianCalendar endCal = new GregorianCalendar();
                    endCal.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                    ((Calendar)endCal).add(5, 1);
                    String beginString = WikittyUtil.solrDateFormat.format(beginCal.getTime());
                    String endString = WikittyUtil.solrDateFormat.format(endCal.getTime());
                    subSearch.bw(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.DATE, beginString, endString);
                }
                catch (ParseException e) {
                    log.warn((Object)(value + " cannot be a date."));
                }
            }
        }
        subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.TEXT, value);
        subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.STRING, value);
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.BOOLEAN, value);
        }
        if (NumberUtils.isNumber((String)value)) {
            subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + name + Criteria.SEPARATOR + Element.ElementType.NUMERIC, value);
        }
    }
}

