/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.entities.SendingStatus;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientEmailContentTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ClientEmailContentTableModel.class);
    protected Map<VradiSendingDTO, List<VradiFormDTO>> data = new LinkedHashMap<VradiSendingDTO, List<VradiFormDTO>>();
    protected boolean valueIsAdjusting;

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getData().get(rowIndex).getStatus() == SendingStatus.TO_SEND.getStatus() && (columnIndex == 2 || columnIndex == 3 || columnIndex == 5);
    }

    public void clear() {
        this.data.clear();
        if (!this.valueIsAdjusting) {
            this.fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public List<VradiSendingDTO> getData() {
        return new ArrayList<VradiSendingDTO>(this.data.keySet());
    }

    public List<VradiFormDTO> getFormsToExclude(VradiSendingDTO sending) {
        return new ArrayList<VradiFormDTO>((Collection)this.data.get(sending));
    }

    public void setFormsToExclude(VradiSendingDTO sending, List<VradiFormDTO> formsToSend) {
        this.data.put(sending, formsToSend);
    }

    public void addEntry(VradiSendingDTO formsByClientDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding client " + formsByClientDTO.getClientDTO().getName()));
        }
        this.data.put(formsByClientDTO, new ArrayList());
        if (this.isValueIsAdjusting()) {
            int newIndex = this.data.size() - 1;
            this.fireTableRowsInserted(newIndex, newIndex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        VradiSendingDTO value = new ArrayList<VradiSendingDTO>(this.data.keySet()).get(rowIndex);
        List<VradiFormDTO> result = null;
        switch (columnIndex) {
            case 0: {
                result = value.getSentDate();
                break;
            }
            case 1: {
                result = value.getClientDTO();
                break;
            }
            case 2: {
                result = this.data.get(value);
                break;
            }
            case 3: {
                result = value.getParagraph();
                break;
            }
            case 4: {
                result = SendingStatus.get(value.getStatus());
                break;
            }
            case 5: {
                result = value.getReceptionProof();
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        VradiSendingDTO value = new ArrayList<VradiSendingDTO>(this.data.keySet()).get(rowIndex);
        if (aValue != null) {
            switch (columnIndex) {
                case 0: {
                    value.setSentDate((Date)aValue);
                }
                case 1: {
                    value.setClientDTO((VradiClientDTO)aValue);
                    break;
                }
                case 2: {
                    this.data.get(value).clear();
                    for (Object o : (Object[])aValue) {
                        this.data.get(value).add((VradiFormDTO)o);
                    }
                    break;
                }
                case 3: {
                    value.setParagraph((String)aValue);
                    break;
                }
                case 4: {
                    value.setStatus(((Integer)aValue).intValue());
                    break;
                }
                case 5: {
                    value.setReceptionProof(((Boolean)aValue).booleanValue());
                }
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Date.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return List.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Boolean.TYPE;
            }
        }
        return String.class;
    }

    protected void ensureRowIndex(int rowIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("rowIndex (" + rowIndex + ") can not be greater than " + this.getRowCount());
        }
    }

    protected void ensureColumnIndex(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("columnIndex (" + columnIndex + ") can not be greater than " + this.getColumnCount());
        }
    }
}

