/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.RequestFormViewHandler;
import com.jurismarches.vradi.ui.RequestFormViewUI;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.editors.CurrencyEditor;
import com.jurismarches.vradi.ui.editors.DateEditor;
import com.jurismarches.vradi.ui.editors.DateTimeEditor;
import com.jurismarches.vradi.ui.editors.EmailEditor;
import com.jurismarches.vradi.ui.editors.NumEditor;
import com.jurismarches.vradi.ui.editors.StringEditor;
import com.jurismarches.vradi.ui.editors.TextEditor;
import com.jurismarches.vradi.ui.editors.UrlEditor;
import com.jurismarches.vradi.ui.editors.VradiEditor;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class OfferEditHandler {
    private static final Log log = LogFactory.getLog(OfferEditHandler.class);
    private static final String DEFAULT_EDITOR_NAME = "$default";
    public static final String REQUIRED_FIELD_CONTEXT = "required";
    protected static Map<String, Class<? extends VradiEditor<?, ?>>> editorMapping;

    public OfferEditUI initUI(JAXXContext rootContext, Form data) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        context.add((Object)data);
        UIHelper.getHandler((JAXXContext)context, ThesaurusHandler.class);
        OfferEditUI ui = new OfferEditUI((JAXXContext)context);
        this.fillfields(ui, data);
        ArrayList editUIs = (ArrayList)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (editUIs == null) {
            editUIs = new ArrayList();
            VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), editUIs);
        }
        ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).add(ui);
        this.initThesaurus((JAXXContext)context, ui);
        try {
            List thesaurusToPropose = ServiceHelper.getVradiStorageService().proposeThesaurus(data, null);
            this.addPropositions((JAXXContext)ui, thesaurusToPropose.toArray(new TreeNode[thesaurusToPropose.size()]));
        }
        catch (TechnicalException eee) {
            log.error((Object)"Cant get propositions of thesaurus ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is " + ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).size() + " OfferEditUI in referenciel"));
        }
        return ui;
    }

    public void initThesaurus(JAXXContext context, OfferEditUI ui) {
        JPanel thesaurusPanel = ui.getThesaurus();
        thesaurusPanel.removeAll();
        ThesaurusHandler thesaurusHandler = UIHelper.getHandler(context, ThesaurusHandler.class);
        List<String> thesaurusId = VradiHelper.getVradiListThesaurus();
        VradiThesaurusDTO rootThesaurus = (VradiThesaurusDTO)VradiContext.THESAURUS_ENTRY_DEF.getContextValue(context);
        thesaurusPanel.add((Component)((Object)thesaurusHandler.initUI(context, rootThesaurus, ui.getData(), false)));
        ArrayList<VradiThesaurusDTO> thesaurusSaved = new ArrayList<VradiThesaurusDTO>();
        if (thesaurusId != null) {
            for (String id : thesaurusId) {
                VradiThesaurusDTO savedThesaurus = rootThesaurus.findThesaurus(id);
                if (savedThesaurus == null) continue;
                thesaurusSaved.add(savedThesaurus);
            }
        }
        for (VradiThesaurusDTO saved : thesaurusSaved) {
            thesaurusPanel.add((Component)((Object)thesaurusHandler.initUI(context, saved, ui.getData(), true)));
        }
    }

    protected void fillfields(OfferEditUI ui, Form data) {
        Collection extensions = data.getExtensions();
        for (WikittyExtension extension : extensions) {
            if (extension.equals((Object)ModificationTag.MODIFICATION_TAG) || extension.getName().equals("Infogene") || extension.getName().equals("Form")) continue;
            List fieldNames = extension.getFieldNames();
            for (String fieldName : fieldNames) {
                this.createField(ui, extension, fieldName, data);
            }
        }
    }

    protected void createField(OfferEditUI ui, WikittyExtension extension, String fieldName, BusinessEntity data) {
        VradiEditor editor;
        JPanel content = ui.getContent();
        FieldType fieldType = extension.getFieldType(fieldName);
        if (!fieldType.isCollection() && (editor = this.getEditor(fieldType, (JAXXContext)ui)) != null) {
            String extensionName = extension.getName();
            Object value = data.getField(extensionName, fieldName);
            editor.setFieldName(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
            editor.setFieldDescription(fieldDesc);
            editor.setExtensionName(extensionName);
            editor.setExtensionFieldName(fieldName);
            editor.setValue(value);
            if (fieldType.isNotNull()) {
                editor.setValidatorContext(REQUIRED_FIELD_CONTEXT);
            }
            content.add((Component)((Object)editor));
        }
    }

    OfferEditUI getUI(JAXXContext context) {
        if (context instanceof OfferEditUI) {
            return (OfferEditUI)context;
        }
        return null;
    }

    public void openRequestPopup(JAXXContext context, List<String> queries) {
        RequestFormViewHandler handler = UIHelper.getHandler(context, RequestFormViewHandler.class);
        RequestFormViewUI ui = handler.initUI(context);
        for (String query : queries) {
            ui.getContent().add((Component)new JLabel(query));
        }
        ui.setVisible(true);
    }

    protected void addPropositions(JAXXContext context, TreeNode[] props) {
        OfferEditUI ui = this.getUI(context);
        DefaultListModel propositionListModel = ui.propositionListModel;
        propositionListModel.removeAllElements();
        for (TreeNode p : props) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add proposition element : " + p));
            }
            VradiThesaurusDTO thesaurus = UIHelper.getHandler(context, ThesaurusHandler.class).findThesaurusInRef(context, p.getWikittyId());
            propositionListModel.addElement(thesaurus);
        }
    }

    protected void save(JAXXContext context, Form form) {
        log.info((Object)("Saving Form: " + form.getObjet()));
        try {
            VradiUser vradiUser;
            Component[] components;
            Set<String> listThesaurus = form.getThesaurus();
            ThesaurusHandler thesaurusHandler = UIHelper.getHandler(context, ThesaurusHandler.class);
            if (listThesaurus != null) {
                for (String id : listThesaurus) {
                    VradiThesaurusDTO thesaurus = thesaurusHandler.findThesaurusInRef(context, id);
                    thesaurus.decFormsForThesaurus();
                }
            }
            form.clearThesaurus();
            for (Object s : this.getUI(context).getPropositionList().getSelectedValues()) {
                VradiThesaurusDTO selected = (VradiThesaurusDTO)s;
                form.addThesaurus(selected.getWikittyId());
                selected.incFormsForThesaurus();
            }
            for (Component c : this.getUI(context).getThesaurus().getComponents()) {
                Object[] selected;
                ThesaurusUI thesaurusUI = (ThesaurusUI)((Object)c);
                DefaultListModel model = thesaurusUI.getThesaurusSelectedModel();
                for (Object s : selected = model.toArray()) {
                    TreeNode treeNode = (TreeNode)s;
                    log.debug((Object)treeNode.getChildren());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("treeNode to save : " + treeNode.getName() + " in form : " + form.getObjet()));
                    }
                    form.addThesaurus(treeNode.getWikittyId());
                    VradiThesaurusDTO thesaurus = thesaurusHandler.findThesaurusInRef(context, treeNode.getWikittyId());
                    if (thesaurus == null) continue;
                    thesaurus.incFormsForThesaurus();
                }
            }
            OfferEditUI offerEditUI = this.getUI(context);
            JPanel content = offerEditUI.getContent();
            for (Component c : components = content.getComponents()) {
                VradiEditor editor = (VradiEditor)((Object)c);
                this.updateFormField(editor, form);
            }
            this.updateFormField(offerEditUI.getObjetEditor(), form);
            this.updateFormField(offerEditUI.getIdEditor(), form);
            this.updateFormField(offerEditUI.getSourceTextEditor(), form);
            this.updateFormField(offerEditUI.getSourceURLEditor(), form);
            this.updateFormField(offerEditUI.getEntityEditor(), form);
            this.updateFormField(offerEditUI.getCountryEditor(), form);
            this.updateFormField(offerEditUI.getDepartmentEditor(), form);
            this.updateFormField(offerEditUI.getDatePubEditor(), form);
            this.updateFormField(offerEditUI.getDatePeremeptionEditor(), form);
            this.updateFormField(offerEditUI.getDescriptionEditor(), form);
            if (!form.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
                form.addExtension(ModificationTag.MODIFICATION_TAG);
            }
            form.setField("ModificationTag", "lastModifier", (vradiUser = (VradiUser)context.getContextValue(VradiUser.class)) != null ? vradiUser.getName() : null);
            form.setField("ModificationTag", "lastModified", new Date());
            ServiceHelper.getVradiStorageService().updateForm(form);
        }
        catch (Exception eee) {
            log.error((Object)("Cant save form : " + form.getObjet()), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
    }

    void updateFormField(VradiEditor editor, Form form) {
        String extensionName = editor.getExtensionName();
        String extensionFieldName = editor.getExtensionFieldName();
        Object value = editor.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating: " + extensionName + "." + extensionFieldName + "=" + value));
        }
        form.setField(extensionName, extensionFieldName, value);
    }

    protected void update(JAXXContext context) {
        VradiMainUIHandler rootHandler = (VradiMainUIHandler)VradiContext.get().getContextValue(VradiMainUIHandler.class);
        rootHandler.goToHome(context);
    }

    protected void test(JAXXContext context, Form form) {
        ArrayList<String> queries = new ArrayList();
        try {
            queries = ServiceHelper.getVradiStorageService().getQueriesReturningForm(form);
        }
        catch (TechnicalException eee) {
            log.error((Object)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        this.openRequestPopup(context, queries);
    }

    protected void addFile(JAXXContext context) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.showOpenDialog(this.getUI(context));
        File file = fileChooser.getSelectedFile();
    }

    protected void removeFile(JAXXContext context) {
    }

    protected synchronized VradiEditor getEditor(FieldType type, JAXXContext context) {
        String editorName;
        if (editorMapping == null) {
            editorMapping = new TreeMap();
            editorMapping.put(FieldTypeEnum.STRING.name(), StringEditor.class);
            editorMapping.put(FieldTypeEnum.DATE_TIME.name(), DateTimeEditor.class);
            editorMapping.put(FieldTypeEnum.DATE.name(), DateEditor.class);
            editorMapping.put(FieldTypeEnum.EMAIL.name(), EmailEditor.class);
            editorMapping.put(FieldTypeEnum.NUMERIC.name(), NumEditor.class);
            editorMapping.put(FieldTypeEnum.TEXT.name(), TextEditor.class);
            editorMapping.put(FieldTypeEnum.URL.name(), UrlEditor.class);
            editorMapping.put(FieldTypeEnum.CURRENCY.name(), CurrencyEditor.class);
            editorMapping.put(DEFAULT_EDITOR_NAME, StringEditor.class);
        }
        FieldTypeEnum typeEnum = FieldTypeEnum.valueOf(type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("typeEnum of type " + type + " = " + (Object)((Object)typeEnum)));
        }
        String string = editorName = typeEnum == null ? DEFAULT_EDITOR_NAME : typeEnum.name();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor name for type [" + type.getType() + "] : " + editorName));
        }
        Class<VradiEditor<?, ?>> editorClass = editorMapping.get(editorName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor class to use : " + editorClass));
        }
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = editorClass.getConstructors()) {
                if (constructor.getParameterTypes() == null || constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].equals(JAXXContext.class)) continue;
                VradiEditor editor = (VradiEditor)((Object)constructor.newInstance(context));
                editor.init();
                return editor;
            }
            return null;
        }
        catch (InvocationTargetException eee) {
            throw new IllegalStateException(eee);
        }
        catch (InstantiationException eee) {
            throw new IllegalStateException(eee);
        }
        catch (IllegalAccessException eee) {
            throw new IllegalStateException(eee);
        }
    }

    public void changeStatusAndSave(JAXXContext context, Form form, Status status) {
        form.setStatus(status.getWikittyId());
        this.save(context, form);
    }
}

