/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiAction;
import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.models.ModifModel;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.ChangeLogHandler;
import com.jurismarches.vradi.ui.ChangeLogUI;
import com.jurismarches.vradi.ui.LoginHandler;
import com.jurismarches.vradi.ui.LoginUI;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ConverterUtil;
import org.nuiton.util.StringUtil;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class VradiMain {
    private static Log log = LogFactory.getLog(VradiMain.class);

    public static void main(String[] args) {
        long startingTime = System.nanoTime();
        log.info((Object)("Vradi start at " + new Date() + " args: " + Arrays.toString(args)));
        try {
            final VradiContext context = VradiMain.init(args);
            log.info((Object)I18n._((String)"vradi.init.context.done", (Object[])new Object[]{StringUtil.convertTime((long)startingTime, (long)System.nanoTime())}));
            SwingUtil.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)SwingUtil.newContextEntryDef(VradiConfig.class));
            SwingUtil.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)SwingUtil.newContextEntryDef(VradiAction.class));
            final VradiConfig config = (VradiConfig)((Object)context.getContextValue(VradiConfig.class));
            config.doAction(VradiConfig.Step.AfterInit.ordinal());
            if (config.isDisplayMainUI()) {
                LoginHandler handler = UIHelper.getHandler((JAXXContext)context, LoginHandler.class);
                final LoginUI loginUI = new LoginUI((JAXXContext)context);
                loginUI.addPropertyChangeListener("bean", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() != null) {
                            context.setContextValue((VradiUser)evt.getNewValue());
                            VradiMainUIHandler uiHandler = UIHelper.getHandler((JAXXContext)context, VradiMainUIHandler.class);
                            ChangeLogHandler changeLogHandler = UIHelper.getHandler((JAXXContext)context, ChangeLogHandler.class);
                            final VradiMainUI ui = uiHandler.initUI((JAXXContext)context, config.isFullScreen());
                            log.info((Object)I18n._((String)"vradi.init.ui.done"));
                            final ChangeLogUI clUi = new ChangeLogUI((JAXXContext)context);
                            clUi.getContent().setText(changeLogHandler.getChangeLog());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (clUi.getContent().getText().isEmpty()) {
                                        clUi.dispose();
                                    } else {
                                        clUi.pack();
                                        clUi.setVisible(true);
                                    }
                                    ui.setCursor(null);
                                    ui.setVisible(true);
                                }
                            });
                            loginUI.removePropertyChangeListener(this);
                            loginUI.dispose();
                        }
                    }
                });
                String login = config.getOption("login");
                String password = config.getOption("password");
                VradiUser vradiUser = null;
                if (StringUtils.isNotBlank((String)login) && StringUtils.isNotBlank((String)password)) {
                    vradiUser = handler.getVradiStorageService().logVradiUser(login, password);
                }
                if (vradiUser != null) {
                    loginUI.setBean(vradiUser);
                } else {
                    loginUI.setVisible(true);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
            System.exit(1);
        }
    }

    public static VradiContext init(String ... args) throws Exception {
        System.setSecurityManager(null);
        long t0 = System.nanoTime();
        I18n.setUniqueBundleName((String)"vradi-swing-i18n");
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        VradiContext context = VradiContext.init();
        DecoratorProvider p = new DecoratorProvider(){

            protected void loadDecorators() {
                this.registerMultiJXPathDecorator(Client.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(User.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Group.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Status.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(WikittyExtension.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(XmlStream.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(VradiThesaurusDTO.class, "${name}$s##${formsForThesaurus}$s", "##", " - ");
                this.registerMultiJXPathDecorator(TreeNode.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(ModifModel.Modif.class, "${msg}$s", "", "");
            }
        };
        context.setContextValue(p);
        context.setContextValue(new DecoratorProviderListCellRenderer(p));
        VradiConfig config = (VradiConfig)((Object)context.getContextValue(VradiConfig.class));
        config.parse(args);
        long t00 = System.nanoTime();
        I18n.init((Locale)config.getLocale());
        log.info((Object)("language : " + config.getLocale()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t00, (long)System.nanoTime())));
        }
        log.info((Object)I18n._((String)"vradi.message.config.loaded", (Object[])new Object[]{config.getVersion()}));
        try {
            UIManager.put("SplitPane.oneTouchButtonSize", 10);
            SwingUtil.initNimbusLoookAndFeel();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"vradi.warning.nimbus.landf"));
        }
        catch (Throwable e) {
            log.warn((Object)I18n._((String)"vradi.warning.no.ui"));
            config.setCanUseUI(false);
        }
        Converter converter = ConverterUtil.getConverter(Date.class);
        if (converter != null) {
            ConvertUtils.deregister(Date.class);
            DateConverter dateConverter = new DateConverter();
            dateConverter.setUseLocaleFormat(true);
            ConvertUtils.register((Converter)dateConverter, Date.class);
        }
        if (config.isCanUseUI()) {
            SwingUtil.loadUIConfig((String)"/vradi.properties", null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init done in " + StringUtil.convertTime((long)t0, (long)System.nanoTime())));
        }
        return context;
    }

    public static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("shutdown vradi");
        }

        @Override
        public void run() {
            try {
                super.run();
                VradiContext.get().close();
                log.info((Object)I18n._((String)"vradi.init.closed", (Object[])new Object[]{new Date()}));
                Runtime.getRuntime().halt(0);
            }
            catch (Exception ex) {
                log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

