/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.solr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.nuiton.util.FileUtil;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FacetTopic;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittySearchEngine;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;
import org.sharengo.wikitty.solr.Restriction2Solr;

public class WikittySearchEngineSolr
implements WikittySearchEngine {
    private static Log log = LogFactory.getLog(WikittySearchEngineSolr.class);
    protected static final String SOLR_ID = "id";
    public static final String SOLR_EXTENSIONS = "extensions";
    public static final String SOLR_ALL_EXTENSIONS = "all";
    public static final String SOLR_QUERY_PARSER = "{!wikitty}";
    public static final String TREENODE_PREFIX = "TreeNode.";
    public static final String TREENODE_CHILD = "TreeNode.wikittyId";
    public static final String TREENODE_EMPTY = "TreeNode.empty";
    public static final String TREENODE_ROOT = "TreeNode.root";
    public static final String TREENODE_PATH = "TreeNode.path";
    public static final String SOLRCONFIG = "solrconfig.xml";
    protected SolrServer solrServer;
    protected Restriction2Solr restriction2Solr;
    protected TypeFieldModifer fieldModifier;

    public WikittySearchEngineSolr(WikittyExtensionStorage extensionStorage) {
        this(extensionStorage, null);
    }

    public WikittySearchEngineSolr(WikittyExtensionStorage extensionStorage, String dataDir) {
        try {
            CoreContainer.Initializer initializer = new CoreContainer.Initializer();
            if (dataDir != null) {
                initializer.setSolrConfigFilename(dataDir + File.separator + SOLRCONFIG);
            }
            CoreContainer coreContainer = initializer.initialize();
            this.solrServer = new EmbeddedSolrServer(coreContainer, "");
            this.fieldModifier = new TypeFieldModifer(extensionStorage);
            this.restriction2Solr = new Restriction2Solr(this.fieldModifier);
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public void clear() {
        try {
            this.solrServer.deleteByQuery("*:*");
            this.solrServer.commit(true, true);
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public void changeDataDir(String newDataDir, String oldDataDir) {
        try {
            if (oldDataDir != null) {
                File newFile = new File(newDataDir);
                File oldFile = new File(oldDataDir);
                FileUtil.copyRecursively((File)oldFile, (File)newFile, (String[])new String[0]);
            }
            CoreContainer.Initializer initializer = new CoreContainer.Initializer();
            initializer.setSolrConfigFilename(newDataDir);
            CoreContainer coreContainer = initializer.initialize();
            this.solrServer = new EmbeddedSolrServer(coreContainer, "");
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public List<WikittySearchEngine.Command> prepare(WikittyTransaction transaction, Collection<Wikitty> wikitties) {
        ArrayList<WikittySearchEngine.Command> result = new ArrayList<WikittySearchEngine.Command>(wikitties.size());
        ReindexChildTreeNode reindexChildTreeNode = ReindexChildTreeNode.getReindexChildTreeNode(transaction);
        for (Wikitty w : wikitties) {
            if (w.hasExtension("TreeNode")) {
                Collection oldChildren;
                String treeNodeId;
                SolrDocument treeNodeDoc;
                Set children = w.getFieldAsSet("TreeNode", "children", String.class);
                if (children != null) {
                    reindexChildTreeNode.addAll(children);
                }
                if ((treeNodeDoc = this.findById(treeNodeId = w.getId())) != null && (oldChildren = treeNodeDoc.getFieldValues("TreeNode.children_s")) != null) {
                    reindexChildTreeNode.addAll(oldChildren);
                }
            }
            result.add(new CommandSolr(w));
        }
        return result;
    }

    public List<WikittySearchEngine.Command> delete(WikittyTransaction transaction, List<String> idList) throws WikittyException {
        ArrayList<WikittySearchEngine.Command> result = new ArrayList<WikittySearchEngine.Command>(idList.size());
        ReindexChildTreeNode reindexChildTreeNode = ReindexChildTreeNode.getReindexChildTreeNode(transaction);
        try {
            for (String id : idList) {
                SolrQuery query = new SolrQuery("{!wikitty}TreeNode." + id + ":*");
                QueryResponse response = this.solrServer.query((SolrParams)query);
                SolrDocumentList updateDocs = response.getResults();
                for (SolrDocument solrDocument : updateDocs) {
                    String childId = (String)solrDocument.getFieldValue(TREENODE_CHILD);
                    reindexChildTreeNode.add(childId);
                }
                result.add(new CommandSolr(id));
            }
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
        return result;
    }

    public void delete(List<String> idList) throws WikittyException {
        try {
            for (String id : idList) {
                this.solrServer.deleteById(id);
            }
            this.solrServer.commit();
        }
        catch (Exception e) {
            throw new WikittyException(e);
        }
    }

    public UpdateResponse commit(WikittyTransaction transaction, List<WikittySearchEngine.Command> wikittyIndexationCommandList) {
        try {
            for (WikittySearchEngine.Command c : wikittyIndexationCommandList) {
                CommandSolr cs = (CommandSolr)c;
                if (cs.toStore) {
                    SolrInputDocument doc = this.createIndexDocument(cs.wikitty);
                    this.solrServer.add(doc);
                    continue;
                }
                this.solrServer.deleteById(TREENODE_PREFIX + cs.id);
                this.solrServer.deleteById(cs.id);
            }
            this.solrServer.commit();
            ParentMap parentMap = ParentMap.getParentMap(this, transaction);
            ReindexChildTreeNode reindexChildTreeNode = ReindexChildTreeNode.getReindexChildTreeNode(transaction);
            for (String childId : reindexChildTreeNode) {
                SolrInputDocument doc = this.createTreeNodeDocument(parentMap, childId);
                this.solrServer.add(doc);
            }
            this.solrServer.commit();
            UpdateResponse result = new UpdateResponse();
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public PagedResult<String> findAllByCriteria(Criteria criteria) {
        try {
            String facetName;
            List sortDescending;
            String queryString = this.restriction2Solr.toSolr(criteria.getRestriction(), this.solrServer);
            SolrQuery query = new SolrQuery(SOLR_QUERY_PARSER + queryString);
            int firstIndex = criteria.getFirstIndex();
            int endIndex = criteria.getEndIndex();
            query.setStart(Integer.valueOf(firstIndex));
            int nbRows = endIndex == -1 ? Integer.MAX_VALUE - firstIndex : endIndex - firstIndex + 1;
            query.setRows(Integer.valueOf(nbRows));
            List sortAscending = criteria.getSortAscending();
            if (sortAscending != null) {
                for (String sort : sortAscending) {
                    String tranform = this.fieldModifier.convertToSolr(sort);
                    query.setSortField(tranform, SolrQuery.ORDER.asc);
                }
            }
            if ((sortDescending = criteria.getSortDescending()) != null) {
                for (String sort : sortDescending) {
                    String tranform = this.fieldModifier.convertToSolr(sort);
                    query.setSortField(tranform, SolrQuery.ORDER.desc);
                }
            }
            List facetField = criteria.getFacetField();
            log.debug((Object)("facetField : " + facetField));
            List facetCriteria = criteria.getFacetCriteria();
            HashMap<String, String> facetQueryToName = new HashMap<String, String>();
            if (facetField != null && !facetField.isEmpty() || facetCriteria != null && !facetCriteria.isEmpty()) {
                query.setFacet(true);
                query.setFacetMinCount(1);
                if (facetField != null) {
                    for (String fqfieldName : facetField) {
                        String tranform = this.fieldModifier.convertToSolr(fqfieldName);
                        query.addFacetField(new String[]{tranform});
                    }
                }
                if (facetCriteria != null) {
                    for (Criteria facet : facetCriteria) {
                        String queryFacet = this.restriction2Solr.toSolr(facet.getRestriction());
                        facetQueryToName.put(queryFacet, facet.getName());
                        query.addFacetQuery(queryFacet);
                    }
                }
            }
            QueryResponse resp = this.solrServer.query((SolrParams)query);
            SolrDocumentList solrResults = resp.getResults();
            HashMap facets = new HashMap();
            if (facetField != null && !facetField.isEmpty()) {
                for (FacetField facetField2 : resp.getFacetFields()) {
                    facetName = this.fieldModifier.convertToField(facetField2.getName());
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    if (facetField2.getValues() != null) {
                        for (FacetField.Count value : facetField2.getValues()) {
                            String topicName = value.getName();
                            if (topicName.endsWith(TREENODE_EMPTY)) continue;
                            int topicCount = (int)value.getCount();
                            FacetTopic topic = new FacetTopic(facetName, topicName, topicCount);
                            topics.add(topic);
                        }
                    }
                    facets.put(facetName, topics);
                }
            }
            if (facetCriteria != null && !facetCriteria.isEmpty()) {
                for (Map.Entry entry : resp.getFacetQuery().entrySet()) {
                    facetName = (String)entry.getKey();
                    if (null != facetQueryToName.get(facetName)) {
                        facetName = (String)facetQueryToName.get(facetName);
                    }
                    Integer count = (Integer)entry.getValue();
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    FacetTopic topic = new FacetTopic(facetName, facetName, count.intValue());
                    topics.add(topic);
                    facets.put(facetName, topics);
                }
            }
            ArrayList<String> ids = new ArrayList<String>(solrResults.size());
            for (SolrDocument doc : solrResults) {
                String id = (String)doc.getFieldValue(SOLR_ID);
                ids.add(id);
            }
            int n = (int)resp.getResults().getNumFound();
            PagedResult result = new PagedResult(firstIndex, n, queryString, facets, ids);
            return result;
        }
        catch (SolrServerException e) {
            throw new WikittyException((Exception)((Object)e));
        }
    }

    public Integer findNodeCount(Wikitty w) {
        String wikittyId = w.getId();
        String parent = w.getFieldAsWikitty("TreeNode", "parent");
        parent = parent == null ? TREENODE_ROOT : TREENODE_PREFIX + parent;
        Criteria criteria = Search.query().eq(parent, wikittyId).criteria().setFirstIndex(0).setEndIndex(0);
        PagedResult<String> search = this.findAllByCriteria(criteria);
        int numFound = search.getNumFound();
        return numFound;
    }

    public Map<String, Integer> findAllChildrenCount(Wikitty w) {
        String wikittyId = w.getId();
        String parent = w.getFieldAsWikitty("TreeNode", "parent");
        parent = parent == null ? TREENODE_ROOT : TREENODE_PREFIX + parent;
        Criteria criteria = Search.query().eq(parent, wikittyId).criteria().setFirstIndex(0).setEndIndex(0).addFacetField(TREENODE_PREFIX + wikittyId);
        PagedResult<String> search = this.findAllByCriteria(criteria);
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        List topics = search.getTopic(TREENODE_PREFIX + wikittyId);
        if (topics != null) {
            for (FacetTopic topic : topics) {
                String topicName = topic.getTopicName();
                int topicCount = topic.getCount();
                counts.put(topicName, topicCount);
            }
        }
        log.debug((Object)("Facet result " + counts));
        criteria = Search.query().eq("TreeNode.parent", wikittyId).criteria().setFirstIndex(0).setEndIndex(Criteria.ALL_ELEMENTS);
        search = this.findAllByCriteria(criteria);
        List children = search.getAll();
        for (String child : children) {
            if (counts.containsKey(child)) continue;
            counts.put(child, 0);
        }
        return counts;
    }

    protected SolrInputDocument createIndexDocument(Wikitty w) {
        log.debug((Object)("index wikitty " + w.getId()));
        SolrInputDocument doc = new SolrInputDocument();
        String id = w.getId();
        doc.addField(SOLR_ID, (Object)id);
        for (String name : w.getExtensionNames()) {
            doc.addField(SOLR_EXTENSIONS, (Object)name);
        }
        for (String fqfieldName : w.fieldNames()) {
            FieldType fieldType = w.getFieldType(fqfieldName);
            FieldType.TYPE type = fieldType.getType();
            String solrFqFieldName = WikittySearchEngineSolr.getSolrFieldName(fqfieldName, type);
            String[] solrFieldName = solrFqFieldName.split("\\.");
            String solrAllFieldName = "all." + solrFieldName[1];
            Object objectValue = w.getFqField(fqfieldName);
            if (objectValue == null) continue;
            if (fieldType.isCollection()) {
                Collection collectionValue = (Collection)objectValue;
                for (Object itemValue : collectionValue) {
                    if (itemValue == null) continue;
                    doc.addField(solrFqFieldName, itemValue);
                    doc.addField(solrAllFieldName, itemValue);
                    log.debug((Object)("index field " + solrFqFieldName + " with value '" + itemValue + "'"));
                }
                continue;
            }
            doc.addField(solrFqFieldName, objectValue);
            doc.addField(solrAllFieldName, objectValue);
            if (type == FieldType.TYPE.STRING) {
                doc.addField(solrFqFieldName + "_t", objectValue);
                doc.addField(solrAllFieldName + "_t", objectValue);
            }
            log.debug((Object)("index field " + solrFqFieldName + " with value '" + objectValue + "'"));
        }
        return doc;
    }

    public SolrInputDocument createTreeNodeDocument(ParentMap parentMap, String childId) throws IOException, SolrServerException {
        SolrInputDocument doc = new SolrInputDocument();
        doc.setField(SOLR_ID, (Object)(TREENODE_PREFIX + childId));
        doc.setField(TREENODE_CHILD, (Object)childId);
        SolrQuery query = new SolrQuery("{!wikitty}TreeNode.children_s:" + childId);
        QueryResponse response = this.solrServer.query((SolrParams)query);
        SolrDocumentList updateDocs = response.getResults();
        HashMap<String, String> paths = new HashMap<String, String>();
        for (SolrDocument solrDocument : updateDocs) {
            String parentPath;
            String treeNodeId = (String)solrDocument.getFieldValue(SOLR_ID);
            doc.addField(TREENODE_PREFIX + treeNodeId, (Object)TREENODE_EMPTY);
            String childParent = treeNodeId;
            String parent = parentMap.get(childParent);
            while (parent != null) {
                parentPath = (String)paths.get(childParent);
                if (parentPath == null) {
                    doc.addField(TREENODE_PREFIX + parent, (Object)childParent);
                    paths.put(childParent, parent);
                }
                childParent = parent;
                parent = parentMap.get(childParent);
            }
            parentPath = (String)paths.get(childParent);
            if (parentPath != null) continue;
            doc.addField(TREENODE_ROOT, (Object)childParent);
            paths.put(childParent, TREENODE_ROOT);
        }
        return doc;
    }

    protected SolrDocument findById(String id) {
        QueryResponse response;
        SolrQuery query = new SolrQuery("id:" + id);
        try {
            response = this.solrServer.query((SolrParams)query);
        }
        catch (SolrServerException eee) {
            throw new WikittyException((Exception)((Object)eee));
        }
        SolrDocumentList results = response.getResults();
        long numFound = results.getNumFound();
        if (numFound == 1L) {
            return (SolrDocument)results.get(0);
        }
        return null;
    }

    public static String getSolrFieldName(String fqfieldName, FieldType.TYPE type) {
        switch (type) {
            case BOOLEAN: {
                return fqfieldName + "_b";
            }
            case DATE: {
                return fqfieldName + "_dt";
            }
            case STRING: {
                return fqfieldName + "_s";
            }
            case NUMERIC: {
                return fqfieldName + "_d";
            }
        }
        return fqfieldName;
    }

    protected static class ParentMap
    extends HashMap<String, String> {
        protected WikittySearchEngineSolr searchEnginSolr;

        public ParentMap(WikittySearchEngineSolr searchEnginSolr) {
            this.searchEnginSolr = searchEnginSolr;
        }

        @Override
        public String get(Object key) {
            String id = String.valueOf(key);
            String parent = (String)super.get(id);
            if (parent == null) {
                SolrDocument doc = this.searchEnginSolr.findById(id);
                if (doc == null) {
                    return null;
                }
                parent = (String)doc.getFieldValue("TreeNode.parent");
                this.put(id, parent);
            }
            return parent;
        }

        public static ParentMap getParentMap(WikittySearchEngineSolr searchEnginSolr, WikittyTransaction transaction) {
            ParentMap value = (ParentMap)transaction.getTagValue(ParentMap.class);
            if (value == null) {
                value = new ParentMap(searchEnginSolr);
                transaction.setTagValue(ParentMap.class, (Object)value);
            }
            return value;
        }
    }

    protected static class ReindexChildTreeNode
    extends HashSet<String> {
        protected ReindexChildTreeNode() {
        }

        public static ReindexChildTreeNode getReindexChildTreeNode(WikittyTransaction transaction) {
            ReindexChildTreeNode value = (ReindexChildTreeNode)transaction.getTagValue(ReindexChildTreeNode.class);
            if (value == null) {
                value = new ReindexChildTreeNode();
                transaction.setTagValue(ReindexChildTreeNode.class, (Object)value);
            }
            return value;
        }
    }

    protected static class TypeFieldModifer
    implements FieldModifier {
        protected WikittyExtensionStorage extensionStorage;

        public TypeFieldModifer(WikittyExtensionStorage extensionStorage) {
            this.extensionStorage = extensionStorage;
        }

        @Override
        public String convertToSolr(String fqfieldname) {
            String result = fqfieldname;
            String[] searchField = fqfieldname.split("\\.");
            if (Element.ELT_EXTENSION.equals(fqfieldname)) {
                result = WikittySearchEngineSolr.SOLR_EXTENSIONS;
            } else if (Element.ELT_ID.equals(fqfieldname)) {
                result = WikittySearchEngineSolr.SOLR_ID;
            } else if (searchField.length >= 2) {
                WikittyExtension ext;
                FieldType fieldType;
                String extName = searchField[0];
                String fieldName = searchField[1];
                if (Criteria.ALL_EXTENSIONS.equals(extName)) {
                    fqfieldname = "all." + fieldName;
                    extName = WikittySearchEngineSolr.SOLR_ALL_EXTENSIONS;
                }
                if (searchField.length >= 3) {
                    String fieldNameType = searchField[2];
                    if (Element.ElementType.TEXT.name().equals(fieldNameType)) {
                        result = extName + "." + fieldName + "_s_t";
                    } else {
                        FieldType.TYPE type = FieldType.TYPE.valueOf((String)fieldNameType);
                        result = WikittySearchEngineSolr.getSolrFieldName(fqfieldname, type);
                    }
                    return result;
                }
                String version = this.extensionStorage.getLastVersion(extName);
                if (version != null && (fieldType = (ext = this.extensionStorage.restore(extName, version)).getFieldType(fieldName)) != null) {
                    FieldType.TYPE type = fieldType.getType();
                    result = WikittySearchEngineSolr.getSolrFieldName(fqfieldname, type);
                    return result;
                }
            }
            return result;
        }

        @Override
        public String convertToField(String solrName) {
            String fieldName = solrName.replaceAll("(_b$)|(_dt$)|(_s$)|(_s_t$)|(_d$)", "");
            if (WikittySearchEngineSolr.SOLR_EXTENSIONS.equals(fieldName)) {
                fieldName = Element.ELT_EXTENSION;
            }
            return fieldName;
        }
    }

    public static interface FieldModifier {
        public String convertToSolr(String var1);

        public String convertToField(String var1);
    }

    protected static class CommandSolr
    implements WikittySearchEngine.Command {
        boolean toStore;
        String id;
        Wikitty wikitty;

        public CommandSolr(Wikitty wikitty) {
            this.wikitty = wikitty;
            this.toStore = true;
        }

        public CommandSolr(String id) {
            this.id = id;
            this.toStore = false;
        }
    }
}

