/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListColumnFactory;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.VradiTabHeader;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.TableColumnExt;
import org.sharengo.exceptions.TechnicalException;

public class OfferListHandler {
    private static final Log log = LogFactory.getLog(OfferListHandler.class);
    public static final int TABPANEL_LABEL_MAX_CHAR_NB = 30;

    public OfferListUI initUI(JAXXContext rootContext, VradiMainUIHandler rootHandler) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        SearchHandler searchHandler = UIHelper.getHandler((JAXXContext)context, SearchHandler.class);
        OfferListTableModel offerListTableModel = new OfferListTableModel();
        OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
        context.add((Object)offerListTableModel);
        context.add((Object)offerListColumnFactory);
        OfferListUI ui = new OfferListUI((JAXXContext)context);
        JXTable listTable = ui.getListTable();
        listTable.getColumnModel().addColumnModelListener((TableColumnModelListener)this.getOfferListTableColumnModelListener());
        MouseListener offerListTableMouseListener = this.getOfferListTableMouseListener(ui);
        listTable.addMouseListener(offerListTableMouseListener);
        TableModelListener offerListTableModelListener = this.getOfferListTableModelListener(listTable);
        offerListTableModel.addTableModelListener(offerListTableModelListener);
        OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
        listTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)renderer);
        listTable.setDefaultRenderer(Date.class, (TableCellRenderer)renderer);
        listTable.setDefaultRenderer(Double.class, (TableCellRenderer)renderer);
        listTable.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
        SearchUI searchUI = searchHandler.initUI(rootContext, offerListTableModel);
        searchUI.setOfferListUI(true);
        ui.getSearchPanel().add((Component)((Object)searchUI), "Center");
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        return ui;
    }

    private TableModelListener getOfferListTableModelListener(final JXTable listTable) {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                listTable.packAll();
            }
        };
    }

    private TableColumnModelExtListener getOfferListTableColumnModelListener() {
        return new TableColumnModelExtListener(){

            public void columnPropertyChange(PropertyChangeEvent paramPropertyChangeEvent) {
                String propertyName = paramPropertyChangeEvent.getPropertyName();
                if ("visible".equals(propertyName)) {
                    Boolean visible;
                    TableColumnExt column = (TableColumnExt)paramPropertyChangeEvent.getSource();
                    String fqFieldName = (String)column.getClientProperty((Object)"fqFieldName");
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("clientprop: " + fqFieldName));
                        log.trace((Object)("identifier: " + column.getIdentifier()));
                    }
                    if ((visible = (Boolean)paramPropertyChangeEvent.getNewValue()).booleanValue()) {
                        VradiHelper.addVradiListColumns(fqFieldName);
                    } else {
                        VradiHelper.removeVradiListColumns(fqFieldName);
                    }
                }
            }

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    private MouseListener getOfferListTableMouseListener(final OfferListUI offerListUI) {
        return new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        offerListUI.setCursor(Cursor.getPredefinedCursor(3));
                        OfferListHandler.this.selectOffer((JAXXContext)offerListUI);
                    }
                    catch (Exception ee) {
                        log.error((Object)ee.getMessage(), (Throwable)ee);
                        ErrorDialogUI.showError((Exception)ee);
                    }
                    finally {
                        offerListUI.setCursor(null);
                    }
                }
            }
        };
    }

    public void addEditPane(JAXXContext context, final Form data) {
        final OfferListUI ui = this.getUI(context);
        ui.setDividerLocation(0);
        ui.setResizeWeight(0.0);
        ui.setDividerSize(12);
        JTabbedPane contentTabbedPane = ui.getEditTabs();
        String id = data.getWikittyId();
        if (contentTabbedPane.indexOfTab(id) < 0) {
            final OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
            final OfferEditUI editUi = handler.initUI(context, data);
            contentTabbedPane.add(id, editUi);
            final VradiTabHeader panel = new VradiTabHeader();
            if (data.getObjet() != null) {
                String panelLabel = data.getObjet().length() < 30 ? data.getObjet() : data.getObjet().substring(0, 30) + "...";
                panel.getLabel().setText(panelLabel);
            }
            panel.setId(id);
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(id), (Component)((Object)panel));
            panel.getCloseTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.closePane((JAXXContext)editUi, panel.getId());
                }
            });
            panel.getDetachTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.detachPane(e);
                }
            });
            List<Status> statuses = this.getAllStatuses();
            JPanel buttonPanel = editUi.getStatusButtonPanel();
            for (final Status status : statuses) {
                JButton statusButton = new JButton(status.getName());
                statusButton.setToolTipText(status.getDescription());
                if (status.getWikittyId().equals(data.getStatus())) {
                    Color newColor = new Color(110, 150, 200, statusButton.getBackground().getAlpha());
                    statusButton.setBackground(newColor);
                }
                statusButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        handler.changeStatusAndSave((JAXXContext)editUi, data, status);
                        OfferListHandler.this.closePane((JAXXContext)editUi, panel.getId());
                        SearchHandler handler2 = UIHelper.getHandler((JAXXContext)editUi, SearchHandler.class);
                        handler2.executeQuery((JAXXContext)ui);
                    }
                });
                buttonPanel.add(statusButton);
            }
            editUi.getAnnuler().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OfferListHandler.this.closePane((JAXXContext)editUi, panel.getId());
                }
            });
        }
        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(id));
    }

    public List<Status> getAllStatuses() {
        ArrayList<Status> statuses = new ArrayList();
        try {
            statuses = ServiceHelper.getVradiStorageService().getAllStatuses();
        }
        catch (TechnicalException eee) {
            log.error((Object)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        return statuses;
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        return (VradiTabHeader)((Object)button.getParent());
    }

    protected void closePane(JAXXContext context, String id) {
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        int index = contentTabbedPane.indexOfTab(id);
        if (index > -1) {
            contentTabbedPane.remove(index);
        }
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    private void removeEditPaneFromRef(OfferEditUI ui) {
        ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).remove(ui);
    }

    protected void detachPane(MouseEvent e) {
        VradiTabHeader mytab = this.getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        final OfferEditUI content = this.getOfferEdit(contentTabbedPane, id);
        final JFrame frame = new JFrame(name);
        content.getAnnuler().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)content, "Center");
        frame.setVisible(true);
        frame.setSize(new Dimension(800, 800));
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected OfferEditUI getOfferEdit(JTabbedPane contentTabbedPane, String id) {
        return (OfferEditUI)contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));
    }

    protected void closeDetachedPane(JFrame f, OfferEditUI ui) {
        f.dispose();
        this.removeEditPaneFromRef(ui);
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            this.addEditPane(context, data);
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1.0);
            ui.setDividerSize(0);
        }
    }

    OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI)context;
        }
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = this.getUI(context);
        return ui.getEditTabs();
    }

    JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context) {
        JXTable listTable = this.getUI((JAXXContext)context).listTable;
        OfferListTableModel tableModel = this.getUI(context).getOfferListTableModel();
        int selectedRow = listTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < tableModel.getRowCount()) {
            selectedRow = listTable.convertRowIndexToModel(selectedRow);
            VradiFormPageDTO formPageDTO = tableModel.getFormPageDTO();
            List formsToShow = formPageDTO.getFormsToShow();
            Form data = (Form)formsToShow.get(selectedRow);
            if (data != null) {
                log.info((Object)("Show Form: " + data.getObjet()));
                this.addEditPane(context, data);
            }
        }
    }
}

