/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class VradiHelper {
    private static final Log log = LogFactory.getLog(VradiHelper.class);
    public static final String QUERIES = "vradi.queries";
    public static final String XML_STREAMS = "vradi.xmlStreams";
    public static final String CRITERIAS = "vradi.criterias";
    public static final String THESAURUS = "vradi.thesaurus";
    public static final String COLUMNS = "vradi.columns";
    public static final String LAST_VERSION = "vradi.lastVersion";
    public static final String TYPE_DESCRIPTION = "description";
    public static final String TYPE_LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String TYPE_LAST_MODIFIED_TIME = "lastModifiedTime";
    public static final String TYPE_LAST_MODIFIED_BY = "lastModifiedBy";
    public static Properties userProperties = null;
    public static Properties querryProperties = null;
    private static Map<String, Status> statusCache = new HashMap<String, Status>();

    public static VradiConfig getVradiConfig() {
        return VradiContext.get().getVradiConfig();
    }

    protected static Properties getUserProperties() {
        if (userProperties == null) {
            userProperties = VradiHelper.getProperties(VradiHelper.getVradiConfig().getUserFile());
        }
        return userProperties;
    }

    protected static Properties getProperties(File propertyFile) {
        Properties properties;
        try {
            properties = new Properties();
            if (VradiHelper.getVradiConfig().getVersion().getVersion() != null && !VradiHelper.getVradiConfig().getVersion().getVersion().isEmpty()) {
                if (!propertyFile.exists()) {
                    propertyFile.createNewFile();
                }
                FileInputStream input = new FileInputStream(propertyFile);
                properties.load(input);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("could not get " + propertyFile.getName() + " caused by : " + ioe.getMessage(), ioe);
        }
        return properties;
    }

    protected static Properties store(Properties property, File file) {
        try {
            OutputStreamWriter fileOutputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1");
            property.store(fileOutputStream, "");
        }
        catch (IOException e) {
            log.error((Object)"Cant save request property caused by : ", (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        return property;
    }

    protected static void storeUserProperties(Properties properties) {
        File userFile = VradiHelper.getVradiConfig().getUserFile();
        if (userFile != null) {
            VradiHelper.store(properties, userFile);
        }
    }

    protected static List<String> getUserListOfStringFromProperties(String propertyName) {
        Properties properties = VradiHelper.getUserProperties();
        ArrayList<String> result = new ArrayList<String>();
        if (properties != null) {
            String resultNames = properties.getProperty(propertyName);
            if (resultNames != null) {
                for (String resultName : resultNames.split(",")) {
                    String utf8ResultName = null;
                    try {
                        utf8ResultName = new String(resultName.getBytes("ISO-8859-1"), "UTF-8");
                    }
                    catch (UnsupportedEncodingException eee) {
                        utf8ResultName = resultName;
                    }
                    result.add(utf8ResultName);
                }
            } else {
                log.warn((Object)("Cant find property : " + propertyName));
            }
        }
        return result;
    }

    protected static void storeUserListProperties(String propertyName, List<String> values) {
        Properties properties = VradiHelper.getUserProperties();
        if (properties != null) {
            StringBuffer store = new StringBuffer();
            for (String value : values) {
                store.append(value).append(",");
            }
            int length = store.length() - 1;
            if (length > 0) {
                store.deleteCharAt(length);
            }
            properties.setProperty(propertyName, store.toString());
            VradiHelper.storeUserProperties(properties);
        }
    }

    protected static void addToUserListProperties(String propertyName, String value) {
        VradiHelper.addToUserListProperties(propertyName, value, false);
    }

    protected static void addToUserListProperties(String propertyName, String value, boolean replace) {
        VradiHelper.addToUserListProperties(propertyName, value, replace, false, false);
    }

    protected static void addToUserListProperties(String propertyName, String value, boolean replace, boolean inverse, boolean uniqueValues) {
        ArrayList<String> result;
        List<Object> list = result = replace ? new ArrayList() : VradiHelper.getUserListOfStringFromProperties(propertyName);
        if (value != null) {
            String isoValue;
            try {
                isoValue = new String(value.getBytes("UTF-8"), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException eee) {
                isoValue = value;
            }
            if (uniqueValues && result.contains(isoValue)) {
                result.remove(isoValue);
                if (inverse) {
                    result.add(0, isoValue);
                } else {
                    result.add(isoValue);
                }
            } else if (inverse) {
                result.add(0, isoValue);
            } else {
                result.add(isoValue);
            }
        }
        VradiHelper.storeUserListProperties(propertyName, result);
    }

    protected static List<String> removeToUserListProperties(String propertyName, String value) {
        List<String> result = VradiHelper.getUserListOfStringFromProperties(propertyName);
        result.remove(value);
        VradiHelper.storeUserListProperties(propertyName, result);
        return result;
    }

    public static void addRequestToProperties(String request) {
        VradiHelper.addToUserListProperties(QUERIES, request, false, true, true);
    }

    public static List<String> loadRequests() {
        return VradiHelper.getUserListOfStringFromProperties(QUERIES);
    }

    public static void setLastItemOfXmlStream(String xmlStreamName, String value) {
        VradiHelper.addToUserListProperties("vradi.xmlStreams." + xmlStreamName, value, true);
    }

    public static String getLastItemOfXmlStream(String xmlStreamName) {
        List<String> prop = VradiHelper.getUserListOfStringFromProperties("vradi.xmlStreams." + xmlStreamName);
        if (!prop.isEmpty()) {
            return prop.get(0);
        }
        return null;
    }

    public static List<String> getVradiListCriteria() {
        return VradiHelper.getUserListOfStringFromProperties(CRITERIAS);
    }

    public static void removeVradiListCriteria(TreeNode value) {
        VradiHelper.removeToUserListProperties(CRITERIAS, value.getWikittyId());
    }

    public static void addVradiListCriteria(TreeNode value) {
        VradiHelper.addToUserListProperties(CRITERIAS, value.getWikittyId());
    }

    public static List<String> getVradiListThesaurus() {
        return VradiHelper.getUserListOfStringFromProperties(THESAURUS);
    }

    public static void removeVradiListThesaurus(TreeNode value) {
        VradiHelper.removeToUserListProperties(THESAURUS, value.getWikittyId());
    }

    public static void addVradiListThesaurus(TreeNode value) {
        VradiHelper.addToUserListProperties(THESAURUS, value.getWikittyId());
    }

    public static List<String> getVradiListColumns() {
        return VradiHelper.getUserListOfStringFromProperties(COLUMNS);
    }

    public static void removeVradiListColumns(String value) {
        VradiHelper.removeToUserListProperties(COLUMNS, value);
    }

    public static void addVradiListColumns(String value) {
        VradiHelper.addToUserListProperties(COLUMNS, value);
    }

    public static String getEntityName(Object o) {
        if (o == null) {
            return "";
        }
        PropertyDescriptor descriptor = null;
        try {
            descriptor = PropertyUtils.getPropertyDescriptor((Object)o, (String)"name");
            if (descriptor == null) {
                return "";
            }
            Method getter = descriptor.getReadMethod();
            Object invoke = null;
            invoke = getter.invoke(o, new Object[0]);
            if (invoke == null) {
                return "";
            }
            String result = (String)invoke;
            return result;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        return "";
    }

    public static FieldTypeEnum getFieldTypeEnum(FieldType type) {
        for (FieldTypeEnum typeEnum : FieldTypeEnum.values()) {
            if (!typeEnum.isType(type)) continue;
            return typeEnum;
        }
        return null;
    }

    public static ComboBoxModel getFormTypesModel() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(VradiHelper.getFormTypes());
        return model;
    }

    public static Object[] getFormTypes() {
        VradiStorageService vradiStorageService = ServiceHelper.getVradiStorageService();
        List formTypes = new ArrayList();
        try {
            formTypes = vradiStorageService.getAllFormTypes();
        }
        catch (TechnicalException eee) {
            ErrorDialogUI.showError((Exception)((Object)eee));
            log.error((Object)("Cant get form type : " + (Object)((Object)eee)));
        }
        Object[] result = new Object[formTypes.size() + 1];
        result[0] = null;
        for (int i = 0; i < formTypes.size(); ++i) {
            result[i + 1] = formTypes.get(i);
        }
        return result;
    }

    public static Status getStatus(String statusId) {
        if (statusId == null) {
            return null;
        }
        Status status = statusCache.get(statusId);
        if (status == null) {
            VradiStorageService vradiStorageService = ServiceHelper.getVradiStorageService();
            try {
                status = vradiStorageService.getStatus(statusId);
                statusCache.put(statusId, status);
            }
            catch (TechnicalException eee) {
                log.error((Object)("Cant get status : " + (Object)((Object)eee)));
            }
        }
        return status;
    }

    public static ListCellRenderer getStatusesRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                Status status = (Status)o;
                String statusName = status == null ? "" : status.getName();
                return super.getListCellRendererComponent((JList<?>)jList, statusName, i, b, b1);
            }
        };
    }

    public static Date getLastDayDate() {
        Date result = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(result);
        cal.roll(5, false);
        return cal.getTime();
    }

    public static Date getBeginMonthDate() {
        Date result = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(result);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static void executeQuery(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus, VradiFormPageDTO formPageDTO) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)query);
            }
            formPageDTO.setFormsToShow(null);
            formPageDTO.setTotalFoundFormNb(0);
            if (formPageDTO.getNbFormsToShow() == 0) {
                formPageDTO.setNbFormsToShow(10);
            }
            if (formPageDTO.getPageToShow() == 0) {
                formPageDTO.setPageToShow(1);
            }
            ServiceHelper.getVradiStorageService().findForms(query, extension, dateType, beginDate, endDate, (List[])thesaurus, formPageDTO);
            if (log.isDebugEnabled()) {
                log.debug((Object)(formPageDTO.getTotalFoundFormNb() + " forms found"));
                for (Form form : formPageDTO.getFormsToShow()) {
                    log.debug((Object)(form.getWikittyId() + " : " + form.getObjet()));
                }
            }
        }
        catch (TechnicalException eee) {
            log.error((Object)"Cant execute query : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
            formPageDTO = new VradiFormPageDTO();
        }
        catch (UnsupportedQueryException e) {
            log.error((Object)e.getMessage());
            ErrorDialogUI.showError((Exception)((Object)e));
            formPageDTO = new VradiFormPageDTO();
        }
    }

    public static String getFieldTypeDescription(FieldType fieldType) {
        return fieldType.getTagValue(TYPE_DESCRIPTION);
    }

    public static String getLastVersion() {
        Properties userProperties = VradiHelper.getUserProperties();
        return userProperties.getProperty(LAST_VERSION);
    }

    public static void setLastVersion(String lastVersion) {
        Properties userProperties = VradiHelper.getUserProperties();
        userProperties.setProperty(LAST_VERSION, lastVersion);
        VradiHelper.storeUserProperties(userProperties);
    }

    public static boolean isVersionNewer(String version) {
        if (VradiHelper.getLastVersion() == null) {
            return true;
        }
        String[] versionToken = version.split("\\.");
        String[] lastVersionToken = VradiHelper.getLastVersion().split("\\.");
        for (int i = 0; i < versionToken.length && i < lastVersionToken.length; ++i) {
            log.debug((Object)(versionToken[i] + " ? " + lastVersionToken[i]));
            if (Integer.valueOf(versionToken[i]) > Integer.valueOf(lastVersionToken[i])) {
                return true;
            }
            if (Integer.valueOf(versionToken[i]) >= Integer.valueOf(lastVersionToken[i])) continue;
            return false;
        }
        return false;
    }
}

