/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nFilter;
import org.nuiton.i18n.I18nLoader;
import org.nuiton.i18n.Language;
import org.nuiton.util.ConverterUtil;

public class I18n {
    private static Log log = LogFactory.getLog(I18n.class);
    public static final String ISO_8859_1_ENCONDING = "ISO-8859-1";
    public static final String UTF_8_ENCONDING = "UTF-8";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    static I18nLoader loader;
    protected static I18nFilter filter;
    protected static String recordFilePath;
    static URL[] extraURL;
    protected static String uniqueBundleName;

    public static void init() {
        I18n.init(null);
    }

    public static void init(Locale locale) {
        if (locale == null) {
            locale = I18n.newLocale(null, null);
        }
        I18n.getLoader().setLanguage(locale);
    }

    public static void init(String language, String country) {
        I18n.init(I18n.newLocale(language, country));
    }

    public static String _(String message) {
        if (loader == null || loader.getLanguage() == null) {
            return I18n.applyFilter(message);
        }
        return I18n.applyFilter(loader.getLanguage().translate(message));
    }

    public static String _(String message, Object ... args) {
        Language language;
        String result = message;
        Language language2 = language = loader == null ? null : loader.getLanguage();
        if (language != null) {
            result = language.translate(message);
        }
        try {
            return I18n.applyFilter(String.format(result, args));
        }
        catch (Exception eee) {
            try {
                return I18n.applyFilter(String.format(message, args));
            }
            catch (Exception zzz) {
                log.warn((Object)I18n._("lutinutil.error.i18n.untranslated.message", message), (Throwable)zzz);
                return I18n.applyFilter(message);
            }
        }
    }

    public static String n_(String message, Object ... args) {
        try {
            return String.format(message, args);
        }
        catch (Exception eee) {
            log.warn((Object)I18n._("lutinutil.error.i18n.unformated.message", message, Arrays.toString(args)), (Throwable)eee);
            return message;
        }
    }

    public static String n_(String message) {
        return message;
    }

    public static String getRecordFilePath() {
        return recordFilePath;
    }

    public static URL[] getExtraURL() {
        return extraURL == null ? new URL[]{} : extraURL;
    }

    public static String getUniqueBundleName() {
        return uniqueBundleName;
    }

    public static void setFilter(I18nFilter filter) {
        I18n.filter = filter;
    }

    public static void setRecordFilePath(String recordFilePath) {
        I18n.recordFilePath = recordFilePath;
    }

    public static void setExtraURL(URL[] extraURL) {
        I18n.extraURL = extraURL;
        I18nLoader.urls = null;
        I18n.close();
    }

    public static void setUniqueBundleName(String uniqueBundleName) {
        I18n.uniqueBundleName = uniqueBundleName;
        I18nLoader.urls = null;
        I18n.close();
    }

    public static void close() {
        if (loader != null) {
            loader.close();
            loader = null;
        }
    }

    protected static String applyFilter(String message) {
        if (I18n.getFilter() != null) {
            return I18n.getFilter().applyFilter(message);
        }
        return message;
    }

    protected static I18nFilter getFilter() {
        return filter;
    }

    public static synchronized I18nLoader getLoader() {
        if (loader == null) {
            loader = new I18nLoader(DEFAULT_LOCALE, uniqueBundleName);
        }
        return loader;
    }

    public static Locale[] parseLocales(String str) throws IllegalArgumentException {
        ArrayList<Locale> result = new ArrayList<Locale>();
        String[] bundlesToUse = str.split(",");
        int j = bundlesToUse.length;
        for (int i = 0; i < j; ++i) {
            String s = bundlesToUse[i].trim();
            try {
                Locale l = ConverterUtil.convert(Locale.class, s);
                result.add(l);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("bundle " + s + " is not a valid locale,e");
            }
        }
        return result.toArray(new Locale[result.size()]);
    }

    public static Locale newLocale(String str) {
        if (str == null) {
            return I18n.newLocale(null, null);
        }
        try {
            return ConverterUtil.convert(Locale.class, str);
        }
        catch (Exception e) {
            Logger.getLogger("org.nuiton.i18n.I18n").warning("could not load locale '" + str + " for reason : " + e.getMessage());
            return DEFAULT_LOCALE;
        }
    }

    public static Locale newLocale(String language, String country) {
        if (language == null) {
            language = System.getProperty("user.language", DEFAULT_LOCALE.getLanguage());
            country = System.getProperty("user.country", DEFAULT_LOCALE.getCountry());
        }
        return I18n.newLocale(language + (country == null ? "" : '_' + country));
    }
}

