/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.entities.Client;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.table.AbstractTableModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Le modèle du tableau pour afficher et éditer les bindings d'un flux XML.
 * <p/>
 * User: chemit
 * Date: 15 nov. 2009
 * Time: 16:56:08
 */
public class FormEmailContentTableModel extends AbstractTableModel {

    private static final long serialVersionUID = 1L;

    /**
     * Logger
     */
    static private final Log log = LogFactory
            .getLog(FormEmailContentTableModel.class);

    protected class FormEmailContent {
        protected String formName = null;
        protected Set<Client> clients = new HashSet<Client>();

    }

    /**
     * Liste des clients et formulaires à afficher
     */
    protected List<FormEmailContent> data;
    /**
     * Un drapeau pour bloquer le déclanchement des fireXXX)
     */
    protected boolean valueIsAdjusting;

    public FormEmailContentTableModel() {
        data = new ArrayList<FormEmailContent>();
    }

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    /**
     * Pour vider le modèle.
     */
    public void clear() {
        data.clear();
        if (!valueIsAdjusting) {
            fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    /**
     * @return une copie de la liste des bindings
     */
    public List<FormEmailContent> getData() {
        // always send a copy
        return new ArrayList<FormEmailContent>(data);
    }

    /**
     * Ajouter une entrée dans le modèle
     */
    public void addEntry(String formName, List<Client> clients) {
        FormEmailContent clientContent = new FormEmailContent();
        clientContent.formName = formName;
        clientContent.clients.addAll(clients);
        for (Client client : clients) {
            if (log.isDebugEnabled()) {
                log.debug("adding client : " + client.getName() + " in form "
                        + formName);
            }
        }
        data.add(clientContent);

        if (isValueIsAdjusting()) {
            int newIndex = data.size() - 1;
            fireTableRowsInserted(newIndex, newIndex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ensureColumnIndex(columnIndex);
        ensureRowIndex(rowIndex);
        FormEmailContent value = data.get(rowIndex);
        Object result = null;
        switch (columnIndex) {
            case 0:
                result = value.formName;
                break;
            case 1:
                result = value.clients;
                break;
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ensureColumnIndex(columnIndex);
        ensureRowIndex(rowIndex);
        FormEmailContent value = data.get(rowIndex);
        value.clients.clear();
        value.clients.addAll((Set<Client>) aValue);
        fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected void ensureRowIndex(int rowIndex) {
        if (rowIndex >= getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(
                    "rowIndex (" + rowIndex + ") can not be greater than "
                            + getRowCount());
        }
    }

    protected void ensureColumnIndex(int columnIndex) {
        if (columnIndex >= getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException(
                    "columnIndex (" + columnIndex + ") can not be greater than "
                            + getColumnCount());
        }
    }

}