package com.jurismarches.vradi.ui.editors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * @author morin
 *         Date: 26 nov. 2009
 *         Time: 19:05:06
 */
public class CurrencyEditorModel extends VradiEditorModel<String> {
    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(CurrencyEditorModel.class);

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_AMOUNT = "amount";
    public static final String PROPERTY_CURRENCY = "currency";

    protected Float amount;
    protected String currency;

    public Float getAmount() {
        return amount;
    }

    public void setAmount(Float amount) {
        Float oldValue = this.amount;
        this.amount = amount;
        pcs.firePropertyChange(PROPERTY_AMOUNT, oldValue, amount);
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        String oldValue = this.currency;
        this.currency = currency;
        pcs.firePropertyChange(PROPERTY_CURRENCY, oldValue, currency);
    }

    @Override
    public String getValue() {
        return amount + " " + currency;
    }

    @Override
    public void setValue(String value) {
        String oldValue = getValue();
        if (value != null) {
            String[] splitted = value.split("\\s+");
            try {
                Float amount = Float.parseFloat(splitted[0]);
                setAmount(amount);
                StringBuffer currency = new StringBuffer();
                for (int i = 1; i < splitted.length; i++) {
                    currency.append(splitted[i]).append(" ");
                }
                setCurrency(currency.toString().trim());
            } catch (NumberFormatException eee) {
                if (log.isErrorEnabled()) {
                    log.error("the first token is not a number : " + eee);
                }
            }
        }
        pcs.firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

}