package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminRequestUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminRequestUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminRequestUI adminRequestUI = this;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected javax.swing.JTable resultTable;
    protected com.jurismarches.vradi.ui.OfferListTableModel resultTableModel;
    protected javax.swing.JPanel searchPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSplitPane $JSplitPane0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private SearchUI searchUI;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    public SearchUI getSearchUI(){
        return searchUI;
    }
    
    public void show(String bean) {
       searchUI.setRequest(bean);
       setVisible(true);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        SwingUtil.fixTableColumnWidth(resultTable, 2, 60);
    
        jaxx.runtime.Util.assignment(searchUI = getSearchHandler().initCloneUI(this, resultTableModel), "searchUI", com.jurismarches.vradi.ui.admin.AdminRequestUI.this);
        searchPanel.add(searchUI, BorderLayout.CENTER);
            
        // Adding tooltip
        UIHelper.setI18nTableHeaderRenderer(resultTable,
                n_("vradi.offer.name"), n_("vradi.offer.name.tip"),
                n_("vradi.offerEdit.datePub"), n_("vradi.offerEdit.datePub.tip"),
                n_("vradi.offer.statut"), n_("vradi.offer.statut.tip"));
    
        OfferListTableModel.OfferListTableCellRenderer renderer =
                new OfferListTableModel.OfferListTableCellRenderer();
        resultTable.setDefaultRenderer(String.class, renderer);
        resultTable.setDefaultRenderer(Date.class, renderer);
        resultTable.setDefaultRenderer(int.class, renderer);
        
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "resultTableModel", resultTableModel) {
    
            @Override
            public void processDataBinding() {
                if (resultTableModel != null) {
                    getSearchHandler().executeQuery(adminRequestUI);
                }
            }
    
        };
    
        registerDataBinding(djb);
        djb.applyDataBinding();
    
    }
    
    protected void close(){
       setVisible(false);
       dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminRequestUI() {
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public javax.swing.JTable getResultTable() {
        return resultTable;
    }

    public com.jurismarches.vradi.ui.OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setResultTableModel(com.jurismarches.vradi.ui.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = newValue;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminRequestUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JSplitPane0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        paginationUI.setName("paginationUI");
    }

    protected void createResultTable() {
        $objectMap.put("resultTable", resultTable = new javax.swing.JTable());
        resultTable.setName("resultTable");
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminRequestUI();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add(searchPanel, JSplitPane.LEFT);
        $JSplitPane0.add($JPanel0, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationUI, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTable);
        // inline complete setup of $Table0
        $Table0.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 11 property setters
        resultTableModel.setNbFormsPerPage(10);
        resultTableModel.setPageToShow(1);
        $JSplitPane0.setDividerLocation(150);
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        resultTable.setAutoResizeMode(2);
        resultTable.setModel(resultTableModel);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminRequestUI", this);
        searchUI = null;
        createResultTableModel();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setContinuousLayout(true);
        $JSplitPane0.setDividerSize(6);
        createSearchPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createResultTable();
        createPaginationUI();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.cancel"));
        $JButton0.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminRequest.save"));
        $JButton1.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of adminRequestUI
        setName("adminRequestUI");
        SwingUtil.setComponentHeight(adminRequestUI,600);
        adminRequestUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminRequest.title"));
        SwingUtil.setComponentWidth(adminRequestUI,800);
        
        $completeSetup();
    }

}