package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.models.FieldSelectModel;
import com.jurismarches.vradi.models.FieldTypeModel;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.services.dto.VradiXmlStreamDTO;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.FormNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.content.RequestSelectUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import com.jurismarches.vradi.ui.search.SearchHandler;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import static org.nuiton.i18n.I18n._;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.*;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.*;
import java.util.List;

/**
 * @author letellier
 */
public class AdminHandler {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private final Log log = LogFactory.getLog(AdminHandler.class);

    static public final int TOOLTIP_LINE_MAX_CHAR_NB = 100;
    static public final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;

    public AdminPopupUI init(JAXXContext rootContext, Object... datas) {
        AdminPopupUI ui = VradiContext.ADMIN_UI_ENTRY_DEF
                .getContextValue(rootContext);

        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext()
                    .add(rootContext).add(this);

            VradiMainUI mainUI = VradiContext.MAIN_UI_ENTRY_DEF
                    .getContextValue(context);

            ui = new AdminPopupUI(context, mainUI);

            VradiContext.ADMIN_UI_ENTRY_DEF.setContextValue(rootContext, ui);
        } else {
            // Reinit thesaurus
            log.info("Reinit thesaurus");
            ui.getAdminThesaurus()
                    .reinit(new ThesaurusTreeHelper(ui, getRootThesaurus()));
        }
        return ui;
    }

    AdminPopupUI getUI(JAXXContext context) {
        if (context instanceof AdminPopupUI) {
            return (AdminPopupUI) context;
        }
        AdminPopupUI ui = VradiContext.ADMIN_UI_ENTRY_DEF
                .getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        AdminPopupUI ui = getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    protected XmlStreamService getXmlStreamService() {
        return ServiceHelper.getXmlStreamService();
    }

    // COMMON
    protected boolean answerToDelete(JAXXContext context, String name) {
        AdminPopupUI ui = getUI(context);

        int n = JOptionPane.showConfirmDialog(ui,
                _("vradi.admin.deleteAnswer") + name + " ?",
                _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);

        return n == JOptionPane.OK_OPTION;
    }

    protected void repaintSelectedNode(JAXXContext context,
                                       VradiNavigationTreeHelper helper) {
        helper.repaintNode(context, getSelectedNode(context, helper));
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context,
                                                 VradiNavigationTreeHelper helper) {
        return helper.getSelectedNode(context);
    }

    public void save(Object bean) {
        BusinessEntity entity = (BusinessEntity) bean;
        try {
            // up
            getVradiStorageService().updateEntity(entity);
        } catch (TechnicalException ex) {
            log.error("Cant saving bean : " + entity + " id : "
                    + entity.getWikittyId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
    }

    public void save(JAXXContext context, VradiNavigationTreeHelper helper,
                     Object... beans) {
        try {
            for (Object bean : beans) {
                log.info("will save bean " + bean);
                save(bean);
            }

        } finally {
            // Refresh nav
            repaintSelectedNode(context, helper);
        }
    }

    // If it's for thesaurus
    public boolean answerToSave(AdminThesaurusUI content) {
        if (content != null) {

            log.info("current content  to close "
                    + content.getClass().getSimpleName() + " : " + content
                    .isModified());
            if (content.isModified()) {
                int n = JOptionPane.showConfirmDialog(content,
                        _("vradi.admin.saveThesaurusAnswer") + " ?",
                        _("vradi.admin.saveTitle"),
                        JOptionPane.YES_NO_CANCEL_OPTION);
                switch (n) {
                    case JOptionPane.NO_OPTION:
                        // annule les modifications
                        cancelThesaurus(content, content.getHelper());
                        break;
                    case JOptionPane.OK_OPTION:
                        // sauvegarde les modifications
                        saveThesaurus(content, content.getHelper());
                        break;
                    case JOptionPane.CANCEL_OPTION:
                        // annule le changement d'onglet
                        return false;

                }
            }
        }
        return true;
    }

    public boolean answerToSave(AdminContentUI<?> content) {
        if (content != null) {

            log.info("current content  to close "
                    + content.getClass().getSimpleName() + " : " + content
                    .isModified());
            if (content.isModified()) {
                int n = JOptionPane.showConfirmDialog(content,
                        _("vradi.admin.saveAnswer")
                                + VradiHelper.getEntityName(content.getBean())
                                + " ?", _("vradi.admin.saveTitle"),
                        JOptionPane.YES_NO_CANCEL_OPTION);
                switch (n) {
                    case JOptionPane.NO_OPTION:
                        // annule les modifications
                        cancel(content, content.getHelper());
                        break;
                    case JOptionPane.OK_OPTION:
                        // sauvegarde les modifications
                        content.postSave();
                        break;
                    case JOptionPane.CANCEL_OPTION:
                        // annule le changement d'onglet
                        return false;

                }
            }
        }
        return true;
    }

    public void delete(JAXXContext context, VradiNavigationTreeHelper helper,
                       Object bean) {
        BusinessEntity entity = (BusinessEntity) bean;
        try {
            // up
            getVradiStorageService().deleteEntity(entity);

        } catch (TechnicalException ex) {
            log.error("Cant delete bean : " + entity + " id : "
                    + entity.getWikittyId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        } finally {

            // remove node
            NavigationTreeNode parent = helper
                    .removeChildNode(helper.getSelectedNode(context));

            // select parent node
            helper.selectNode(context, parent);
        }
    }

    protected <B> void cancel(AdminContentUI<B> content,
                              VradiNavigationTreeHelper helper) {
        B selectedBean = content.getSelectedEntity();
        try {
            content.openUI(helper.getSelectedNode(content));
        } catch (Exception e) {
            log.error(
                    "Cant cancel bean : " + selectedBean + " caused by : " + e,
                    e);
            ErrorDialogUI.showError(e);
        }
    }

    // MODELS
    // TODO : put in context
    public OfferListTableModel getResultTableModel(VradiFormPageDTO forms) {
        OfferListTableModel model = new OfferListTableModel(forms);
        return model;
    }

    public ComboBoxModel getTypesModel() {
        ComboBoxModel model = new FieldTypeModel();
        return model;
    }

    // THESAURUS
    public void refreshAllThesaurus(JAXXContext context) {
        List<OfferEditUI> editUIs = VradiContext.OFFERT_EDIT_UI_ENTRY_DEF
                .getContextValue(VradiContext.get());
        if (log.isDebugEnabled()) {
            log.debug("Refresh ui : " + (editUIs == null ? "is null"
                    : editUIs.size()));
        }
        if (editUIs != null) {
            for (OfferEditUI editUI : editUIs) {
                if (log.isDebugEnabled()) {
                    log.debug("Refresh ui : " + editUI.getData().getName());
                }
                OfferEditHandler offerEditHandler = UIHelper
                        .getHandler(context, OfferEditHandler.class);
                offerEditHandler.initThesaurus(context, editUI);
            }
        }
    }

    public VradiThesaurusDTO getRootThesaurus() {
        try {
            TreeNode rootThesaurus = getVradiStorageService()
                    .getRootThesaurus();
            VradiThesaurusDTO vradiThesaurusDTO = new VradiThesaurusDTO();
            vradiThesaurusDTO.fromWikitty(rootThesaurus);
            return vradiThesaurusDTO;
        } catch (TechnicalException e) {
            log.error("Cant get root thesaurus : ", e);
            ErrorDialogUI.showError(e);
        }
        return null;
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context,
                                                 ThesaurusTreeHelper helper) {
        // Get selected thesaurus
        NavigationTreeNode selectedNode = helper.getSelectedNode(context);
        if (selectedNode == null) {
            selectedNode = helper.getRootNode();
        }
        return selectedNode;
    }

    public boolean addChildThesaurusToSelected(JAXXContext context,
                                               ThesaurusTreeHelper helper) {
        NavigationTreeNode parentNode = getSelectedNode(context, helper);
        if (parentNode == null) {
            parentNode = helper.getRootNode();
        }
        return addChildThesaurus(context, helper, parentNode);
    }

    protected boolean addChildThesaurus(JAXXContext context,
                                        ThesaurusTreeHelper helper,
                                        NavigationTreeNode parentNode) {
        // Add new to parent
        VradiThesaurusDTO thesaurusParent = (VradiThesaurusDTO) parentNode
                .getBean(context);

        // Creating child
        TreeNode newTreeNode = new TreeNodeImpl();

        // Add child to parent thesaurus
        VradiThesaurusDTO newThesaurus = new VradiThesaurusDTO();
        newThesaurus.fromWikitty(newTreeNode);
        newThesaurus.setParentThesaurus(thesaurusParent);

        ThesaurusEditUI edit = new ThesaurusEditUI(context);

        edit.setBean(newThesaurus);
        attachListener(edit, newThesaurus);
        edit.setHelper(helper);
        edit.setTitleThesaurus(_("vradi.adminThesaurus.creationTitle"));

        if (log.isDebugEnabled()) {
            log.debug("Creating thesaurus " + newThesaurus.getName());
        }

        edit.setVisible(true);

        // If name is not empty
        if (edit.isSave()) {
            String name = edit.getName();
            if (name != null && !name.isEmpty()) {
                newThesaurus.setParentThesaurus(thesaurusParent);
                thesaurusParent.addChild(newThesaurus);

                // Mark to save
                newThesaurus.setToCreate(true);

                // Add in tree
                if (log.isDebugEnabled()) {
                    log.debug("Adding thesaurus " + newThesaurus.getName()
                            + " to parent " + parentNode);
                }
                NavigationTreeNode newNode = helper.getBuilder()
                        .addThesaurus(context, parentNode, newThesaurus);

                // Expend
                helper.expendNode(context, parentNode);

                return true;
            }
        }
        return false;
    }

    public boolean editThesaurusSelected(JAXXContext context,
                                         ThesaurusTreeHelper helper) {
        NavigationTreeNode selectedNode = getSelectedNode(context, helper);

        VradiThesaurusDTO selected = (VradiThesaurusDTO) selectedNode
                .getBean(context);

        // Ask name
        // TODO : Voir les impacts et difuser la modif
//        String name = JOptionPane.showInputDialog(getUI(context), _("vradi.thesaurus.askRenameName"));
        ThesaurusEditUI edit = new ThesaurusEditUI(context);

        attachListener(edit, selected);
        edit.setBean(selected);
        edit.setHelper(helper);
        edit.setTitleThesaurus(
                _("vradi.adminThesaurus.editTitle", selected.getName()));

        if (log.isDebugEnabled()) {
            log.debug("Editing thesaurus " + (selected == null ? " null "
                    : selected.getName()));
        }

        edit.setVisible(true);

        // If name is not empty
        if (edit.isSave()) {

            // Tag to delete
            selected.setToSave(true);

            // Get new seleted (when moved)
            selectedNode = getSelectedNode(edit, helper);

            // Repaint an expend
            helper.repaintNode(context, selectedNode);
            helper.expendNode(context, selectedNode);

            return true;
        }
        return false;
    }

    public boolean deleteThesaurusSelected(JAXXContext context,
                                           ThesaurusTreeHelper helper) {
        return deleteThesaurusSelected(context, helper, true);
    }

    public boolean deleteThesaurusSelected(JAXXContext context,
                                           ThesaurusTreeHelper helper,
                                           boolean ask) {
        NavigationTreeNode selectedNode = getSelectedNode(context, helper);

        return deleteThesaurus(context, helper, selectedNode, ask);
    }

    public boolean deleteThesaurus(JAXXContext context,
                                   ThesaurusTreeHelper helper,
                                   NavigationTreeNode selectedNode,
                                   boolean ask) {

        VradiThesaurusDTO selected = (VradiThesaurusDTO) selectedNode
                .getBean(context);

        // TODO : Voir les impacts et difuser la modif
        int result = JOptionPane.CANCEL_OPTION;
        if (ask) {
            result = JOptionPane.showConfirmDialog(getUI(context),
                    _("vradi.thesaurus.askdeleteThesaurus") + selected
                            .getRecursifName());
        } else {
            result = JOptionPane.OK_OPTION;
        }

        if (result == JOptionPane.OK_OPTION) {

            selected.setToDelete(true);

            helper.getBuilder().removeNodeFromParent(context, selectedNode);

            return true;
        }
        return false;
    }

    protected void deleteTreeNode(VradiThesaurusDTO toDelete) {
        try {
            ServiceHelper.getVradiStorageService()
                    .deleteEntity(toDelete.getBean());
        } catch (TechnicalException e) {
            log.error("Cant delete thesaurus : " + toDelete.getName() + " id : "
                    + toDelete.getWikittyId(), e);
            ErrorDialogUI.showError(e);
        }
    }

    // TODO its a hack, to remove
    protected void attachListener(final ThesaurusEditUI ui,
                                  VradiThesaurusDTO thesaurus) {
        thesaurus.addPropertyChangeListener(new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ui.setModified(true);
            }
        });
    }

    public void cancelThesaurus(JAXXContext context,
                                ThesaurusTreeHelper helper) {
        NavigationTreeNode node = helper.getRootNode();
        cancelThesaurus(context, helper, node);
    }

    public void cancelThesaurus(JAXXContext context, ThesaurusTreeHelper helper,
                                NavigationTreeNode node) {
        VradiThesaurusDTO bean = (VradiThesaurusDTO) node.getBean();
        if (bean.isToCreate()) {
            // Remove node created
            bean.setToCreate(false);
            helper.getBuilder().removeNodeFromParent(context, node);
        } else if (bean.isToDelete()) {
            // Add node deleted
            bean.setToDelete(false);
            helper.getBuilder().addThesaurus(context, node.getParent(), bean);
        } else if (bean.isToSave()) {
            // Revert modified node
            bean.setToSave(false);
            bean.revertFromWikitty();
        } else {
            // Find in child
            Enumeration<NavigationTreeNode> children = node.children();
            while (children.hasMoreElements()) {
                NavigationTreeNode child = children.nextElement();
                cancelThesaurus(context, helper, child);
            }
        }
        ((AdminThesaurusUI) context).setModified(false);
    }

    public void saveThesaurus(JAXXContext context, ThesaurusTreeHelper helper) {
        saveThesaurus(helper.getRootThesaurus());

        ((AdminThesaurusUI) context).setModified(false);

        // Refresh criteria
        UIHelper.getHandler(context, SearchHandler.class).initCriteria(context);

        refreshAllThesaurus(context);
    }

    protected void saveThesaurus(VradiThesaurusDTO toSave) {
        // Get bean
        TreeNode bean = toSave.getBean();

        // Get storage service
        VradiStorageService service = ServiceHelper.getVradiStorageService();

        // To save
        if (toSave.isToSave() || toSave.isToCreate()) {
            // Save
            try {
                // Set parent to child
                VradiThesaurusDTO parentThesaurus = toSave.getParentThesaurus();

                // If it's not root
                if (parentThesaurus != null) {
                    TreeNode parent = parentThesaurus.getBean();
                    bean.setParent(parent.getWikittyId());
                }

                // Update
                bean = (TreeNode) service.updateEntity(bean);
                if (log.isDebugEnabled()) {
                    log.debug("Saving thesaurus : " + bean.getName());
                }
            } catch (TechnicalException ex) {
                log.error("Cant save thesaurus : " + bean.getName() + " id : "
                        + bean.getWikittyId() + " caused by : ", ex);
                ErrorDialogUI.showError(ex);
            }
            // Its save
            toSave.setToSave(false);
            toSave.setToCreate(false);
            toSave.setToDelete(false);

            // To delete
        } else if (toSave.isToDelete()) {
            // Delete
            deleteTreeNode(toSave);
            if (log.isDebugEnabled()) {
                log.debug("Saving thesaurus : " + bean.getName());
            }

        }
        Collection<VradiThesaurusDTO> children = toSave.getChildren();
        if (children != null) {
            for (VradiThesaurusDTO child : children) {
                if (child != null) {
                    saveThesaurus(child);
                }
            }
        }
    }

    public void moveThesaurus(JAXXContext context,
                              ThesaurusTreeHelper helperFrom,
                              VradiThesaurusDTO beanToMove) {
        // Get node to move
        NavigationTreeNode nodeToMove = getSelectedNode(context, helperFrom);

        // Get root thesaurus
        VradiThesaurusDTO rootThesaurus = helperFrom.getRootThesaurus().clone();

        // Remove own branch
        boolean isDeleted = rootThesaurus.removeThesaurusRecursivly(beanToMove);
        if (log.isDebugEnabled()) {
            if (isDeleted) {
                log.debug("Thesaurus " + beanToMove.getName() + " is deleted");
            } else {
                log.debug("Thesaurus " + beanToMove.getName()
                        + " is not deleted (not found)");
            }
        }

        // Create new helper
        ThesaurusTreeHelper selectHelper = new ThesaurusTreeHelper(context,
                rootThesaurus, rootThesaurus.getWikittyId());

        // Create select ui
        ThesaurusPathChooserUI selectUI = new ThesaurusPathChooserUI(context,
                selectHelper);
        selectUI.setVisible(true);

        // If select
        if (selectUI.isSaved()) {
            // Get parent selected
            NavigationTreeNode nodeParentSelected = getSelectedNode(selectUI,
                    selectHelper);

            // Get corresponding parent selected node
            NavigationTreeNode nodeParentSelectedFrom = helperFrom
                    .findNode(context, nodeParentSelected.getFullPath());

            if (log.isDebugEnabled()) {
                log.debug("Selected node : " + nodeParentSelected.getFullPath()
                        + " finded node : " + nodeParentSelectedFrom
                        .getFullPath());
            }

            // Delete in tree
            deleteThesaurus(context, helperFrom, nodeToMove, false);

            // Remove from parent
            VradiThesaurusDTO oldParent = beanToMove.getParentThesaurus();
            oldParent.removeChild(beanToMove);

            // Get corresponding parent selected bean
            VradiThesaurusDTO thesaurusParentFrom
                    = (VradiThesaurusDTO) nodeParentSelectedFrom
                    .getBean(context);

            // Attach child
            thesaurusParentFrom.addChild(beanToMove);
            beanToMove.setParentThesaurus(thesaurusParentFrom);

            // Mark to save
            beanToMove.setToSave(true);

            // Add in tree
            NavigationTreeNode newNode = helperFrom.getBuilder()
                    .addThesaurusRecursivly(nodeParentSelectedFrom, beanToMove);

            // Expend
            helperFrom.selectNode(context, nodeParentSelectedFrom);
        }
        // TODO : Binding dont work
        ((ThesaurusEditUI) context).getPathField()
                .setText(beanToMove.getParentPath());
    }

    // REQUEST
    public void openRequest(JAXXContext rootContext, String request) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        // Create model
        OfferListTableModel offerListTableModel = getResultTableModel(
                query(request));
        context.add(offerListTableModel);

        AdminRequestUI requestUI = new AdminRequestUI(context);

        requestUI.show(request);

        // Get new value
        RequestSelectUI ui = (RequestSelectUI) rootContext;
        ui.setBean(requestUI.getSearchUI().getRequest());
    }

    // CLIENT
    public List<Client> getAllClients(JAXXContext context) {
        List<Client> values = VradiNavigationTreeHelper.CLIENTS
                .getContextValue(context);
        // always return a safe copy
        return new ArrayList<Client>(values);
    }

    public List<User> getAllUsers(JAXXContext context) {
        List<User> values = VradiNavigationTreeHelper.USERS
                .getContextValue(context);
        // always return a safe copy
        return new ArrayList<User>(values);
    }

    public void createClient(JAXXContext context,
                             VradiNavigationTreeHelper helper) {
        NavigationTreeNode addClient = helper
                .addClientToSelected(context, null);
        helper.selectNode(context, addClient);
    }

    // USER
    public void createUser(JAXXContext context,
                           VradiNavigationTreeHelper helper) {
        NavigationTreeNode addUser = helper.addUserToSelected(context, null);
        helper.selectNode(context, addUser);
    }

    // GROUP

    public List<Group> getAllGroups(JAXXContext context) {
        List<Group> values = VradiNavigationTreeHelper.GROUPS
                .getContextValue(context);
        // always return a safe copy
        return new ArrayList<Group>(values);
    }

    public void createGroup(JAXXContext context,
                            VradiNavigationTreeHelper helper) {
        NavigationTreeNode addGroup = helper.addGroupToSelected(context, null);
        helper.selectNode(context, addGroup);
    }

    // FORM
    public List<WikittyExtension> getAllForms(JAXXContext context) {
        List<WikittyExtension> values = VradiNavigationTreeHelper.FORMS
                .getContextValue(context);
        // always return a safe copy
        return new ArrayList<WikittyExtension>(values);
    }

    public void createFormType(JAXXContext context,
                               VradiNavigationTreeHelper helper) {
        String name = JOptionPane
                .showInputDialog(getUI(context), _("vradi.adminForm.askName"));

        if (name != null && !name.isEmpty()) {
            WikittyExtension formType = new WikittyExtension(name,
                    WikittyUtil.DEFAULT_VERSION,
                    Form.EXT_FORM, new LinkedHashMap<String, FieldType>());
            NavigationTreeNode addFormType = helper
                    .addFormTypeToSelected(context, formType);
            helper.selectNode(context, addFormType);
        }
    }

    public void createForms(JAXXContext context) {
        AdminXmlStreamUI ui = getXmlStreamUI(context);
        XmlStream xmlStream = ui.getBean();
        VradiUser vradiUser = ui.getContextValue(VradiUser.class);
        if (xmlStream != null) {
            try {
                String lastItem = getVradiStorageService()
                        .getFormsFromXmlStream(xmlStream,
                                VradiHelper.getLastItemOfXmlStream(
                                        xmlStream.getName()), vradiUser);
                VradiHelper
                        .setLastItemOfXmlStream(xmlStream.getName(), lastItem);
            } catch (TechnicalException ex) {
                log.error("Cant create form : " + ex);
                ErrorDialogUI.showError(ex);
            }
        }
    }

    public void saveFormType(JAXXContext context,
                             VradiNavigationTreeHelper helper,
                             java.util.List<FieldSelectModel> fields,
                             WikittyExtension formType) {
//        WikittyExtension newFormType = (WikittyExtension) helper.getSelectedBean(context);
        WikittyExtension newFormType = new WikittyExtension(formType.getName(),
                formType.getVersion(), formType.getRequires(), null);
        FieldSelectModel[] models = new FieldSelectModel[fields.size()];
        for (FieldSelectModel field : fields) {
            models[field.getPosition()] = field;
        }
        for (int i = 0; i < models.length; i++) {
            FieldSelectModel model = models[i];
            String name = model.getNameValue();
            if (name != null && model.getType() != null) {
                FieldType fieldType = model.getType().getFieldType();
                if (model.getDescValue() != null && !model.getDescValue()
                        .isEmpty()) {
                    fieldType.addTagValue(VradiHelper.TYPE_DESCRIPTION,
                            model.getDescValue());
                }
                newFormType.addField(name, fieldType);
            }
        }
        Date now = new Date();
        newFormType.addTagValue(VradiHelper.TYPE_LAST_MODIFIED_DATE,
                String.format("%1$td/%1$tm/%1$ty", now));
        newFormType.addTagValue(VradiHelper.TYPE_LAST_MODIFIED_TIME,
                String.format("%1$tk:%1$tM:%1$tS", now));
        newFormType.addTagValue(VradiHelper.TYPE_LAST_MODIFIED_BY,
                context.getContextValue(VradiUser.class).getName());
        try {
            // up
            getVradiStorageService().updateFormType(newFormType);

            NavigationTreeNode selectedNode = helper.getSelectedNode(context);
            List<WikittyExtension> forms = FormNavigationTreeHelper.FORMS
                    .getContextValue(context);
            forms.remove(selectedNode.getBean());
            forms.add(newFormType);
            selectedNode.setBean(newFormType);

            selectedNode.reload(context);

            UIHelper.getHandler(context, SearchHandler.class)
                    .getCriterias(context).getFormTypeSelection().setModel(
                    new DefaultComboBoxModel(VradiHelper.getFormTypes()));

            // Refresh main menu
            VradiContext.MAIN_UI_ENTRY_DEF.getContextValue(context)
                    .updateFormMenu();

        } catch (TechnicalException ex) {
            log.error("Cant adding formType : " + formType.getName() + " id : "
                    + formType.getId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
    }

    public VradiFormPageDTO query(String query) {
        try {
            VradiFormPageDTO result = new VradiFormPageDTO();
            getVradiStorageService().findForms(query, result);
            return result;
        } catch (TechnicalException eee) {
            log.error("Cant execute query : " + eee);
            ErrorDialogUI.showError(eee);
            return null;
        }
    }

    public WikittyExtension getExtension(String extensionName) {
        try {
            return getVradiStorageService().getFormType(extensionName);
        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
                ErrorDialogUI.showError(e);
            }
            return null;
        }
    }
//    public void deleteForm(JAXXContext context, WikittyExtension form){
//        // del
//        if (answerToDelete(context, form.getName())){
//            try {
//                getVradiStorageService(context).deleteFormType(form);
//
//                // Refresh nav
//                AdminNavUI adminFormUI = getUI(context).getAdminFormUI();
//                delItemToNav(adminFormUI, form);
//            } catch (TechnicalException ex) {
//                log.error("Cant deleting user : " + form.getName() + " id : " + form.getId() + " caused by : " + ex);
//            }
//        }
//    }

    // RSS
    /**
     * Cache of the already loaded urls : keeps only the first Element parsed
     */
    public static final Map<String, Element> XML_STREAM_FIELDS_CACHE
            = new HashMap<String, Element>();

    public void createXmlStream(JAXXContext context,
                                VradiNavigationTreeHelper helper) {
        NavigationTreeNode addXmlStream = helper
                .addXmlStreamToSelected(context, null);
        helper.selectNode(context, addXmlStream);
    }

//    public void deleteXmlStream(JAXXContext context, XmlStream xmlStream) {
//        // del
//        if (answerToDelete(context, xmlStream.getUrl())) {
//            try {
//                getVradiStorageService().deleteXmlStream(xmlStream.getWikittyId());
//            } catch (TechnicalException ex) {
//                log.error("Cant deleting xmlStream : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + ex);
//            }
//        }
//    }

//    public VradiXmlStreamDTO saveXmlStream(JAXXContext context, VradiNavigationTreeHelper helper,
//                                           XmlStream xmlStream, List<XmlFieldBinding> bindings) {
//        VradiXmlStreamDTO result = new VradiXmlStreamDTO();
//        result.fromWikitty(xmlStream);
//        try {
//            getVradiStorageService().updateXmlFieldBindings(bindings);
//            xmlStream.clearXmlFieldBinding();
//            for (XmlFieldBinding binding : bindings) {
//                xmlStream.addXmlFieldBinding(binding.getWikittyId());
//            }
//            xmlStream = getVradiStorageService().updateXmlStream(xmlStream);
//            result.fromWikitty(xmlStream);
//
//            // Refresh nav
//            repaintSelectedNode(context, helper);
//        } catch (TechnicalException ex) {
//            log.error("Cant adding client : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + ex);
//        }
//        return result;
//    }

    public XmlStream saveXmlStream(JAXXContext context,
                                   VradiNavigationTreeHelper helper,
                                   XmlStream xmlStream,
                                   List<XmlFieldBinding> bindings) {
        XmlStream result = null;
        try {
            bindings = getVradiStorageService()
                    .updateXmlFieldBindings(bindings);
            xmlStream.clearXmlFieldBinding();
            for (XmlFieldBinding binding : bindings) {
                if (log.isDebugEnabled()) {
                    log.debug(binding.getFormField() + " : " + (
                            binding.getXmlField() != null ? binding
                                    .getXmlField().size() : "null"));
                }
                xmlStream.addXmlFieldBinding(binding.getWikittyId());
            }
            result = (XmlStream) getVradiStorageService()
                    .updateEntity(xmlStream);
            if (log.isDebugEnabled()) {
                if (result != null) {
                    for (String s : result.getXmlFieldBinding()) {
                        log.debug(getVradiStorageService()
                                .getXmlFieldBinding(s).getXmlField());
                    }
                }
            }

            // Refresh nav
            repaintSelectedNode(context, helper);
        } catch (TechnicalException ex) {
            log.error("Cant adding client : " + xmlStream.getUrl() + " id : "
                    + xmlStream.getWikittyId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
        return result;
    }

//    public List<String> getXmlStreamAttributes(String url) {
//        List<String> xmlFields = new ArrayList<String>();
//        try {
//            xmlFields = getXmlStreamService().getRSSFields(url);
//        } catch (TechnicalException eee) {
//            eee.printStackTrace();
//        }
//
//        return xmlFields;
//    }

    public List<XmlFieldBinding> getXmlStreamFields(XmlStream xmlStream) {
        List<XmlFieldBinding> result;
        try {
            result = getVradiStorageService().getXmlFieldBindings(xmlStream);
            if (log.isDebugEnabled()) {
                for (XmlFieldBinding xmlFieldBinding : result) {
                    log.debug(xmlFieldBinding.getFormField() + " : "
                            + xmlFieldBinding.getXmlField());
                }
            }
        } catch (TechnicalException eee) {
            log.error("Cant get xml stream : ", eee);
            ErrorDialogUI.showError(eee);
            result = new ArrayList<XmlFieldBinding>();
        }
        return result;
    }

    public WikittyExtension getFormType(XmlStream xmlStream) {
        List<XmlFieldBinding> bindings = getXmlStreamFields(xmlStream);
        WikittyExtension result = null;
        for (XmlFieldBinding binding : bindings) {
            String formField = binding.getFormField();
            if (formField != null) {
                WikittyExtension formType = getExtension(formField.substring(0,
                        formField.lastIndexOf('.')));
                if (formType != null && !formType.getName()
                        .equals(Form.EXT_FORM)) {
                    result = formType;
                    break;
                }
            }
        }
        return result;
    }

    public void updateFieldsModel(JAXXContext context) {
        AdminXmlStreamUI ui = getXmlStreamUI(context);

        XmlStreamFieldTableModel fieldsModel = getXmlStreamUI(context)
                .getFieldsModel();
        fieldsModel.setValueIsAdjusting(true);

        try {

            fieldsModel.clear();

            VradiXmlStreamDTO bean = ui.getBean();

            List<XmlFieldBinding> bindings = getXmlStreamFields(bean);

            WikittyExtension formType = bean.getFormType();
            if (formType == null) {

                // pas de type de formulaire
                if (log.isDebugEnabled()) {
                    log.debug("No form type, stop update");
                }
                return;
            }

            String url = bean.getUrl();
            if (url == null || url.trim().isEmpty()) {
                // pas d'url
                if (log.isDebugEnabled()) {
                    log.debug("No url, stop update");
                }
                return;
            }

            // recuperation des chanmps xml disponibles
            List<String> xmlFieldNames = new ArrayList<String>();
            Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
            if (xmlStreamFields.get(url) == null) {
                try {
                    Element firstElement = getXmlStreamService()
                            .getFirstElement(url);
                    xmlFieldNames = getXmlStreamService()
                            .getRSSFields(firstElement);
                    xmlStreamFields.put(url, firstElement);
                } catch (Exception eee) {
                    log.error("Can't bind xml stream : " + eee);
                    JOptionPane.showMessageDialog(ui,
                            _("vradi.adminXmlStream.badURL.message"),
                            _("vradi.adminXmlStream.badURL.title"),
                            JOptionPane.ERROR_MESSAGE);
                    return;
                }
            } else {
                xmlFieldNames = getXmlStreamService()
                        .getRSSFields(xmlStreamFields.get(url));
            }

            // mise a jour de l'univers des valeurs selectionnables
            ui.getContextValue(JListCellEditor.class)
                    .updateUniverse(xmlFieldNames);
            ui.getContextValue(JListCellRenderer.class)
                    .updateUniverse(xmlFieldNames);

            if (xmlFieldNames.size() > 0) {
                ui.getFieldsTable().setRowHeight(19 * xmlFieldNames.size());
            }

            // recuperation des noms des champs disponibles
            LinkedHashMap<String, XmlFieldBinding> fieldNames
                    = new LinkedHashMap<String, XmlFieldBinding>();

            fieldNames.put(Form.FQ_FIELD_ID, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_NAME, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_DATEPUB, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_DATEPEREMPTION,
                    new XmlFieldBindingImpl());
            for (String fieldName : formType.getFieldNames()) {
                fieldNames.put(formType.getName() + "." + fieldName,
                        new XmlFieldBindingImpl());
            }

            // ajout des bindings existants
            for (XmlFieldBinding binding : bindings) {
                String formField = binding.getFormField();
                if (log.isDebugEnabled()) {
                    log.debug(formField);
                }
                if (fieldNames.get(formField) != null) {
                    fieldNames.put(formField, binding);
                }
            }

            // ajout des nouveaux bindings
            for (String fieldName : fieldNames.keySet()) {
                XmlFieldBinding binding = fieldNames.get(fieldName);
                if (binding != null) {
                    binding.setFormField(fieldName);
                    fieldsModel.addEntry(binding);
                }
            }

        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
                ErrorDialogUI.showError(e);
            }
        } finally {

            fieldsModel.fireTableDataChanged();
            fieldsModel.setValueIsAdjusting(false);
        }
    }

    private AdminXmlStreamUI getXmlStreamUI(JAXXContext context) {
        if (context instanceof AdminXmlStreamUI) {
            return (AdminXmlStreamUI) context;
        }
        return null;
    }

    public String getFirstElementPreview(JAXXContext context, String url) {
        AdminXmlStreamUI ui = getXmlStreamUI(context);
        StringBuffer result = new StringBuffer();
        if (url == null || url.trim().isEmpty()) {
            // pas d'url
            if (log.isErrorEnabled()) {
                log.debug("No url, stop update");
            }
            return "";
        }
        Element firstElement = null;
        Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
        if (xmlStreamFields.get(url) == null) {
            try {
                ui.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                firstElement = getXmlStreamService().getFirstElement(url);
                xmlStreamFields.put(url, firstElement);
            } catch (Exception eee) {
                return "";
            } finally {
                ui.setCursor(null);
            }
        } else {
            firstElement = xmlStreamFields.get(url);
        }
        if (firstElement == null) {
            return "";
        }
        try {
            Map<String, String> elementValues = getXmlStreamService()
                    .getFirstElementValues(firstElement);
            result.append("<html>");
            for (Map.Entry entry : elementValues.entrySet()) {
                result.append("<strong>").append(entry.getKey())
                        .append("</strong>").append(" : ");
                String value = (String) entry.getValue();
                if (value.length() > TOOLTIP_ELEMENT_MAX_CHAR_NB) {
                    value = value.substring(0,
                            value.lastIndexOf(' ', TOOLTIP_ELEMENT_MAX_CHAR_NB))
                            + "...";
                }
                while (value.length() > TOOLTIP_LINE_MAX_CHAR_NB) {
                    result.append(value.substring(0,
                            value.lastIndexOf(' ', TOOLTIP_LINE_MAX_CHAR_NB)))
                            .append("<br/>&nbsp;");
                    value = value.substring(
                            value.lastIndexOf(' ', TOOLTIP_LINE_MAX_CHAR_NB));
                }
                result.append(value).append("<br/>");
            }
            result.append("</html>");

            return result.toString();

        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
            }
            return "";
        }
    }

    /**
     * Create the model and store it in the given context.
     * <p/>
     *
     * @param context the context where to hold the model
     */
    public void createModel(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug("createModel");
        }
        try {
            List<WikittyExtension> allForms = getVradiStorageService()
                    .getAllFormTypes();
            Collections.sort(allForms, FORM_COMPARATOR);
            VradiNavigationTreeHelper.FORMS.setContextValue(context, allForms);

            List<Group> allGroups = getVradiStorageService().getAllGroups();
            Collections.sort(allGroups, GROUP_COMPARATOR);
            VradiNavigationTreeHelper.GROUPS
                    .setContextValue(context, allGroups);

            List<Client> clients = getVradiStorageService().getAllClients();
            Collections.sort(clients, CLIENT_COMPARATOR);
            VradiNavigationTreeHelper.CLIENTS.setContextValue(context, clients);

            List<XmlStream> xmlStreams = getVradiStorageService()
                    .getAllXmlStreams();
            Collections.sort(xmlStreams, XML_STREAM_COMPARATOR);
            VradiNavigationTreeHelper.XMLSTREAMS
                    .setContextValue(context, xmlStreams);

            List<User> users = new ArrayList<User>();
            for (Client c : clients) {
                Set<String> usersId = c.getUser();
                if (usersId != null) {
                    for (String userId : usersId) {
                        User user = getVradiStorageService().getUser(userId);
                        users.add(user);
                    }
                }
            }
            Collections.sort(users, USER_COMPARATOR);
            VradiNavigationTreeHelper.USERS.setContextValue(context, users);
        } catch (TechnicalException ex) {
            log.error(ex);
            ErrorDialogUI.showError(ex);
            //FIXME should we do something ??? (return an empty model for example)
        }
    }

    protected static final Comparator<Client> CLIENT_COMPARATOR
            = new Comparator<Client>() {

        @Override
        public int compare(Client o1, Client o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<User> USER_COMPARATOR
            = new Comparator<User>() {

        @Override
        public int compare(User o1, User o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<Group> GROUP_COMPARATOR
            = new Comparator<Group>() {

        @Override
        public int compare(Group o1, Group o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<WikittyExtension> FORM_COMPARATOR
            = new Comparator<WikittyExtension>() {

        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<XmlStream> XML_STREAM_COMPARATOR
            = new Comparator<XmlStream>() {

        @Override
        public int compare(XmlStream o1, XmlStream o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
}

