package org.sharengo.wikitty.search;

public class AssociatedRestriction extends Restriction {

	private static final long serialVersionUID = 1L;

	private Restriction associatedRestriction;
	private Restriction embededRestriction;
	private Element element;
	
	public AssociatedRestriction(Restriction parentRestriction, Restriction embededRestriction, Element element) {
		this.associatedRestriction = parentRestriction;
		this.embededRestriction = embededRestriction;
		this.name = RestrictionName.ASSOCIATED;
		this.element = element;
	}
	
	public Restriction getParentRestrictionDto() {
		return associatedRestriction;
	}
	
	public Element getElement() {
		return element;
	}
	
	public void setElement(Element element) {
		this.element = element;
	}

	public Restriction getRestriction() {
		return embededRestriction;
	}
}
