/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.function.OrdFieldSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoolField
extends FieldType {
    protected static final Token TRUE_TOKEN = new Token("T", 0, 1);
    protected static final Token FALSE_TOKEN = new Token("F", 0, 1);
    protected static final Analyzer boolAnalyzer = new SolrAnalyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new Tokenizer(reader){
                boolean done;
                {
                    this.done = false;
                }

                public Token next() throws IOException {
                    if (this.done) {
                        return null;
                    }
                    this.done = true;
                    int ch = this.input.read();
                    if (ch == -1) {
                        return null;
                    }
                    return ch == 116 || ch == 84 || ch == 49 ? TRUE_TOKEN : FALSE_TOKEN;
                }
            };
        }
    };

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field) {
        return new OrdFieldSource(field.name);
    }

    @Override
    public Analyzer getAnalyzer() {
        return boolAnalyzer;
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return boolAnalyzer;
    }

    @Override
    public String toInternal(String val) {
        int ch = val != null && val.length() > 0 ? (int)val.charAt(0) : 0;
        return ch == 49 || ch == 116 || ch == 84 ? "T" : "F";
    }

    @Override
    public String toExternal(Fieldable f) {
        return this.indexedToReadable(f.stringValue());
    }

    @Override
    public Boolean toObject(Fieldable f) {
        return Boolean.valueOf(this.toExternal(f));
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        char ch = indexedForm.charAt(0);
        return ch == 'T' ? "true" : "false";
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeBool(name, f.stringValue().charAt(0) == 'T');
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeBool(name, f.stringValue().charAt(0) == 'T');
    }
}

