/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

public class OfferListTableModel
extends AbstractTableModel {
    private static Log log = LogFactory.getLog(OfferListTableModel.class);
    public static final String PAGE_TO_SHOW_PROPERTY = "pageToShow";
    public static final String NB_FORMS_PER_PAGE_PROPERTY = "nbFormsPerPage";
    public static final String FIELD_TO_SORT_PROPERTY = "fieldToSort";
    public static final String ASCENDING_PROPERTY = "ascending";
    public static final String NB_PAGES = "nbPages";
    public static final String LAST_PAGE = "lastPage";
    public static final int TOOLTIP_LINE_MAX_CHAR_NB = 100;
    public static final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;
    protected VradiFormPageDTO datas;
    protected Map<String, TreeNode> thesaurus;
    protected List<String> columnNames;
    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public OfferListTableModel(VradiFormPageDTO datas) {
        this.columnNames = new ArrayList<String>();
        this.columnNames.add(I18n.n_((String)"vradi.offer.name"));
        this.columnNames.add(I18n.n_((String)"vradi.offerEdit.datePub"));
        this.columnNames.add(I18n.n_((String)"vradi.offer.statut"));
        this.thesaurus = new HashMap<String, TreeNode>();
        List<String> columnsThesaurusId = VradiHelper.getVradiListColumns();
        for (String id : columnsThesaurusId) {
            try {
                TreeNode t = ServiceHelper.getVradiStorageService().getThesaurus(id);
                if (t != null) {
                    this.thesaurus.put(t.getName(), t);
                    this.columnNames.add(t.getName());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Adding Thesaurus name : " + t.getName()));
                    continue;
                }
                log.error((Object)("Cant get thesaurus : " + id));
            }
            catch (TechnicalException e) {
                log.error((Object)("Cant get thesaurus : " + id), (Throwable)e);
                ErrorDialogUI.showError((Exception)e);
            }
        }
        this.datas = datas != null ? datas : new VradiFormPageDTO();
        datas.addPropertyChangeListener("totalFoundFormNb", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OfferListTableModel.this.propertyChange.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                OfferListTableModel.this.propertyChange.firePropertyChange(OfferListTableModel.NB_PAGES, null, OfferListTableModel.this.getNbPages());
                OfferListTableModel.this.propertyChange.firePropertyChange(OfferListTableModel.LAST_PAGE, null, (Object)OfferListTableModel.this.isLastPage());
            }
        });
        this.fireTableDataChanged();
    }

    public Integer getNbFormsPerPage() {
        return this.datas.getNbFormsToShow();
    }

    public void setNbFormsPerPage(Integer nbFormsPerPage) {
        Integer oldValue = this.getNbFormsPerPage();
        this.datas.setNbFormsToShow(nbFormsPerPage.intValue());
        int i = Double.valueOf(Math.ceil(Integer.valueOf(oldValue * (this.getPageToShow() - 1)).doubleValue() / nbFormsPerPage.doubleValue())).intValue();
        this.setPageToShow(i == 0 && this.getTotalFoundFormNb() > 0 ? 1 : i);
        this.fireTableDataChanged();
        this.propertyChange.firePropertyChange(NB_FORMS_PER_PAGE_PROPERTY, oldValue, nbFormsPerPage);
        this.propertyChange.firePropertyChange(NB_PAGES, null, this.getNbPages());
        this.propertyChange.firePropertyChange(LAST_PAGE, null, (Object)this.isLastPage());
    }

    public Integer getPageToShow() {
        return this.datas.getPageToShow();
    }

    public void setPageToShow(Integer pageToShow) {
        Integer oldValue = this.getPageToShow();
        this.datas.setPageToShow(pageToShow.intValue());
        this.fireTableDataChanged();
        this.propertyChange.firePropertyChange(PAGE_TO_SHOW_PROPERTY, oldValue, pageToShow);
        this.propertyChange.firePropertyChange(LAST_PAGE, null, (Object)this.isLastPage());
    }

    public String getFieldToSort() {
        return this.datas.getFieldToSort();
    }

    public void setFieldToSort(String fieldToSort) {
        Integer oldValue = this.getPageToShow();
        this.datas.setFieldToSort(fieldToSort);
    }

    public boolean isAscending() {
        return this.datas.isAscending();
    }

    public void setAscending(boolean ascending) {
        this.datas.setAscending(ascending);
    }

    public Integer getTotalFoundFormNb() {
        return this.datas.getTotalFoundFormNb();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        if (col >= 0) {
            return this.columnNames.get(col);
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.datas.getFormsToShow().size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.datas.getFormsToShow().get(row) != null) {
            if (col < 3) {
                switch (col) {
                    case 0: {
                        return ((Form)this.datas.getFormsToShow().get(row)).getName();
                    }
                    case 1: {
                        return ((Form)this.datas.getFormsToShow().get(row)).getDatePub();
                    }
                    case 2: {
                        return ((Form)this.datas.getFormsToShow().get(row)).getStatut();
                    }
                }
            } else {
                Set<String> thesaurusIdOfBean = ((Form)this.datas.getFormsToShow().get(row)).getThesaurus();
                String result = "";
                if (thesaurusIdOfBean != null) {
                    String name = this.columnNames.get(col);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Want thesaurus name : " + name));
                    }
                    TreeNode thesaurusOfColumns = this.thesaurus.get(name);
                    for (String idOfBean : thesaurusIdOfBean) {
                        Set children = thesaurusOfColumns.getChildren();
                        if (children == null || !children.contains(idOfBean)) continue;
                        TreeNode thesaurusToDisplay = null;
                        try {
                            thesaurusToDisplay = ServiceHelper.getVradiStorageService().getThesaurus(idOfBean);
                        }
                        catch (TechnicalException e) {
                            log.error((Object)("cant get thesaurus : " + idOfBean), (Throwable)e);
                            ErrorDialogUI.showError((Exception)e);
                        }
                        if (thesaurusToDisplay == null) continue;
                        result = result + thesaurusToDisplay.getName() + ", ";
                    }
                    if (result.length() > 0) {
                        result = result.substring(0, result.length() - 2);
                    }
                }
                return result;
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Date.class;
            }
            case 2: {
                return Integer.TYPE;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.datas.getFormsToShow().get(row) != null && col < 3) {
            switch (col) {
                case 0: {
                    ((Form)this.datas.getFormsToShow().get(row)).setName(value.toString());
                }
                case 1: {
                    ((Form)this.datas.getFormsToShow().get(row)).setDatePub((Date)value);
                }
                case 2: {
                    ((Form)this.datas.getFormsToShow().get(row)).setStatut((Integer)value);
                }
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public VradiFormPageDTO getDatas() {
        return this.datas;
    }

    public String getFieldNameAt(int col) {
        if (col < 3) {
            switch (col) {
                case 0: {
                    return "Form.name";
                }
                case 1: {
                    return "Form.datePub";
                }
                case 2: {
                    return "Form.statut";
                }
            }
        } else {
            return this.columnNames.get(col);
        }
        return null;
    }

    public boolean isLastPage() {
        boolean result = Double.valueOf(Math.ceil(this.getTotalFoundFormNb().doubleValue() / this.getNbFormsPerPage().doubleValue())).intValue() <= this.getPageToShow();
        return result;
    }

    public String getNbPages() {
        int nbPages = Double.valueOf(Math.ceil(this.getTotalFoundFormNb().doubleValue() / this.getNbFormsPerPage().doubleValue())).intValue();
        return " / " + String.valueOf(nbPages);
    }

    public String getToolTip(int row) {
        StringBuffer result = new StringBuffer();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        Form form = (Form)this.datas.getFormsToShow().get(row);
        Collection extensionNames = form.getExtensionNames();
        for (String string : extensionNames) {
            Collection fieldNames = form.getExtensionFields(string);
            for (String fieldName : fieldNames) {
                fieldValues.put(fieldName, form.getField(string, fieldName));
            }
        }
        result.append("<html>");
        for (Map.Entry entry : fieldValues.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            String stringValue = value.getClass().equals(Date.class) ? DateFormat.getDateTimeInstance(3, 2, Locale.FRANCE).format((Date)value) : String.valueOf(value);
            result.append("<strong>").append(entry.getKey()).append("</strong>").append(" : ");
            if (stringValue.length() > 500) {
                stringValue = stringValue.substring(0, stringValue.lastIndexOf(32, 500)) + "...";
            }
            log.debug((Object)stringValue);
            while (stringValue.length() > 100) {
                int spaceIndex = stringValue.lastIndexOf("\\s", 100);
                String lineValue = stringValue.substring(0, spaceIndex < 0 ? stringValue.length() : spaceIndex);
                result.append(lineValue);
                result.append("<br/>&nbsp;");
                stringValue = stringValue.substring(spaceIndex < 0 ? stringValue.length() : spaceIndex);
            }
            result.append(stringValue).append("<br/>");
        }
        result.append("</html>");
        return result.toString();
    }

    public TreeNode getThesaurusByName(String name) {
        return this.thesaurus.get(name);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(propertyName, listener);
    }

    public static class OfferListTableCellRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue = value != null && value.getClass().equals(Date.class) ? DateFormat.getDateTimeInstance(3, 2, Locale.FRANCE).format((Date)value) : String.valueOf(value);
            JLabel label = new JLabel(stringValue);
            OfferListTableModel model = (OfferListTableModel)table.getModel();
            label.setToolTipText(model.getToolTip(row));
            return label;
        }
    }

    public static abstract class OfferListTableModelBinding
    extends DefaultJAXXBinding {
        protected OfferListTableModel model;

        public OfferListTableModelBinding(JAXXObject source, String id, OfferListTableModel model) {
            super(source, id, false);
            this.model = model;
        }

        public void applyDataBinding() {
            if (this.model != null) {
                this.model.addPropertyChangeListener(OfferListTableModel.PAGE_TO_SHOW_PROPERTY, (PropertyChangeListener)((Object)this));
                this.model.addPropertyChangeListener(OfferListTableModel.NB_FORMS_PER_PAGE_PROPERTY, (PropertyChangeListener)((Object)this));
            }
        }

        public void removeDataBinding() {
            if (this.model != null) {
                this.model.removePropertyChangeListener(OfferListTableModel.PAGE_TO_SHOW_PROPERTY, (PropertyChangeListener)((Object)this));
                this.model.addPropertyChangeListener(OfferListTableModel.NB_FORMS_PER_PAGE_PROPERTY, (PropertyChangeListener)((Object)this));
            }
        }
    }
}

