/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.VradiTabHeader;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.MouseInputAdapter;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

public class OfferListHandler {
    private static final Log log = LogFactory.getLog(OfferListHandler.class);
    public static final int TABPANEL_LABEL_MAX_CHAR_NB = 30;

    public OfferListUI initUI(JAXXContext rootContext, VradiMainUIHandler rootHandler) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        SearchHandler searchHandler = UIHelper.getHandler((JAXXContext)context, SearchHandler.class);
        OfferListTableModel offerListTableModel = this.getOfferListTableModel();
        context.add((Object)offerListTableModel);
        OfferListUI ui = new OfferListUI((JAXXContext)context);
        SearchUI searchUI = searchHandler.initUI(rootContext, offerListTableModel);
        searchUI.setOfferListUI(true);
        ui.getSearchPanel().add((Component)((Object)searchUI), "Center");
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        return ui;
    }

    public OfferListTableModel getOfferListTableModel() {
        OfferListTableModel model = null;
        GregorianCalendar now = new GregorianCalendar();
        now.set(10, 0);
        now.set(12, 0);
        now.set(14, 0);
        try {
            VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
            ServiceHelper.getVradiStorageService().findForms(null, null, "Form.datePub", now.getTime(), now.getTime(), null, formPageDTO);
            model = new OfferListTableModel(formPageDTO);
        }
        catch (TechnicalException eee) {
            log.error((Object)"Cant find forms for this day ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
            model = new OfferListTableModel(new VradiFormPageDTO());
        }
        return model;
    }

    public void addEditPane(JAXXContext context, final Form data) {
        final OfferListUI ui = this.getUI(context);
        ui.setDividerLocation(0);
        ui.setResizeWeight(0.0);
        ui.setDividerSize(10);
        JTabbedPane contentTabbedPane = ui.getEditTabs();
        String id = data.getWikittyId();
        if (contentTabbedPane.indexOfTab(id) < 0) {
            final OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
            final OfferEditUI editUi = handler.initUI(context, data);
            contentTabbedPane.add(id, editUi);
            final VradiTabHeader panel = new VradiTabHeader();
            if (data.getName() != null) {
                String panelLabel = data.getName().length() < 30 ? data.getName() : data.getName().substring(0, 30) + "...";
                panel.getLabel().setText(panelLabel);
            }
            panel.setId(id);
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(id), (Component)((Object)panel));
            panel.getCloseTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.closePane((JAXXContext)editUi, panel.getId());
                }
            });
            panel.getDetachTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.detachPane(e);
                }
            });
            editUi.getAnnuler().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OfferListHandler.this.closePane((JAXXContext)editUi, panel.getId());
                }
            });
            editUi.getValidate().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    handler.save((JAXXContext)editUi, data);
                    OfferListHandler.this.closePane((JAXXContext)editUi, panel.getId());
                    SearchHandler handler2 = UIHelper.getHandler((JAXXContext)editUi, SearchHandler.class);
                    handler2.executeQuery((JAXXContext)ui);
                }
            });
        }
        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(id));
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        return (VradiTabHeader)((Object)button.getParent());
    }

    protected void closePane(JAXXContext context, String id) {
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        int index = contentTabbedPane.indexOfTab(id);
        if (index > -1) {
            contentTabbedPane.remove(index);
        }
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    private void removeEditPaneFromRef(OfferEditUI ui) {
        ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).remove(ui);
    }

    protected void detachPane(MouseEvent e) {
        VradiTabHeader mytab = this.getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        final OfferEditUI content = this.getOfferEdit(contentTabbedPane, id);
        final JFrame frame = new JFrame(name);
        content.getValidate().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        content.getAnnuler().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)content, "Center");
        frame.setVisible(true);
        frame.setSize(new Dimension(800, 800));
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected OfferEditUI getOfferEdit(JTabbedPane contentTabbedPane, String id) {
        return (OfferEditUI)contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));
    }

    protected void closeDetachedPane(JFrame f, OfferEditUI ui) {
        f.dispose();
        this.removeEditPaneFromRef(ui);
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            this.addEditPane(context, data);
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1.0);
            ui.setDividerSize(0);
        }
    }

    OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI)context;
        }
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = this.getUI(context);
        return ui.getEditTabs();
    }

    JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context) {
        JTable listTable = this.getUI((JAXXContext)context).listTable;
        OfferListTableModel tableModel = this.getUI((JAXXContext)context).offerListTableModel;
        int selectedRow = listTable.getSelectedRow();
        this.edit(context, selectedRow, tableModel);
    }

    protected void edit(JAXXContext context, int i, OfferListTableModel model) {
        Form data = null;
        data = (Form)model.getDatas().getFormsToShow().get(i);
        log.debug((Object)("Form selected : " + data));
        if (data != null) {
            this.addEditPane(context, data);
        }
    }

    public static RowFilter<OfferListTableModel, Integer> makeRowFilter(final int itemsPerPage, final int target) {
        return new RowFilter<OfferListTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends OfferListTableModel, ? extends Integer> entry) {
                int ei = entry.getIdentifier();
                return target * itemsPerPage <= ei && ei < target * itemsPerPage + itemsPerPage;
            }
        };
    }

    public void removeColumn(JAXXContext context, TreeNode thesaurus) {
        VradiHelper.removeVradiListColumns(thesaurus);
        this.getUI(context).updateTableModel();
    }
}

