/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.RequestFormViewHandler;
import com.jurismarches.vradi.ui.RequestFormViewUI;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.editors.DateEditor;
import com.jurismarches.vradi.ui.editors.EmailEditor;
import com.jurismarches.vradi.ui.editors.NumEditor;
import com.jurismarches.vradi.ui.editors.StringEditor;
import com.jurismarches.vradi.ui.editors.TextEditor;
import com.jurismarches.vradi.ui.editors.UrlEditor;
import java.awt.Component;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class OfferEditHandler {
    private static final Log log = LogFactory.getLog(OfferEditHandler.class);

    public OfferEditUI initUI(JAXXContext rootContext, Form data) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)data);
        context.add((Object)this);
        context.add((Object)new ThesaurusHandler());
        OfferEditUI ui = new OfferEditUI((JAXXContext)context);
        this.fillfields(ui, data);
        VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        ThesaurusHandler thesaurusHandler = new ThesaurusHandler();
        List<String> thesaurusId = VradiHelper.getVradiListThesaurus();
        Thesaurus rootThesaurus = null;
        try {
            TreeNode rootTreeNode = ServiceHelper.getVradiStorageService().getRootThesaurus();
            rootThesaurus = new Thesaurus(rootTreeNode);
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant get root thesaurus ", (Throwable)e);
        }
        Collection<Thesaurus> thesaurusChildren = rootThesaurus.getChildren();
        ArrayList<Thesaurus> thesaurusSaved = new ArrayList<Thesaurus>();
        log.info((Object)("chidren size : " + thesaurusChildren.size()));
        if (thesaurusChildren == null || thesaurusChildren.isEmpty()) {
            log.info((Object)"Display root");
            ui.getThesaurus().add((Component)((Object)thesaurusHandler.initUI((JAXXContext)context, rootThesaurus, data)));
        } else {
            if (thesaurusId != null) {
                for (String id : thesaurusId) {
                    Thesaurus savedThesaurus = rootThesaurus.findThesaurus(id);
                    if (savedThesaurus == null) continue;
                    thesaurusSaved.add(savedThesaurus);
                    for (Thesaurus child : thesaurusChildren) {
                        child.removeThesaurusRecursivly(id);
                    }
                }
            }
            for (Thesaurus child : thesaurusChildren) {
                ui.getThesaurus().add((Component)((Object)thesaurusHandler.initUI((JAXXContext)context, child, data, false)));
            }
            for (Thesaurus saved : thesaurusSaved) {
                ui.getThesaurus().add((Component)((Object)thesaurusHandler.initUI((JAXXContext)context, saved, data, true)));
            }
        }
        return ui;
    }

    protected void fillfields(OfferEditUI ui, Form data) {
        for (WikittyExtension ext : data.getExtensions()) {
            for (String fieldName : ext.getFieldNames()) {
                FieldType type = ext.getFieldType(fieldName);
                this.createField(ui, ext.getName(), fieldName, type, (BusinessEntity)data);
            }
        }
    }

    protected void createField(OfferEditUI ui, String ext, String fieldName, FieldType type, BusinessEntity data) {
        JPanel content = ui.getContent();
        if (!type.isCollection()) {
            if (FieldTypeEnum.DATE.isType(type) || FieldType.TYPE.DATE.equals((Object)type.getType())) {
                DateEditor editor = new DateEditor();
                editor.setFieldName(fieldName);
                editor.setData((Date)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else if (FieldTypeEnum.EMAIL.isType(type)) {
                EmailEditor editor = new EmailEditor();
                editor.setFieldName(fieldName);
                editor.setData((String)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else if (FieldTypeEnum.NUMBER.isType(type) || FieldType.TYPE.NUMERIC.equals((Object)type.getType())) {
                NumEditor editor = new NumEditor();
                editor.setFieldName(fieldName);
                editor.setData((BigDecimal)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else if (FieldTypeEnum.TEXT.isType(type)) {
                TextEditor editor = new TextEditor();
                editor.setFieldName(fieldName);
                editor.setData((String)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else if (FieldTypeEnum.URL.isType(type)) {
                UrlEditor editor = new UrlEditor();
                editor.setFieldName(fieldName);
                editor.setData((String)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else {
                StringEditor editor = new StringEditor();
                editor.setFieldName(fieldName);
                editor.setData((String)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            }
        }
    }

    OfferEditUI getUI(JAXXContext context) {
        if (context instanceof OfferEditUI) {
            return (OfferEditUI)context;
        }
        OfferEditUI ui = (OfferEditUI)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public void openThesaurusPopup(JAXXContext context) {
    }

    public void openRequestPopup(JAXXContext context, List<String> queries) {
        RequestFormViewHandler handler = new RequestFormViewHandler();
        RequestFormViewUI ui = handler.initUI(context);
        for (String query : queries) {
            ui.getContent().add((Component)new JLabel(query));
        }
        ui.setVisible(true);
    }

    protected void addPropositions(JAXXContext context, Object[] props) {
        for (Object p : props) {
            this.getUI((JAXXContext)context).propositionListModel.removeElement(p);
        }
    }

    protected void save(JAXXContext context, Form form) {
        log.info((Object)("Save form " + form.getName()));
        for (Component c : this.getUI(context).getThesaurus().getComponents()) {
            ThesaurusUI thesaurusUI = (ThesaurusUI)((Object)c);
            DefaultListModel model = thesaurusUI.getThesaurusSelectedModel();
            Object[] selected = model.toArray();
            form.clearThesaurus();
            for (Object s : selected) {
                TreeNode treeNode = (TreeNode)s;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("treeNode to save : " + treeNode.getName() + " in form : " + form.getName()));
                }
                form.addThesaurus(treeNode.getWikittyId());
            }
        }
        form.setStatut(1);
        try {
            ServiceHelper.getVradiStorageService().updateForm(form);
        }
        catch (TechnicalException eee) {
            log.error((Object)("Cant save form : " + form.getName()), (Throwable)eee);
        }
    }

    protected void update(JAXXContext context) {
        VradiMainUIHandler rootHandler = (VradiMainUIHandler)VradiContext.get().getContextValue(VradiMainUIHandler.class);
        rootHandler.goToHome(context);
    }

    protected void add(JAXXContext context) {
        this.openThesaurusPopup(context);
    }

    protected void test(JAXXContext context, Form form) {
        ArrayList<String> queries = new ArrayList();
        try {
            queries = ServiceHelper.getVradiStorageService().getQueriesReturningForm(form);
        }
        catch (TechnicalException eee) {
            log.error((Object)eee);
        }
        this.openRequestPopup(context, queries);
    }

    protected void addFile(JAXXContext context) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.showOpenDialog(this.getUI(context));
        File file = fileChooser.getSelectedFile();
    }

    protected void removeFile(JAXXContext context) {
    }

    public void addThesaurus(JAXXContext context, Thesaurus thesToAdd) {
        for (Component c : this.getUI(context).getThesaurus().getComponents()) {
            ThesaurusUI ui = (ThesaurusUI)((Object)c);
            ThesaurusTreeHelper helper = ui.helper;
            NavigationTreeNode rootNode = helper.getRootNode();
            Thesaurus root = (Thesaurus)rootNode.getBean();
            log.info((Object)("Try to add " + thesToAdd.getName() + " to " + root.getName()));
            if (!root.addChildRecursif(thesToAdd)) continue;
            log.info((Object)"succes");
            helper.setRootThesaurus(root);
            helper.createTreeModel(context);
            ui.getThesaurus().setModel((TreeModel)helper.getTreeModel(context));
            break;
        }
    }
}

