/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.Item;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.*;
import java.util.List;

/**
 * @author morin
 */
public class EmailHandler implements JAXXAction {

    static private final Log log = LogFactory.getLog(EmailHandler.class);

    @Override
    public JAXXInitialContext init(JAXXContext parentContext, Object... datas) {
        return new JAXXInitialContext().add(parentContext).add(this);
    }

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public EmailPopupUI initUI(JAXXContext rootContext, int i) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        // show main ui
        context.add(this);
        EmailPopupUI ui = new EmailPopupUI(context);

        VradiContext.EMAIL_UI_ENTRY_DEF.setContextValue(rootContext, ui);

        ui.changeTab(i);
        ui.setVisible(true);

        return ui;
    }

    EmailPopupUI getUI(JAXXContext context) {
        if (context instanceof EmailPopupUI) {
            return (EmailPopupUI) context;
        }
        EmailPopupUI ui = VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        EmailPopupUI ui = getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    Map<Client, List<Form>> getFormsByClients() {
        Map<Client, List<Form>> result = new HashMap<Client, List<Form>>();
        try {
            result = getVradiStorageService().getFormsByClients();
        } catch (TechnicalException e) {
            e.printStackTrace();
        }
        return result;
    }

    Map<Form, List<Client>> getClientsByForm() {
        Map<Form, List<Client>> result = new HashMap<Form, List<Client>>();
        try {
            result = getVradiStorageService().getClientsByForms();
        } catch (TechnicalException e) {
            e.printStackTrace();
        }
        for (Map.Entry entry : result.entrySet()) {
            log.info(entry.getKey() + " : " + entry.getValue());
        }
        return result;
    }

    public void bindEmailsWithForms() {
        try {
            getVradiStorageService().bindFormsToClients();
        } catch (TechnicalException e) {
            e.printStackTrace();
        }
    }

}