package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

import java.util.List;

/**
 * @author letellier
 */
public class XmlStreamNavigationTreeHelper extends VradiNavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(XmlStreamNavigationTreeHelper.class);

    public XmlStreamNavigationTreeHelper(JAXXContext context) {
        super(XMLSTREAMS.getName(), context);
    }

    @Override
    public NavigationTreeModel createTreeModel() {

        JAXXContext context = getContext();

        List<XmlStream> xmlStreams = XMLSTREAMS.getContextValue(context);

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = builder.buildEmptyRoot(null, "$root");

        NavigationTreeNode xmlStreamNode = builder.build(
                rootNode,
                _(XMLSTREAMS.getName()),
                XMLSTREAMS,
                "xmlStreams",
                AdminXmlStreamUI.class,
                null);

        for (XmlStream x : xmlStreams) {

            builder.addXmlStream(context, xmlStreamNode, x);
        }

        NavigationTreeModel model = builder.getModel();

        if (log.isDebugEnabled()) {
            builder.printModel(model.getRoot());
        }

        // save tree model in context
        setTreeModel(context, model);

        setSelectedNode(context, xmlStreamNode);

        return model;
    }
}
