/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

import java.util.List;

/**
 * @author letellier
 */
public class GroupNavigationTreeHelper extends VradiNavigationTreeHelper {


    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(GroupNavigationTreeHelper.class);

    public GroupNavigationTreeHelper(JAXXContext context) {
        super(GROUPS.getName(), context);
    }

    @Override
    public NavigationTreeModel createTreeModel() {

        JAXXContext context = getContext();

        List<Group> groups = GROUPS.getContextValue(context);

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = builder.buildEmptyRoot(null, "$root");

        NavigationTreeNode groupsNode = builder.build(
                rootNode,
                _(GROUPS.getName()),
                GROUPS,
                "groups",
                AdminGroupUI.class,
                null);

        for (Group g : groups) {

            builder.addGroup(context, groupsNode, g);

        }

        NavigationTreeModel model = builder.getModel();

        if (log.isDebugEnabled()) {
            builder.printModel(model.getRoot());
        }

        // save tree model in context
        setTreeModel(context, model);

        setSelectedNode(context, groupsNode);

        return model;
    }


}