package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.VradiContext;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.EntityComboBox;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.n_;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.DataBindingListener;

public class AdminGroupUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Group> {
    private static String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;
    protected jaxx.runtime.swing.Table adminGroupForm;
    protected com.jurismarches.vradi.services.dto.VradiGroupDTO bean;
    protected jaxx.runtime.swing.ListSelectorUI< Client > groupClients;
    protected javax.swing.JTextField groupName;
    protected jaxx.runtime.swing.ListSelectorUI< User > groupUsers;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    private AdminGroupUI $AdminContentUI0 = this;
    private jaxx.runtime.swing.HidorButton $HidorButton5;
    private javax.swing.JButton $JButton3;
    private javax.swing.JButton $JButton4;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JPanel $JPanel2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource10 = new DataBindingListener(this, "$JLabel1.text");
    private PropertyChangeListener $DataSource12 = new DataBindingListener(this, "$JButton4.enabled");
    private PropertyChangeListener $DataSource17 = new DataBindingListener(this, "groupName.text");
    private PropertyChangeListener $DataSource9 = new DataBindingListener(this, "$AdminContentUI0.enabled");

    /* begin raw body code */    
    
    void $afterCompleteSetup() {
        addPCSLogger();
        addBeanPCSLogger(bean);
        addBeanModifiedPCS(bean);
        groupClients.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from clients");
                    setModified(true);
                }
            }
        });
        groupUsers.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from users");
                    setModified(true);
                }
            }
        });
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        requestListUI.init();
    
        java.util.List<Client> toClientCombo = getHandler().getAllClients(this);
        java.util.List<Client> toClientList = new java.util.ArrayList<Client>(toClientCombo);
    
        for (java.util.Iterator<Client> it = toClientList.iterator(); it.hasNext();) {
            Client client = it.next();
            if (bean.getClient() == null || !bean.getClient().contains(client.getWikittyId())) {
                it.remove();
                if (log.isDebugEnabled()) {
                    log.debug("group does NOT use client " + client.getName());
                }
            } else {
                toClientCombo.remove(client);
                if (log.isDebugEnabled()) {
                    log.debug("group use client " + client.getName());
                }
            }
        }
        groupClients.init(toClientCombo, toClientList);
    
        java.util.List<User> toUserCombo = getHandler().getAllUsers(this);
        java.util.List<User> toUserList = new java.util.ArrayList<User>(toUserCombo);
    
        for (java.util.Iterator<User> it = toUserList.iterator(); it.hasNext();) {
            User user = it.next();
            if (bean.getUser() == null || !bean.getUser().contains(user.getWikittyId())) {
                it.remove();
                if (log.isDebugEnabled()) {
                    log.debug("group does NOT use user " + user.getName());
                }
            } else {
                toUserCombo.remove(user);
                if (log.isDebugEnabled()) {
                    log.debug("group use user " + user.getName());
                }
            }
        }
        groupUsers.init(toUserCombo, toUserList);
    }
    
    @Override
    public void save() {
        if (log.isDebugEnabled()) {
            log.debug("===================================================================================");
            log.debug("group to save " + bean.getName());
        }
        bean.clearClient();
        for (Client client : groupClients.getListDatas()) {
            if (log.isDebugEnabled()) {
                log.debug("add client " + client.getName() + " to group");
            }
            bean.addClient(client.getWikittyId());
        }
        bean.clearUser();
        for (User user : groupUsers.getListDatas()) {
            if (log.isDebugEnabled()) {
                log.debug("add user " + user.getName() + " to group");
            }
            bean.addUser(user.getWikittyId());
        }
    
        Group bean = (Group) getHelper().getSelectedBean(this);
        this.bean.toWikitty(bean);
        getHandler().save(bean);
        getHelper().reloadGroup(this, getHelper().getSelectedNode(this), bean);
        groupClients.setModified(false);
        groupUsers.setModified(false);
        if (log.isDebugEnabled()) {
            log.debug("===================================================================================");
        }
    }
    
    @Override
    protected void updateBeanFromEntity(Group bean) {
        this.bean.fromWikitty(bean);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminGroup.title", getStringValue(name));
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public AdminGroupUI() {
        super();
        $initialize();
    }

    public AdminGroupUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("$AdminContentUI0.enabled".equals($binding)) {    
            if (bean != null) {
                bean.addPropertyChangeListener("wikittyId", $DataSource9);
            }
        } else if ("$JLabel1.text".equals($binding)) {    
            if (bean != null) {
                bean.addPropertyChangeListener("name", $DataSource10);
            }
        } else if ("$JButton4.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource12);
        } else if ("groupName.text".equals($binding)) {    
            if (bean != null) {
                bean.addPropertyChangeListener("name", $DataSource17);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    @Override
    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$AdminContentUI0.enabled".equals($dest)) {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            } else if ("$JLabel1.text".equals($dest)) {
                if (bean != null) {
                    $JLabel1.setText(_(updateTitle(bean.getName())));
                }
            } else if ("$JButton4.enabled".equals($dest)) {
                $JButton4.setEnabled(isEnabled());
            } else if ("groupName.text".equals($dest)) {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(groupName, getStringValue(bean.getName()));
                }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("$AdminContentUI0.enabled".equals($binding)) {    
            if (bean != null) {
                bean.removePropertyChangeListener("wikittyId", $DataSource9);
            }
        } else if ("$JLabel1.text".equals($binding)) {    
            if (bean != null) {
                bean.removePropertyChangeListener("name", $DataSource10);
            }
        } else if ("$JButton4.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource12);
        } else if ("groupName.text".equals($binding)) {    
            if (bean != null) {
                bean.removePropertyChangeListener("name", $DataSource17);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        getHandler().createGroup(this, getHelper());setModified(true);
    }

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doKeyReleased__on__groupName(java.awt.event.KeyEvent event) {
        bean.setName(groupName.getText());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminGroupForm() {
        return adminGroupForm;
    }

    public com.jurismarches.vradi.services.dto.VradiGroupDTO getBean() {
        return bean;
    }

    public jaxx.runtime.swing.ListSelectorUI< Client > getGroupClients() {
        return groupClients;
    }

    public javax.swing.JTextField getGroupName() {
        return groupName;
    }

    public jaxx.runtime.swing.ListSelectorUI< User > getGroupUsers() {
        return groupUsers;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected jaxx.runtime.swing.HidorButton get$HidorButton5() {
        return $HidorButton5;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToToolbar();
        // inline complete setup of $JPanel2
        $JPanel2.add($JButton3);
        $JPanel2.add($JButton4);
        $JPanel2.add($HidorButton5);
        addChildrenToBody();
        addChildrenToAdminGroupForm();
        // init data bindings
        applyDataBinding("$AdminContentUI0.enabled");
        applyDataBinding("$JLabel1.text");
        $JButton4.setIcon(jaxx.runtime.Util.getUIManagerActionIcon("delete"));
        applyDataBinding("$JButton4.enabled");
        $HidorButton5.setCollapseTip(_("vradi.adminGroup.hideForm"));
        $HidorButton5.setExpandTip(_("vradi.adminGroup.showForm"));
        $HidorButton5.setTarget(adminGroupForm);
        $HidorButton5.setTargetVisible(true);
        applyDataBinding("groupName.text");
        groupClients.setAddToComboTip(_("vradi.adminGroup.removeClient"));
        groupClients.setAddToListTip(_("vradi.adminGroup.addClient"));
        groupClients.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        groupUsers.setAddToComboTip(_("vradi.adminGroup.removeGroup"));
        groupUsers.setAddToListTip(_("vradi.adminGroup.addUser"));
        groupUsers.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        requestListUI.setBean(bean);
        $JLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        $JLabel1.setFont(new Font("Serif", Font.BOLD, 26));
        $JLabel1.setHorizontalTextPosition(JLabel.LEFT);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        $JPanel2.setName("$JPanel2");
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("vradi.adminGroup.createGroup"));
        $JButton3.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        $JButton4.setName("$JButton4");
        $JButton4.setToolTipText(_("vradi.adminClient.deleteGroup"));
        $JButton4.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $HidorButton5
        $objectMap.put("$HidorButton5", $HidorButton5 = new jaxx.runtime.swing.HidorButton());
        $HidorButton5.removeDataBinding("hidor.name");
        $HidorButton5.setName("$HidorButton5");
        $HidorButton5.removeDataBinding("hidor.collapseTip");
        $HidorButton5.removeDataBinding("hidor.expandTip");
        $HidorButton5.removeDataBinding("hidor.target");
        $HidorButton5.removeDataBinding("hidor.targetVisible");
        createAdminGroupForm();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("vradi.adminGroup.name"));
        createGroupName();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("vradi.adminGroup.listClients"));
        createGroupClients();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new javax.swing.JLabel());
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("vradi.adminGroup.listUsers"));
        createGroupUsers();
        createRequestListUI();
        // inline creation of $AdminContentUI0
        removeDataBinding("$JPanel0.name");
        setName("$AdminContentUI0");
        removeDataBinding("$JPanel0.enabled");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    protected void addChildrenToAdminGroupForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminGroupForm.add($JLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupClients, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel8, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupUsers, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminGroupForm, BorderLayout.NORTH);
        body.add(requestListUI, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createAdminGroupForm() {
        $objectMap.put("adminGroupForm", adminGroupForm = new jaxx.runtime.swing.Table());
        adminGroupForm.setName("adminGroupForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiGroupDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createGroupClients() {
        $objectMap.put("groupClients", groupClients = new jaxx.runtime.swing.ListSelectorUI< Client >());
        groupClients.removeDataBinding("$JPanel0.name");
        groupClients.setName("groupClients");
        groupClients.removeDataBinding("$JPanel0.addToComboTip");
        groupClients.removeDataBinding("$JPanel0.addToListTip");
        groupClients.removeDataBinding("$JPanel0.renderer");
        groupClients.removeDataBinding("$JPanel0.showHidor");
        groupClients.setShowHidor(true);
        ((javax.swing.JToolBar) groupClients.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupClients.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createGroupName() {
        $objectMap.put("groupName", groupName = new javax.swing.JTextField());
        groupName.setName("groupName");
        groupName.setColumns(15);
        groupName.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__groupName"));
    }

    protected void createGroupUsers() {
        $objectMap.put("groupUsers", groupUsers = new jaxx.runtime.swing.ListSelectorUI< User >());
        groupUsers.removeDataBinding("$JPanel0.name");
        groupUsers.setName("groupUsers");
        groupUsers.removeDataBinding("$JPanel0.addToComboTip");
        groupUsers.removeDataBinding("$JPanel0.addToListTip");
        groupUsers.removeDataBinding("$JPanel0.renderer");
        groupUsers.removeDataBinding("$JPanel0.showHidor");
        groupUsers.setShowHidor(true);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        requestListUI.removeDataBinding("$JPanel0.name");
        requestListUI.setName("requestListUI");
        requestListUI.removeDataBinding("$JPanel0.bean");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

}