package com.jurismarches.vradi.ui.admin;

import java.util.List;
import javax.swing.DefaultComboBoxModel;

import org.sharengo.wikitty.WikittyExtension;

/**
 * @author letellier
 */
public class FormTypeModel extends DefaultComboBoxModel {

    private static final long serialVersionUID = 1L;

    protected WikittyExtension selected = null;
    protected WikittyExtension[] values;

    public FormTypeModel(List<WikittyExtension> formTypes) {
        super();
        values = formTypes.toArray(new WikittyExtension[formTypes.size()]);

    }

    @Override
    public int getSize() {
        return values.length;
    }

    @Override
    public Object getElementAt(int index) {
        return values[index].getName();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        for (WikittyExtension ext : values) {
            if (ext.getName().equals(((String) anItem))) {
                selected = ext;
                break;
            }
        }
    }

    @Override
    public Object getSelectedItem() {
        return selected;
    }
}
