/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.Util;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import java.util.List;

/**
 * @author letellier
 */
public class ThesaurusHandler {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private Log log = LogFactory.getLog(ThesaurusHandler.class);
//    protected List<ThesaurusUI> thesaurusUI;

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @param rootThesaurus
     * @param bean
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public ThesaurusUI initUI(JAXXContext rootContext, Thesaurus rootThesaurus, Form bean) {

        return initUI(rootContext, rootThesaurus, bean, false);
    }

    public ThesaurusUI initUI(JAXXContext rootContext, Thesaurus rootThesaurus, Form bean, boolean deletable) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        // show main ui
        context.add(this);

        // Init thesaurus tree
        ThesaurusTreeHelper helper = new ThesaurusTreeHelper(rootThesaurus);

        // Init ui
        ThesaurusUI ui = new ThesaurusUI(context, helper);
        ui.setDeletable(deletable);
        ui.setBean(bean);

        return ui;
    }

    ThesaurusUI getUI(JAXXContext context) {
        if (context instanceof ThesaurusUI) {
            return (ThesaurusUI) context;
        }
        return null;
    }

    protected OfferEditUI getEditUI(JAXXContext context) {
        return context.getContextValue(OfferEditHandler.class).getUI(context);
    }

    protected OfferListUI getListUI(JAXXContext context) {
        return context.getContextValue(OfferListHandler.class).getUI(context);
    }
    
    public static Thesaurus getRootThesaurus() {
        try {
            TreeNode rootTreeNode = ServiceHelper.getVradiStorageService().getRootThesaurus();
            return new Thesaurus(rootTreeNode);
        } catch (TechnicalException ex) {
            log.error("Cant get thesaurus caused by : " + ex);
        }
        return null;
    }

    protected NavigationTreeNode getParentNode(ThesaurusTreeHelper helper, TreePath path){
        if (path == null){
            return helper.getRootNode();
        } else {
            return (NavigationTreeNode) path.getLastPathComponent();
        }
    }

    public void addCriteria(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        OfferListUI ui = getListUI(context);

        // Get selected thesaurus
        NavigationTreeNode parentNode = getParentNode(helper, path);
        Thesaurus thesaurus = (Thesaurus)parentNode.getBean(context);

        // Adding to offerListUI
        getUI(context).getParentContainer(OfferListUI.class).getHandler().getCriteriaHandler(context).addAndPersistCriteria(context, thesaurus.getBean());

        ui.validate();
    }
    
    public void addThesaurus(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        if (path != null){
            // Get selected thesaurus
            NavigationTreeNode parentNode = (NavigationTreeNode) path.getLastPathComponent();

            // Remove selected from parent
            helper.getBuilder().removeNodeFromParent(context, parentNode);

            // Creating new root
            Thesaurus thesaurusParent = (Thesaurus) parentNode.getBean(context);

            OfferEditUI ui = getEditUI(context);
            addThesaurus(context, thesaurusParent, true, true);
        }
    }

    // Creating child thesorus instance
    public void addThesaurus(JAXXContext context, Thesaurus root, boolean deletable, boolean save) {
        if (root != null){
            // Init thesaurus tree
            ThesaurusTreeHelper helper = new ThesaurusTreeHelper(root);

            ThesaurusUI thesaurusChildUI = new ThesaurusUI(context, helper);

            thesaurusChildUI.setDeletable(deletable);

            getThesaurusContainer(context).add(thesaurusChildUI);

            // Save in properties
            if (save){
                VradiHelper.addVradiListThesaurus(root.getBean());
            }
            
            getUI(context).validate();
        }
    }

    public void addChildToRoot(JAXXContext context, ThesaurusTreeHelper helper) {
        Thesaurus rootThesaurus = getRootThesaurus();

        Thesaurus newThesaurus = addChild(context, rootThesaurus);

        addThesaurus(context, newThesaurus, false, false);
    }

    public void addChildToSelected(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        // Get selected thesaurus
        NavigationTreeNode parentNode = getParentNode(helper, path);
        Thesaurus thesaurusParent = (Thesaurus) parentNode.getBean(context);
        Thesaurus newThesaurus = addChild(context, thesaurusParent);

        if (newThesaurus != null){
            helper.getBuilder().addThesaurus(context, parentNode, newThesaurus);
        }

    }

    protected Thesaurus addChild(JAXXContext context, Thesaurus thesaurusParent){
        // Ask name
        String name = JOptionPane.showInputDialog(getUI(context), _("vradi.thesausur.askName"));

        // If name is not empty
        if (name != null && !name.isEmpty()) {

            // Get storage service
            VradiStorageService service = ServiceHelper.getVradiStorageService();

            // Add new to parent
            TreeNode treeNodeParent = thesaurusParent.getBean();

            // Creating child
            TreeNode newTreeNode = new TreeNodeImpl();
            newTreeNode.setName(name);

            // Add child to parent treeNode
            treeNodeParent.addChildren(newTreeNode.getWikittyId());
            newTreeNode.setParent(treeNodeParent.getWikittyId());

            // Save
            try {
                service.updateThesaurus(treeNodeParent);
                service.updateThesaurus(newTreeNode);

            } catch (TechnicalException ex) {
                log.error("Cant save thsaurus : " + newTreeNode.getWikittyId() + " caused by : ", ex);
            }

            // Creating new thesaurus
            Thesaurus newThesaurus = new Thesaurus(newTreeNode);

            // Add child to parent thesaurus
            thesaurusParent.addChild(newThesaurus);

            // Refresh criteria
            VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue(context).initCriteria(context);

            return newThesaurus;
        }
        return null;
    }

    public void addColumn(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        // Get selected thesaurus
        NavigationTreeNode node = getParentNode(helper, path);

        // Creating new root
        Thesaurus thesaurus = (Thesaurus) node.getBean(context);

        // Save in properties
        VradiHelper.addVradiListColumns(thesaurus.getBean());

        // Refresh model
        getListUI(context).updateTableModel();
    }

    public void closeThesaurus(ThesaurusUI context) {
        OfferEditUI ui = getEditUI(context);
        closeThesaurus(context, context);
        ui.validate();
    }

    // Remove child thesorus instance
    public void closeThesaurus(JAXXContext context, ThesaurusUI thesaurus) {
        getThesaurusContainer(context).remove(thesaurus);

        // Save in properties
        Thesaurus selected = (Thesaurus)thesaurus.helper.getRootNode().getBean();
        VradiHelper.removeVradiListThesaurus(selected.getBean());

        getEditUI(context).getHandler().addThesaurus(context, selected);

        getUI(context).validate();
    }

    protected JPanel getThesaurusContainer(JAXXContext context) {
        return VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(context).getThesaurus();
    }

}
