package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;

import java.util.*;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

import com.jurismarches.vradi.services.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

/**
 * @author letellier
 */
public class OfferListTableModel extends AbstractTableModel {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private Log log = LogFactory.getLog(OfferListTableModel.class);

    public static String NEW_FORM = _("vradi.offer.create");
    protected List<Form> datas;
    protected Map<String, TreeNode> thesaurus;
    protected List<String> columnNames;
    protected boolean creationEnabled;

    public OfferListTableModel(List<Form> datas, boolean creationEnabled) {
        this.creationEnabled = creationEnabled;

        columnNames = new ArrayList<String>();
        columnNames.add(n_("vradi.offer.name"));
        columnNames.add(n_("vradi.offerEdit.datePub"));
        columnNames.add(n_("vradi.offer.statut"));

        // Adding thesaurus to display
        thesaurus = new HashMap<String, TreeNode>();
        List<String> columnsThesaurusId = VradiHelper.getVradiListColumns();
        for (String id : columnsThesaurusId) {
            try {
                TreeNode t = ServiceHelper.getVradiStorageService().getThesaurus(id);
                if (t != null){
                    thesaurus.put(t.getName(), t);
                    columnNames.add(t.getName());
                }
            } catch (TechnicalException e) {
                log.error("Cant get thesaurus : " + id, e);
            }
        }

        this.datas = datas;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames.get(col);
    }

    @Override
    public int getRowCount() {
        int count = datas.size();
        if (creationEnabled){
            count++;
        }
        return count;
    }

    @Override
    public int getColumnCount() {
        return columnNames.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        int rowData = datas.size();
        if (creationEnabled){
            rowData = row - 1;
        }
        // Create
        if (creationEnabled && row == 0) {
            if (col == 0) {
                return NEW_FORM;
            } else {
                return "";
            }
        }
        if (rowData < datas.size() && datas.get(rowData) != null){
            if (col < 3) {
                // Data
                if (col == 0) {
                    return datas.get(rowData).getName();
                } else if (col == 1) {
                    return datas.get(rowData).getDatePub().toString();
                } else if (col == 2) {
                    return datas.get(rowData).getStatut();
                }
            } else {
                // Thesaurus
                Set<String> thesaurusIdOfBean = datas.get(rowData).getThesaurus();

                String result = "";
                if (thesaurusIdOfBean != null){
                    TreeNode thesaurusOfColumns = thesaurus.get(columnNames.get(col - 3));
                    for (String idOfBean : thesaurusIdOfBean){
                        if (thesaurusOfColumns.getChildren().contains(idOfBean)){
                            TreeNode thesaurusToDisplay = null;
                            try {
                                thesaurusToDisplay = ServiceHelper.getVradiStorageService().getThesaurus(idOfBean);
                            } catch (TechnicalException e) {
                                log.error("cant get thesaurus : " + idOfBean, e);
                            }
                            if (thesaurusToDisplay != null){
                                result += thesaurusToDisplay.getName() + ", ";
                            }
                        }
                    }
                    if (result.length() > 0){
                        result = result.substring(0, result.length() - 2);
                    }
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public Class getColumnClass(int c) {
        if (creationEnabled && getRowCount() == 1) {
            return String.class;
        }
        return getValueAt(1, c) == null ? null : getValueAt(1, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public List<Form> getDatas() {
        return datas;
    }

    public void setDatas(List<Form> datas) {
        this.datas = datas;
        fireTableDataChanged();
    }

    public TreeNode getThesaurusByName(String name){
        return thesaurus.get(name);
    }
}
