/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.*;

import javax.swing.*;
import java.util.*;
import java.util.List;

/**
 * @author letellier
 */
public class DateFormTypeFilterHandler {

    static private final Log log = LogFactory.getLog(DateFormTypeFilterHandler.class);

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public DateFormTypeFilterUI initUI(JAXXContext rootContext) {
        DateFormTypeFilterUI ui = getUI(rootContext);
        if (ui == null) {

            JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

            // show main ui
            context.add(this);

            ui = new DateFormTypeFilterUI(context);

            initCriteria(ui);

            context.add(ui);

            VradiContext.CRITERIA_UI_ENTRY_DEF.setContextValue(rootContext, ui);
            VradiContext.CRITERIA_HANDLER_ENTRY_DEF.setContextValue(rootContext, this);
        }

        return ui;
    }

    public DateFormTypeFilterUI getUI(JAXXContext context) {
        if (context instanceof DateFormTypeFilterUI) {
            return (DateFormTypeFilterUI) context;
        }
        return VradiContext.CRITERIA_UI_ENTRY_DEF.getContextValue(context);
    }

    protected JPanel getCriteriaPanel(JAXXContext context) {
        return getUI(context).getCriterias();
    }

    public void initCriteria(JAXXContext context) {
        // Remove existing
        getCriteriaPanel(context).removeAll();

        // Adding root criteria
        TreeNode root = null;
        try {
            root = ServiceHelper.getVradiStorageService().getRootThesaurus();
        } catch (TechnicalException e) {
            log.error("Cant get rootThesaurus : ", e);
        }
        addCriteria(context, root, false);

        // Adding saved criteria
        for (String value : VradiHelper.getVradiListCriteria()) {
            addCriteria(context, value, true);
        }
    }

    public void removeCriteria(JAXXContext context, VradiCriteriaField criteriaField) {
        getCriteriaPanel(context).remove(criteriaField);
        getUI(context).validate();
    }

    public void removeCriteriaAndPersist(JAXXContext context, TreeNode bean) {
        VradiCriteriaField criteriaField = ((VradiCriteriaField) context);
        VradiHelper.removeVradiListCriteria(bean);
        removeCriteria(context, criteriaField);
        getUI(context).validate();
    }

    public void addAndPersistCriteria(JAXXContext context, TreeNode node) {
        VradiHelper.addVradiListCriteria(node);
        addCriteria(context, node, true);
    }

    protected void addCriteria(JAXXContext context, String wikittyId, boolean deletable) {
        TreeNode criteria = null;
        try {
            criteria = ServiceHelper.getVradiStorageService().getThesaurus(wikittyId);
        } catch (TechnicalException e) {
            log.error("Cant get thesaurus : " + wikittyId, e);
        }
        if (criteria != null) {
            addCriteria(context, criteria, deletable);
        }
    }

    protected void addCriteria(JAXXContext context, TreeNode criteria, boolean deletable) {
        Thesaurus thesCriteria = new Thesaurus(criteria);

        // New criteria field
        VradiCriteriaField criteriaField = new VradiCriteriaField(context);

        // Set Name
        criteriaField.setLabelName(criteria.getName());

        // Set bean
        criteriaField.setBean(criteria);

        // Deletable
        criteriaField.setDeletable(deletable);

        // Apply model
        JComboBox combo = criteriaField.getCombo();
        Thesaurus[] thesArray = new Thesaurus[thesCriteria.getChildren().size() + 1];
        for (int i = 1; i < thesArray.length; i++) {
            thesArray[i] = (Thesaurus) thesCriteria.getChildren().toArray()[i - 1];
        }
        combo.setModel(new DefaultComboBoxModel(thesArray));
        combo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());

        // Adding to ui
        criteriaField.init();
        getCriteriaPanel(context).add(criteriaField);
        getUI(context).validate();
    }

    protected List<String> getDateFormType(WikittyExtension formType) {
        List<String> result = new ArrayList<String>();
        result.add(Form.FQ_FIELD_DATEPUB);
        result.add(Form.FQ_FIELD_DATEPEREMPTION);
        if (formType != null) {
            for (String name : formType.getFieldNames()) {
                FieldType type = formType.getFieldType(name);
                if (type.getType() == FieldType.TYPE.DATE) {
                    result.add(formType.getName() + "." + name);
                }
            }
        }
        return result;
    }


    public void updateDateSelectionModel(DateFormTypeFilterUI ui) {
        WikittyExtension value = (WikittyExtension) ui.getFormTypeSelection().getSelectedItem();
        List<String> datas = getDateFormType(value);
        ui.getDateTypeSelection().setModel(new DefaultComboBoxModel(datas.toArray()));
        ui.validate();
    }


}
