package com.jurismarches.vradi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

@jaxx.runtime.context.DefaultApplicationContext.AutoLoad
public class VradiAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(VradiAction.class);
    /**
     * La configuration de l'application.
     */
    protected VradiConfig config;

    public VradiAction() {
    }

    public VradiAction(VradiConfig config) {
        this.config = config;
    }

    public void configure() {
        disableMainUI();
        VradiContext context = VradiContext.get();
//        VradiMainUIHandler handler = context.getContextValue(VradiMainUIHandler.class);
//        handler.showConfig(context);
    }

    public void help() {
        disableMainUI();

        System.out.println(I18n._("vradi.message.help.usage", getConfig().getVersion()));
        System.out.println("Options (set with --option <key> <value>:");
        for (VradiConfig.Option o : VradiConfig.Option.values()) {
            System.out.println("\t" + o.key + "(" + o.defaultValue + "):" + o.description);
        }

        System.out.println("Actions:");
        for (VradiConfig.Action a : VradiConfig.Action.values()) {
            System.out.println("\t" + java.util.Arrays.toString(a.aliases) + "(" + a.action + "):" + a.description);
        }
        System.exit(0);
    }
//
//    public void helpUI() {
//        VradiContext context = VradiContext.get();
////        VradiMainUIHandler handler = context.getContextValue(VradiMainUIHandler.class);
//        VradiHelpBroker helpBroker = context.getContextValue(VradiHelpBroker.class);
//
//        log.debug("no mainUI, open in autonome frame");
//        // ouvrir dans une fenetre dedie
//        JHelp ui = new JHelp(helpBroker.getHelpset());
//        JDialog frame = new JDialog((Frame) null, true);
//        frame.setTitle(_("vradi.help.top.title"));
//        frame.setSize(1024, 800);
//        frame.add(ui);
//        frame.setVisible(true);
//
//        disableMainUI();
//
//        System.exit(0);
//    }

    /**
     * Désactiver la possiblite de lancer l'ui principale.
     */
    public void disableMainUI() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        getConfig().setDisplayMainUI(false);
    }

    protected VradiConfig getConfig() {
        if (config == null) {
            VradiContext context = VradiContext.get();
            config = context.getContextValue(VradiConfig.class);
        }
        return config;
    }
}
